/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.ui;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.widgets.Composite;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.PrefsPageSection;
import org.springsource.ide.eclipse.commons.livexp.ui.StringFieldSection;
import org.springsource.ide.eclipse.commons.quicksearch.core.preferences.QuickSearchPreferences;
import org.springsource.ide.eclipse.commons.quicksearch.ui.QuickSearchActivator;

public class MaxLineLengthSection
extends PrefsPageSection {
    private StringFieldSection input;
    private StringFieldModel model;
    private QuickSearchPreferences prefs = QuickSearchActivator.getDefault().getPreferences();

    public MaxLineLengthSection(IPageWithSections owner) {
        super(owner);
        this.model = new StringFieldModel("Max Line Length", "" + this.prefs.getMaxLineLen());
        this.model.validator((LiveExpression)new Validator(){
            {
                this.dependsOn((LiveExpression)MaxLineLengthSection.this.model.getVariable());
            }

            protected ValidationResult compute() {
                String str = (String)MaxLineLengthSection.this.model.getValue();
                if (str != null) {
                    try {
                        int val = Integer.parseInt(str);
                        if (val <= 0) {
                            return ValidationResult.error((String)"Max Line Length must be a positive integer");
                        }
                        if (val <= 400) {
                            return ValidationResult.warning((String)"Low Max Line Length is likely to cause desirable search results to go missing");
                        }
                    }
                    catch (NumberFormatException e) {
                        return ValidationResult.error((String)"Max Line Length can't be parsed as an integer");
                    }
                }
                return ValidationResult.OK;
            }
        });
        this.input = new StringFieldSection(owner, (FieldModel)this.model);
        this.input.tooltip("When QuickSearch encounters a line of text longer than 'Max Line Length' it stopssearching the current file. This is meant to avoid searching in machine generated text files, such as, minified javascript.");
    }

    public boolean performOK() {
        try {
            IEclipsePreferences store = this.prefs.getStore();
            store.putInt("LineReader.MAX_LINE_LEN", Integer.parseInt((String)this.model.getValue()));
            store.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void performDefaults() {
        this.model.setValue((Object)"1000");
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.input.getValidator();
    }

    public void createContents(Composite page) {
        this.input.createContents(page);
    }
}

