/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.core.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class QuickSearchPreferences {
    public static final String IGNORED_EXTENSIONS = "ignored.extensions";
    public static final String IGNORED_NAMES = "ignored.names";
    public static final String IGNORED_PREFIXES = "ignored.prefixes";
    public static final String MAX_LINE_LEN = "LineReader.MAX_LINE_LEN";
    private IEclipsePreferences store;

    public QuickSearchPreferences(IEclipsePreferences store) {
        this.store = store;
    }

    public IEclipsePreferences getStore() {
        return this.store;
    }

    public String[] getIgnoredExtensions() {
        return this.getAndParseStringList(IGNORED_EXTENSIONS);
    }

    public String[] getIgnoredPrefixes() {
        return this.getAndParseStringList(IGNORED_PREFIXES);
    }

    public String[] getIgnoredNames() {
        return this.getAndParseStringList(IGNORED_NAMES);
    }

    public int getMaxLineLen() {
        return this.store.getInt(MAX_LINE_LEN, 1000);
    }

    private String[] getAndParseStringList(String key) {
        String raw = this.store.get(key, null);
        if (raw != null) {
            return this.parseStringList(raw);
        }
        return null;
    }

    private String[] parseStringList(String raw) {
        String[] elements = raw.split("[,\n]");
        ArrayList<String> list = new ArrayList<String>(elements.length);
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (!"".equals(e = e.trim())) {
                list.add(e);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }
}

