/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.springsource.ide.eclipse.commons.quicksearch.core.priority.DefaultPriorityFunction;
import org.springsource.ide.eclipse.commons.quicksearch.core.priority.PrioriTree;
import org.springsource.ide.eclipse.commons.quicksearch.core.priority.PriorityFunction;
import org.springsource.ide.eclipse.commons.quicksearch.ui.QuickSearchActivator;

public class QuickSearchContext {
    private static Collection<IFile> lastOpenFiles = Arrays.asList(new IFile[0]);
    private IWorkbenchWindow window;

    public QuickSearchContext(IWorkbenchWindow window) {
        this.window = window;
    }

    public PriorityFunction createPriorityFun() {
        PrioriTree priorities = PrioriTree.create();
        priorities.configure(QuickSearchActivator.getDefault().getPreferences());
        try {
            Collection<IResource> selectedResources = this.getSelectedResources();
            for (IResource r : selectedResources) {
                priorities.setPriority(r.getFullPath(), 300.0);
            }
            IFile currentFile = this.getActiveFile();
            if (currentFile != null) {
                priorities.setPriority(currentFile.getFullPath(), 200.0);
            }
            Collection<IFile> openFiles = this.getOpenFiles();
            for (IFile file : openFiles) {
                priorities.setPriority(file.getFullPath(), 100.0);
            }
            return priorities;
        }
        catch (Throwable e) {
            QuickSearchActivator.log(e);
            return new DefaultPriorityFunction();
        }
    }

    private Collection<IFile> getOpenFiles() {
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            ArrayList<IFile> files = new ArrayList<IFile>();
            IEditorReference[] editors = page.getEditorReferences();
            if (editors != null) {
                IEditorReference[] iEditorReferenceArray = editors;
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editor = iEditorReferenceArray[n2];
                    try {
                        IFile file;
                        IEditorInput input = editor.getEditorInput();
                        if (input != null && (file = (IFile)input.getAdapter(IFile.class)) != null) {
                            files.add(file);
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    ++n2;
                }
                lastOpenFiles = files;
                return files;
            }
        }
        return lastOpenFiles;
    }

    private IFile getActiveFile() {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) != null) {
            return (IFile)input.getAdapter(IFile.class);
        }
        return null;
    }

    private Collection<IResource> getSelectedResources() {
        IStructuredSelection s;
        ISelection _s = this.window.getSelectionService().getSelection();
        if (_s != null && _s instanceof IStructuredSelection && (s = (IStructuredSelection)_s) != null && !s.isEmpty()) {
            Object[] elements = s.toArray();
            ArrayList<IResource> resources = new ArrayList<IResource>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable ae;
                IResource r;
                Object e = objectArray[n2];
                if (e instanceof IResource) {
                    resources.add((IResource)e);
                } else if (e instanceof IAdaptable && (r = (IResource)(ae = (IAdaptable)e).getAdapter(IResource.class)) != null) {
                    resources.add(r);
                }
                ++n2;
            }
            return resources;
        }
        return Collections.emptyList();
    }
}

