/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.ui;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.PreferencePageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.PrefsGroupSection;
import org.springsource.ide.eclipse.commons.livexp.ui.PrefsPageSection;
import org.springsource.ide.eclipse.commons.quicksearch.core.preferences.QuickSearchPreferences;
import org.springsource.ide.eclipse.commons.quicksearch.core.priority.DefaultPriorityFunction;
import org.springsource.ide.eclipse.commons.quicksearch.ui.QuickSearchActivator;

public class QuickSearchIgnoreSection
extends PrefsPageSection {
    private static final String[] prefsKeys = new String[]{"ignored.extensions", "ignored.prefixes", "ignored.names"};
    private static final String[] fieldNames = new String[]{"Extensions", "Prefixes", "Names"};
    private static final String[] toolTips = new String[]{"Enter a list of file extensions. Elements in the list can be separated by commas or newlines.Any file or folder ending with one of the extensions will be ignored.", "Enter a list of file prefixes. Elements in the list can be separated by commas or newlines.Any file or folder who's name begins with one of the extensions will be ignored.", "Enter a list of file names. Elements in the list can be separated by commas or newlines.Any file or folder who's name equals one of the extensions will be ignored."};
    private QuickSearchPreferences prefs;
    private IEclipsePreferences prefsStore;
    private PrefsGroupSection group;
    private DefaultPriorityFunction defaultPriorityFun = new DefaultPriorityFunction();

    public QuickSearchIgnoreSection(PreferencePageWithSections owner) {
        super((IPageWithSections)owner);
        this.prefs = QuickSearchActivator.getDefault().getPreferences();
        this.prefsStore = this.prefs.getStore();
        String[] defaultIgnores = new String[]{this.withSeparator(", ", this.defaultPriorityFun.ignoredExtensions), this.withSeparator(", ", this.defaultPriorityFun.ignoredPrefixes), this.withSeparator(", ", this.defaultPriorityFun.ignoredNames)};
        PrefsPageSection[] fields = new IgnoreListField[prefsKeys.length];
        int i = 0;
        while (i < prefsKeys.length) {
            fields[i] = new IgnoreListField(owner, fieldNames[i], prefsKeys[i], defaultIgnores[i], toolTips[i]);
            ++i;
        }
        this.group = new PrefsGroupSection(owner, "Ignore", fields);
    }

    public boolean performOK() {
        boolean result = this.group.performOK();
        if (result) {
            try {
                this.prefsStore.flush();
            }
            catch (BackingStoreException e) {
                QuickSearchActivator.log(e);
            }
        }
        return result;
    }

    public void performDefaults() {
        this.group.performDefaults();
    }

    private String withSeparator(String string, String[] strings) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(strings[i]);
            ++i;
        }
        return buf.toString();
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.group.getValidator();
    }

    public void createContents(Composite parent) {
        this.group.createContents(parent);
    }

    private class IgnoreListField
    extends PrefsPageSection {
        private static final int HEIGHT_HINT = 40;
        private static final int FIELD_INDENT = 30;
        Label label;
        Text text;
        private String prefsKey;
        private String labelText;
        private String defaultValue;
        private String tooltip;

        public IgnoreListField(PreferencePageWithSections owner, String labelText, String prefsKey, String defaultValue, String tooltip) {
            super((IPageWithSections)owner);
            this.labelText = labelText;
            this.defaultValue = defaultValue;
            this.prefsKey = prefsKey;
            this.defaultValue = defaultValue;
            this.tooltip = tooltip;
        }

        public boolean performOK() {
            QuickSearchIgnoreSection.this.prefsStore.put(this.prefsKey, this.text.getText());
            return true;
        }

        public void performDefaults() {
            this.text.setText(this.defaultValue);
        }

        public LiveExpression<ValidationResult> getValidator() {
            return Validator.constant((Object)ValidationResult.OK);
        }

        public void createContents(Composite parent) {
            GridDataFactory alignLabel = GridDataFactory.fillDefaults().align(1, 1);
            GridDataFactory grabHorizontal = GridDataFactory.fillDefaults().grab(true, false);
            this.label = new Label(parent, 0);
            this.label.setText(this.labelText);
            alignLabel.applyTo((Control)this.label);
            this.label.setToolTipText(this.tooltip);
            this.text = new Text(parent, 2882);
            grabHorizontal.hint(-1, 40).indent(30, 0).applyTo((Control)this.text);
            this.text.setText(QuickSearchIgnoreSection.this.prefsStore.get(this.prefsKey, this.defaultValue));
            this.text.setToolTipText(this.tooltip);
        }
    }
}

