/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.ui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springsource.ide.eclipse.commons.quicksearch.core.preferences.QuickSearchPreferences;
import org.springsource.ide.eclipse.commons.quicksearch.ui.MultilineStringFieldEditor;
import org.springsource.ide.eclipse.commons.quicksearch.ui.QuickSearchActivator;

public class QuickSearchPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String[] prefsKeys = new String[]{"ignored.extensions", "ignored.prefixes", "ignored.names"};
    private static final String[] fieldNames = new String[]{"Extensions", "Prefixes", "Names"};
    private static final String[] toolTips = new String[]{"Enter a list of file extensions. Elements in the list can be separated by commas or newlines.Any file or folder ending with one of the extensions will be ignored.", "Enter a list of file prefixes. Elements in the list can be separated by commas or newlines.Any file or folder who's name begins with one of the extensions will be ignored.", "Enter a list of file names. Elements in the list can be separated by commas or newlines.Any file or folder who's name equals one of the extensions will be ignored."};

    public QuickSearchPreferencesPage() {
        super(1);
        this.setPreferenceStore(QuickSearchActivator.getDefault().getPreferenceStore());
        QuickSearchPreferences.initializeDefaults();
    }

    public void init(IWorkbench arg0) {
    }

    protected void createFieldEditors() {
        IntegerFieldEditor field_maxLineLen = new IntegerFieldEditor("LineReader.MAX_LINE_LEN", "Max Line Length", this.getFieldEditorParent());
        field_maxLineLen.getTextControl(this.getFieldEditorParent()).setToolTipText("When QuickSearch encounters a line of text longer than 'Max Line Length' it stops searching the current file. This is meant to avoid searching in machine generated text files, such as, minified javascript.");
        this.addField((FieldEditor)field_maxLineLen);
        int i = 0;
        while (i < fieldNames.length) {
            MultilineStringFieldEditor field = new MultilineStringFieldEditor(prefsKeys[i], "Ignore " + fieldNames[i], this.getFieldEditorParent());
            field.getTextControl().setToolTipText(toolTips[i]);
            this.addField(field);
            ++i;
        }
    }
}

