/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.core.pathmatch;

import org.eclipse.core.resources.IResource;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;
import org.springsource.ide.eclipse.commons.quicksearch.core.pathmatch.ResourceMatcher;

public class ResourceMatchers {
    public static ResourceMatcher ANY = new ResourceMatcher(){

        public String toString() {
            return "ResourceMatcher(ANY)";
        }

        @Override
        public boolean matches(IResource resource) {
            return true;
        }
    };

    public static ResourceMatcher commaSeparatedPaths(String text) {
        if ((text = text.trim()).isEmpty()) {
            return ANY;
        }
        String[] paths = text.split(",");
        if (paths.length == 1) {
            return ResourceMatchers.path(paths[0]);
        }
        ResourceMatcher[] matchers = new ResourceMatcher[paths.length];
        int i = 0;
        while (i < matchers.length) {
            matchers[i] = ResourceMatchers.path(paths[i]);
            ++i;
        }
        return ResourceMatchers.either(matchers);
    }

    private static ResourceMatcher either(final ResourceMatcher ... matchers) {
        return new ResourceMatcher(){

            public String toString() {
                StringBuilder buf = new StringBuilder("ResourceMatcher(");
                int i = 0;
                while (i < matchers.length) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(matchers[i]);
                    ++i;
                }
                buf.append(")");
                return buf.toString();
            }

            @Override
            public boolean matches(IResource resource) {
                ResourceMatcher[] resourceMatcherArray = matchers;
                int n = matchers.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceMatcher m = resourceMatcherArray[n2];
                    if (m.matches(resource)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    private static ResourceMatcher path(final String path) {
        try {
            final IMatcher matcher = PathMatcher.createPathMatcher((String)path, (Character)Character.valueOf('/'), (boolean)false);
            return new ResourceMatcher(){

                public String toString() {
                    return path;
                }

                @Override
                public boolean matches(IResource resource) {
                    return matcher.matches(resource.getFullPath().toString(), resource.getType() == 2, false);
                }
            };
        }
        catch (InvalidPatternException e) {
            return ANY;
        }
    }
}

