/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.core;

import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.springsource.ide.eclipse.commons.quicksearch.core.LineItem;
import org.springsource.ide.eclipse.commons.quicksearch.core.QuickTextQuery;
import org.springsource.ide.eclipse.commons.quicksearch.core.QuickTextSearchRequestor;
import org.springsource.ide.eclipse.commons.quicksearch.core.ResourceWalker;
import org.springsource.ide.eclipse.commons.quicksearch.core.pathmatch.ResourceMatcher;
import org.springsource.ide.eclipse.commons.quicksearch.core.pathmatch.ResourceMatchers;
import org.springsource.ide.eclipse.commons.quicksearch.core.priority.PriorityFunction;
import org.springsource.ide.eclipse.commons.quicksearch.util.JobUtil;
import org.springsource.ide.eclipse.commons.quicksearch.util.LineReader;

public class QuickTextSearcher {
    private final QuickTextSearchRequestor requestor;
    private QuickTextQuery query;
    private Set<LineItem> matches = new HashSet<LineItem>(2000);
    private ISchedulingRule matchesRule = JobUtil.lightRule("QuickSearchMatchesRule");
    private SearchInFilesWalker walker = null;
    private IncrementalUpdateJob incrementalUpdate;
    private QuickTextQuery newQuery;
    private int maxResults = 200;
    private int MAX_LINE_LEN;
    private IFile currentFile = null;
    private boolean forceRefresh = false;
    private ResourceMatcher pathMatcher = ResourceMatchers.ANY;

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public QuickTextSearcher(QuickTextQuery query, final PriorityFunction priorities, int maxLineLen, QuickTextSearchRequestor requestor) {
        this.MAX_LINE_LEN = maxLineLen;
        this.requestor = requestor;
        this.query = query;
        this.walker = this.createWalker(new PriorityFunction(){

            @Override
            public double priority(IResource r) {
                double basePriority = priorities.priority(r);
                if (basePriority == Double.NEGATIVE_INFINITY) {
                    return basePriority;
                }
                if (r.getType() == 1 && !QuickTextSearcher.this.pathMatcher.matches(r)) {
                    return Double.NEGATIVE_INFINITY;
                }
                return basePriority;
            }
        });
    }

    private SearchInFilesWalker createWalker(PriorityFunction priorities) {
        SearchInFilesWalker job = new SearchInFilesWalker();
        job.setPriorityFun(priorities);
        job.setRule(this.matchesRule);
        job.schedule();
        return job;
    }

    private void add(LineItem line) {
        if (this.matches.add(line)) {
            this.requestor.add(line);
            if (this.matches.size() >= this.maxResults) {
                this.walker.suspend();
            }
        }
    }

    public void setQuery(QuickTextQuery newQuery, boolean force) {
        if (newQuery.equalsFilter(this.query) && !force) {
            return;
        }
        this.newQuery = newQuery;
        this.forceRefresh = true;
        this.scheduleIncrementalUpdate();
    }

    public void setPathMatcher(ResourceMatcher pathMatcher) {
        if (this.pathMatcher.equals(pathMatcher)) {
            return;
        }
        this.pathMatcher = pathMatcher;
        this.setQuery(this.query, true);
    }

    public QuickTextQuery getQuery() {
        return this.newQuery != null ? this.newQuery : this.query;
    }

    private synchronized void scheduleIncrementalUpdate() {
        this.walker.suspend();
        if (this.incrementalUpdate != null) {
            this.incrementalUpdate.cancel();
        }
        this.incrementalUpdate = new IncrementalUpdateJob();
        this.incrementalUpdate.schedule();
    }

    public boolean isDone() {
        return this.walker != null && this.walker.isDone();
    }

    public void requestMoreResults() {
        if (this.walker != null && !this.walker.isDone()) {
            this.walker.requestMoreResults();
        }
    }

    public void cancel() {
        if (this.walker != null) {
            this.walker.cancel();
            this.walker = null;
        }
    }

    public IFile getCurrentFile() {
        return this.currentFile;
    }

    private class IncrementalUpdateJob
    extends Job {
        public IncrementalUpdateJob() {
            super("Update matches");
            this.setRule(QuickTextSearcher.this.matchesRule);
        }

        protected IStatus run(IProgressMonitor monitor) {
            QuickTextQuery nq = QuickTextSearcher.this.newQuery;
            if (!QuickTextSearcher.this.forceRefresh && QuickTextSearcher.this.query.isSubFilter(nq)) {
                QuickTextSearcher.this.query = nq;
                this.performIncrementalUpdate(monitor);
            } else {
                QuickTextSearcher.this.query = nq;
                QuickTextSearcher.this.forceRefresh = false;
                this.performRestart(monitor);
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        private void performIncrementalUpdate(IProgressMonitor mon) {
            Iterator items = QuickTextSearcher.this.matches.iterator();
            while (items.hasNext() && !mon.isCanceled()) {
                LineItem item = (LineItem)items.next();
                if (QuickTextSearcher.this.query.matchItem(item)) {
                    QuickTextSearcher.this.requestor.update(item);
                    continue;
                }
                items.remove();
                QuickTextSearcher.this.requestor.revoke(item);
            }
            if (!mon.isCanceled()) {
                QuickTextSearcher.this.walker.resume();
            }
        }

        private void performRestart(IProgressMonitor mon) {
            if (QuickTextSearcher.this.walker != null) {
                QuickTextSearcher.this.matches.clear();
                QuickTextSearcher.this.requestor.clear();
                QuickTextSearcher.this.walker.cancel();
                if (!QuickTextSearcher.this.query.isTrivial()) {
                    QuickTextSearcher.this.walker.init();
                    QuickTextSearcher.this.walker.resume();
                }
            }
        }
    }

    private final class SearchInFilesWalker
    extends ResourceWalker {
        private SearchInFilesWalker() {
        }

        @Override
        protected void visit(IFile f, IProgressMonitor mon) {
            if (this.checkCanceled(mon)) {
                return;
            }
            LineReader lr = null;
            QuickTextSearcher.this.currentFile = f;
            try {
                lr = new LineReader(new InputStreamReader(f.getContents(true), f.getCharset()), QuickTextSearcher.this.MAX_LINE_LEN);
                String line = null;
                int lineIndex = 1;
                while ((line = lr.readLine()) != null) {
                    int offset = lr.getLastLineOffset();
                    if (this.checkCanceled(mon)) {
                        return;
                    }
                    try {
                        boolean found = QuickTextSearcher.this.query.matchItem(line);
                        if (found) {
                            LineItem lineItem = new LineItem(f, line, lineIndex, offset);
                            QuickTextSearcher.this.add(lineItem);
                        }
                        ++lineIndex;
                        continue;
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            finally {
                QuickTextSearcher.this.currentFile = null;
                if (lr != null) {
                    lr.close();
                }
            }
        }

        @Override
        public void resume() {
            if (QuickTextSearcher.this.matches.size() < QuickTextSearcher.this.maxResults) {
                super.resume();
            }
        }

        private boolean checkCanceled(IProgressMonitor mon) {
            return mon.isCanceled();
        }

        public void requestMoreResults() {
            int currentSize = QuickTextSearcher.this.matches.size();
            QuickTextSearcher.this.maxResults = Math.max(QuickTextSearcher.this.maxResults, currentSize + currentSize / 10);
            this.resume();
        }
    }
}

