/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.quicksearch.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.search.internal.ui.text.DecoratingFileSearchLabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.progress.UIJob;
import org.springsource.ide.eclipse.commons.quicksearch.core.LineItem;
import org.springsource.ide.eclipse.commons.quicksearch.core.QuickTextQuery;
import org.springsource.ide.eclipse.commons.quicksearch.core.QuickTextSearchRequestor;
import org.springsource.ide.eclipse.commons.quicksearch.core.QuickTextSearcher;
import org.springsource.ide.eclipse.commons.quicksearch.ui.QuickSearchActivator;
import org.springsource.ide.eclipse.commons.quicksearch.ui.QuickSearchContext;
import org.springsource.ide.eclipse.commons.quicksearch.util.DocumentFetcher;
import org.springsource.ide.eclipse.commons.quicksearch.util.TableResizeHelper;

public class QuickSearchDialog
extends SelectionStatusDialog {
    public static final StyledString.Styler HIGHLIGHT_STYLE = DecoratingFileSearchLabelProvider.HIGHLIGHT_STYLE;
    private UIJob refreshJob = new UIJob("Refresh"){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            QuickSearchDialog.this.refresh();
            return Status.OK_STATUS;
        }
    };
    private UIJob progressJob = new UIJob("Refresh"){
        int animate;
        {
            this.animate = 0;
        }

        protected String dots(int animate) {
            char[] chars = new char[animate];
            int i = 0;
            while (i < chars.length) {
                chars[i] = 46;
                ++i;
            }
            return new String(chars);
        }

        protected String currentFileInfo(IFile currentFile, int animate) {
            if (currentFile != null) {
                String path = currentFile.getFullPath().toString();
                if (path.length() <= 30) {
                    return path;
                }
                return "..." + path.substring(path.length() - 30);
            }
            return this.dots(animate);
        }

        public IStatus runInUIThread(IProgressMonitor mon) {
            if (!mon.isCanceled() && QuickSearchDialog.this.progressLabel != null && !QuickSearchDialog.this.progressLabel.isDisposed()) {
                if (QuickSearchDialog.this.searcher == null || QuickSearchDialog.this.searcher.isDone()) {
                    QuickSearchDialog.this.progressLabel.setText(QuickSearchDialog.EMPTY_STRING);
                } else {
                    QuickSearchDialog.this.progressLabel.setText("Searching" + this.currentFileInfo(QuickSearchDialog.this.searcher.getCurrentFile(), this.animate));
                    this.animate = (this.animate + 1) % 4;
                    this.schedule(333L);
                }
            }
            return Status.OK_STATUS;
        }
    };
    public final StyledCellLabelProvider LINE_NUMBER_LABEL_PROVIDER = new StyledCellLabelProvider(){

        public void update(ViewerCell cell) {
            LineItem item = (LineItem)cell.getElement();
            if (item != null) {
                cell.setText(QuickSearchDialog.EMPTY_STRING + item.getLineNumber());
            } else {
                cell.setText("?");
            }
            cell.setImage(QuickSearchDialog.this.getBlankImage());
        }
    };
    private static final Color GREY = Display.getCurrent().getSystemColor(16);
    private final StyledCellLabelProvider LINE_TEXT_LABEL_PROVIDER = new StyledCellLabelProvider(){

        public void update(ViewerCell cell) {
            LineItem item = (LineItem)cell.getElement();
            if (item != null) {
                StyledString text = QuickSearchDialog.this.highlightMatches(item.getText());
                cell.setText(text.getString());
                cell.setStyleRanges(text.getStyleRanges());
            } else {
                cell.setText(QuickSearchDialog.EMPTY_STRING);
                cell.setStyleRanges(null);
            }
            cell.setImage(QuickSearchDialog.this.getBlankImage());
            super.update(cell);
        }
    };
    private Image blankImage;
    private final StyledCellLabelProvider LINE_FILE_LABEL_PROVIDER = new StyledCellLabelProvider(){

        public void update(ViewerCell cell) {
            LineItem item = (LineItem)cell.getElement();
            if (item != null) {
                IPath path = item.getFile().getFullPath();
                String name = path.lastSegment();
                String dir = path.removeLastSegments(1).toString();
                cell.setText(String.valueOf(name) + " - " + dir);
                StyleRange[] styleRanges = new StyleRange[]{new StyleRange(name.length(), dir.length() + 3, GREY, null)};
                cell.setStyleRanges(styleRanges);
            } else {
                cell.setText(QuickSearchDialog.EMPTY_STRING);
                cell.setStyleRanges(null);
            }
            cell.setImage(QuickSearchDialog.this.getBlankImage());
            super.update(cell);
        }
    };
    private static final String DIALOG_SETTINGS = String.valueOf(QuickSearchDialog.class.getName()) + ".DIALOG_SETTINGS";
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_COLUMNS = "COLUMN_WIDTHS";
    private static final String DIALOG_SASH_WEIGHTS = "SASH_WEIGHTS";
    private static final String DIALOG_LAST_QUERY = "LAST_QUERY";
    private static final String CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final boolean CASE_SENSITIVE_DEFAULT = true;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private Text pattern;
    private TableViewer list;
    private MenuManager menuManager;
    private MenuManager contextMenuManager;
    private boolean multi;
    private ToolBar toolBar;
    private ToolItem toolItem;
    private Label progressLabel;
    private IStatus status;
    private ContentProvider contentProvider;
    private String initialPatternText;
    private int selectionMode;
    private static final String EMPTY_STRING = "";
    private final int MAX_LINE_LEN;
    private IHandlerActivation showViewHandler;
    private QuickTextSearcher searcher;
    private StyledText details;
    private DocumentFetcher documents;
    private ToggleCaseSensitiveAction toggleCaseSensitiveAction;
    private QuickSearchContext context;
    private SashForm sashForm;
    private Label headerLabel;

    private Image getBlankImage() {
        if (this.blankImage == null) {
            this.blankImage = new Image((Device)Display.getDefault(), 1, 1);
        }
        return this.blankImage;
    }

    public QuickSearchDialog(IWorkbenchWindow window) {
        super(window.getShell());
        this.setTitle("Quick Text Search");
        this.context = new QuickSearchContext(window);
        this.multi = false;
        this.contentProvider = new ContentProvider();
        this.selectionMode = 0;
        this.MAX_LINE_LEN = QuickSearchActivator.getDefault().getPreferences().getMaxLineLen();
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
    }

    protected void restoreDialog(IDialogSettings settings) {
        try {
            if (this.initialPatternText == null) {
                String lastSearch = settings.get(DIALOG_LAST_QUERY);
                if (lastSearch == null) {
                    lastSearch = EMPTY_STRING;
                }
                this.pattern.setText(lastSearch);
                this.pattern.setSelection(0, lastSearch.length());
            }
            if (settings.getArray(DIALOG_COLUMNS) != null) {
                String[] columnWidths = settings.getArray(DIALOG_COLUMNS);
                Table table = this.list.getTable();
                int cols = table.getColumnCount();
                int i = 0;
                while (i < cols) {
                    TableColumn col = table.getColumn(i);
                    try {
                        if (col != null) {
                            col.setWidth(Integer.valueOf(columnWidths[i]).intValue());
                        }
                    }
                    catch (Throwable e) {
                        QuickSearchActivator.log(e);
                    }
                    ++i;
                }
            }
            if (settings.getArray(DIALOG_SASH_WEIGHTS) != null) {
                String[] _weights = settings.getArray(DIALOG_SASH_WEIGHTS);
                int[] weights = new int[_weights.length];
                int i = 0;
                while (i < weights.length) {
                    weights[i] = Integer.valueOf(_weights[i]);
                    ++i;
                }
                this.sashForm.setWeights(weights);
            }
        }
        catch (Throwable e) {
            QuickSearchActivator.log(e);
        }
    }

    public boolean close() {
        this.progressJob.cancel();
        this.progressJob = null;
        if (this.showViewHandler != null) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            service.deactivateHandler(this.showViewHandler);
            this.showViewHandler.getHandler().dispose();
            this.showViewHandler = null;
        }
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
        }
        this.storeDialog(this.getDialogSettings());
        if (this.searcher != null) {
            this.searcher.cancel();
        }
        return super.close();
    }

    protected void storeDialog(IDialogSettings settings) {
        Table table;
        String currentSearch = this.pattern.getText();
        settings.put(DIALOG_LAST_QUERY, currentSearch);
        if (this.toggleCaseSensitiveAction != null) {
            settings.put(CASE_SENSITIVE, this.toggleCaseSensitiveAction.isChecked());
        }
        if ((table = this.list.getTable()).getColumnCount() > 0) {
            String[] columnWidths = new String[table.getColumnCount()];
            int i = 0;
            while (i < columnWidths.length) {
                columnWidths[i] = EMPTY_STRING + table.getColumn(i).getWidth();
                ++i;
            }
            settings.put(DIALOG_COLUMNS, columnWidths);
        }
        if (this.sashForm.getWeights() != null) {
            int[] w = this.sashForm.getWeights();
            String[] ws = new String[w.length];
            int i = 0;
            while (i < ws.length) {
                ws[i] = EMPTY_STRING + w[i];
                ++i;
            }
            settings.put(DIALOG_SASH_WEIGHTS, ws);
        }
    }

    private Label createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        this.headerLabel = new Label(header, 0);
        this.headerLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    QuickSearchDialog.this.pattern.setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        this.headerLabel.setLayoutData((Object)gd);
        this.createViewMenu(header);
        header.setLayoutData((Object)gd);
        this.refreshHeaderLabel();
        return this.headerLabel;
    }

    private void refreshHeaderLabel() {
        String msg = this.toggleCaseSensitiveAction.isChecked() ? "Case SENSITIVE" : "Case INSENSITIVE";
        msg = String.valueOf(msg) + " Pattern (? = any character, * = any string)";
        this.headerLabel.setText(msg);
    }

    private Label createLabels(Composite parent) {
        Composite labels = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labels.setLayout((Layout)layout);
        Label listLabel = new Label(labels, 0);
        listLabel.setText(WorkbenchMessages.FilteredItemsSelectionDialog_listLabel);
        listLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    QuickSearchDialog.this.list.getTable().setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        listLabel.setLayoutData((Object)gd);
        this.progressLabel = new Label(labels, 131072);
        this.progressLabel.setLayoutData((Object)gd);
        labels.setLayoutData((Object)gd);
        return listLabel;
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)data);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                QuickSearchDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(WorkbenchImages.getImage((String)"IMG_LCL_VIEW_MENU"));
        this.toolItem.setToolTipText(WorkbenchMessages.FilteredItemsSelectionDialog_menu);
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickSearchDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                QuickSearchDialog.this.showViewMenu();
                return null;
            }
        };
        this.showViewHandler = service.activateHandler("org.eclipse.ui.window.showViewMenu", (IHandler)handler, (Expression)new ActiveShellExpression(this.getShell()));
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        this.toggleCaseSensitiveAction = new ToggleCaseSensitiveAction(this.getDialogSettings());
        menuManager.add((IAction)this.toggleCaseSensitiveAction);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected void fillContextMenu(IMenuManager menuManager) {
    }

    private void createPopupMenu() {
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                QuickSearchDialog.this.fillContextMenu(manager);
            }
        });
        Table table = this.list.getTable();
        Menu menu = this.contextMenuManager.createContextMenu((Control)table);
        table.setMenu(menu);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QuickSearchDialog.this.dispose();
            }
        });
        Composite content = new Composite(dialogArea, 0);
        GridData gd = new GridData(1808);
        content.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        final Label headerLabel = this.createHeader(content);
        this.pattern = new Text(content, 2436);
        this.pattern.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LegacyActionTools.removeMnemonics((String)headerLabel.getText());
            }
        });
        gd = new GridData(768);
        this.pattern.setLayoutData((Object)gd);
        final Label listLabel = this.createLabels(content);
        this.sashForm = new SashForm(content, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sashForm);
        this.list = new TableViewer((Composite)this.sashForm, (this.multi ? 2 : 4) | 0x10000 | 0x800 | 0x200 | 0x10000000);
        this.list.getTable().setHeaderVisible(true);
        this.list.getTable().setLinesVisible(true);
        this.list.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = LegacyActionTools.removeMnemonics((String)listLabel.getText());
                }
            }
        });
        this.list.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerColumn col = new TableViewerColumn(this.list, 131072);
        col.setLabelProvider((CellLabelProvider)this.LINE_NUMBER_LABEL_PROVIDER);
        col.getColumn().setText("Line");
        col.getColumn().setWidth(40);
        col = new TableViewerColumn(this.list, 16384);
        col.getColumn().setText("Text");
        col.setLabelProvider((CellLabelProvider)this.LINE_TEXT_LABEL_PROVIDER);
        col.getColumn().setWidth(400);
        col = new TableViewerColumn(this.list, 16384);
        col.getColumn().setText("Path");
        col.setLabelProvider((CellLabelProvider)this.LINE_FILE_LABEL_PROVIDER);
        col.getColumn().setWidth(150);
        new TableResizeHelper(this.list).enableResizing();
        this.list.setInput((Object)new Object[0]);
        this.list.setItemCount(this.contentProvider.getNumberOfElements());
        gd = new GridData(1808);
        QuickSearchDialog.applyDialogFont((Control)this.list.getTable());
        gd.heightHint = this.list.getTable().getItemHeight() * 15;
        this.list.getTable().setLayoutData((Object)gd);
        this.createPopupMenu();
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuickSearchDialog.this.applyFilter();
            }
        });
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && QuickSearchDialog.this.list.getTable().getItemCount() > 0) {
                    QuickSearchDialog.this.list.getTable().setFocus();
                    QuickSearchDialog.this.list.getTable().select(0);
                    QuickSearchDialog.this.refreshDetails();
                }
            }
        });
        this.list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                QuickSearchDialog.this.handleSelected(selection);
            }
        });
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                QuickSearchDialog.this.handleDoubleClick();
            }
        });
        this.list.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection;
                if (e.keyCode == 0x1000001 && (e.stateMask & 0x20000) == 0 && (e.stateMask & 0x40000) == 0 && (selection = (StructuredSelection)QuickSearchDialog.this.list.getSelection()).size() == 1) {
                    Object element = selection.getFirstElement();
                    if (element.equals(QuickSearchDialog.this.list.getElementAt(0))) {
                        QuickSearchDialog.this.pattern.setFocus();
                    }
                    QuickSearchDialog.this.list.getTable().notifyListeners(13, new Event());
                }
                if (e.keyCode == 0x1000002 && (e.stateMask & 0x20000) != 0 && (e.stateMask & 0x40000) != 0) {
                    QuickSearchDialog.this.list.getTable().notifyListeners(13, new Event());
                }
            }
        });
        this.createDetailsArea((Composite)this.sashForm);
        this.sashForm.setWeights(new int[]{5, 1});
        QuickSearchDialog.applyDialogFont((Control)content);
        this.restoreDialog(this.getDialogSettings());
        if (this.initialPatternText != null) {
            this.pattern.setText(this.initialPatternText);
        }
        switch (this.selectionMode) {
            case 1: {
                this.pattern.setSelection(0, 0);
                break;
            }
            case 2: {
                this.pattern.setSelection(0, this.initialPatternText.length());
            }
        }
        this.applyFilter();
        return dialogArea;
    }

    protected void dispose() {
        if (this.blankImage != null) {
            this.blankImage.dispose();
            this.blankImage = null;
        }
    }

    private void createDetailsArea(Composite parent) {
        this.details = new StyledText(parent, 2314);
        this.details.setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        this.list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                QuickSearchDialog.this.refreshDetails();
            }
        });
        this.details.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                QuickSearchDialog.this.refreshDetails();
            }
        });
    }

    private void refreshDetails() {
        if (this.details != null && this.list != null && !this.list.getTable().isDisposed()) {
            IStructuredSelection sel;
            if (this.documents == null) {
                this.documents = new DocumentFetcher();
            }
            if ((sel = (IStructuredSelection)this.list.getSelection()) == null || sel.isEmpty()) {
                this.details.setText(EMPTY_STRING);
            } else {
                int numLines = this.computeLines();
                if (numLines > 0) {
                    LineItem item = (LineItem)sel.getFirstElement();
                    IDocument document = this.documents.getDocument(item.getFile());
                    try {
                        int line = item.getLineNumber() - 1;
                        int start = document.getLineOffset(Math.max(line - (numLines - 1) / 2, 0));
                        int end = document.getLength();
                        try {
                            end = document.getLineOffset(start + numLines);
                        }
                        catch (BadLocationException badLocationException) {}
                        StyledString styledString = this.highlightMatches(document.get(start, end - start));
                        this.details.setText(styledString.getString());
                        this.details.setStyleRanges(styledString.getStyleRanges());
                        return;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            this.details.setText(EMPTY_STRING);
        }
    }

    private int computeLines() {
        if (this.details != null && !this.details.isDisposed()) {
            GC gc = new GC((Drawable)this.details);
            try {
                FontMetrics fm = gc.getFontMetrics();
                int itemH = fm.getHeight();
                int areaH = this.details.getClientArea().height;
                int n = (areaH + itemH - 1) / itemH;
                return n;
            }
            finally {
                gc.dispose();
            }
        }
        return 0;
    }

    private StyledString highlightMatches(String visibleText) {
        StyledString styledText = new StyledString(visibleText);
        List<QuickTextQuery.TextRange> matches = this.getQuery().findAll(visibleText);
        for (QuickTextQuery.TextRange m : matches) {
            styledText.setStyle(m.getOffset(), m.getLength(), HIGHLIGHT_STYLE);
        }
        return styledText;
    }

    protected void handleDoubleClick() {
        this.okPressed();
    }

    protected void handleSelected(StructuredSelection selection) {
        Status status = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
        this.updateStatus((IStatus)status);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_BOUNDS_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            section.put(DIALOG_HEIGHT, 500);
            section.put(DIALOG_WIDTH, 600);
        }
        return section;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public void refresh() {
        if (this.list != null && !this.list.getTable().isDisposed()) {
            ScrollBar sb = this.list.getTable().getVerticalBar();
            int oldScroll = sb.getSelection();
            int itemCount = this.contentProvider.getNumberOfElements();
            this.list.setItemCount(itemCount);
            this.list.refresh(true, false);
            int newScroll = sb.getSelection();
            if (oldScroll != newScroll) {
                System.out.println("Scroll moved in refresh: " + oldScroll + " => " + newScroll);
            }
        }
    }

    public void scheduleRefresh() {
        this.refreshJob.schedule();
    }

    protected void computeResult() {
        Object first;
        List<Object> objectsToReturn = ((StructuredSelection)this.list.getSelection()).toList();
        if (objectsToReturn.isEmpty() && (first = this.list.getElementAt(0)) != null) {
            objectsToReturn = Arrays.asList(first);
        }
        this.setResult(objectsToReturn);
    }

    protected void updateStatus(IStatus status) {
        this.status = status;
        super.updateStatus(status);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void setInitialPattern(String text) {
        this.setInitialPattern(text, 2);
    }

    public void setInitialPattern(String text, int selectionMode) {
        this.initialPatternText = text;
        this.selectionMode = selectionMode;
    }

    protected String getInitialPattern() {
        return this.initialPatternText;
    }

    protected StructuredSelection getSelectedItems() {
        StructuredSelection selection = (StructuredSelection)this.list.getSelection();
        List selectedItems = selection.toList();
        return new StructuredSelection(selectedItems);
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.springsource.ide.eclipse.quicksearch", "fine");
    }

    protected QuickTextQuery createFilter() {
        return new QuickTextQuery(this.pattern.getText(), this.toggleCaseSensitiveAction.isChecked());
    }

    protected void applyFilter() {
        QuickTextQuery newFilter = this.createFilter();
        if (this.searcher == null) {
            if (!newFilter.isTrivial()) {
                this.searcher = new QuickTextSearcher(newFilter, this.context.createPriorityFun(), this.MAX_LINE_LEN, new QuickTextSearchRequestor(){

                    @Override
                    public void add(LineItem match) {
                        QuickSearchDialog.this.contentProvider.add(match);
                        QuickSearchDialog.this.contentProvider.refresh();
                    }

                    @Override
                    public void clear() {
                        QuickSearchDialog.this.contentProvider.reset();
                        QuickSearchDialog.this.contentProvider.refresh();
                    }

                    @Override
                    public void revoke(LineItem match) {
                        QuickSearchDialog.this.contentProvider.remove(match);
                        QuickSearchDialog.this.contentProvider.refresh();
                    }

                    @Override
                    public void update(LineItem match) {
                        QuickSearchDialog.this.contentProvider.refresh();
                    }
                });
                this.refresh();
            }
        } else {
            this.searcher.setQuery(newFilter);
        }
        if (this.progressJob != null) {
            this.progressJob.schedule();
        }
    }

    public String getElementName(Object item) {
        return EMPTY_STRING + item;
    }

    public Control getPatternControl() {
        return this.pattern;
    }

    public QuickTextQuery getQuery() {
        return this.searcher.getQuery();
    }

    private class ContentProvider
    implements IStructuredContentProvider,
    ILazyContentProvider {
        private List items = Collections.synchronizedList(new ArrayList(2048));

        public void remove(LineItem match) {
            this.items.remove(match);
        }

        public void reset() {
            this.items.clear();
        }

        public void add(LineItem match) {
            this.items.add(match);
        }

        public void refresh() {
            QuickSearchDialog.this.scheduleRefresh();
        }

        public Object[] getElements(Object inputElement) {
            return this.items.toArray();
        }

        public int getNumberOfElements() {
            return this.items.size();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void updateElement(int index) {
            QuickSearchDialog.this.list.replace(this.items.size() > index ? this.items.get(index) : null, index);
        }
    }

    private class ToggleCaseSensitiveAction
    extends Action {
        public ToggleCaseSensitiveAction(IDialogSettings settings) {
            super("Case Sensitive", 2);
            if (settings.get(QuickSearchDialog.CASE_SENSITIVE) == null) {
                this.setChecked(true);
            } else {
                this.setChecked(settings.getBoolean(QuickSearchDialog.CASE_SENSITIVE));
            }
        }

        public void run() {
            QuickSearchDialog.this.refreshHeaderLabel();
            QuickSearchDialog.this.applyFilter();
        }
    }
}

