/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.shared;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceResolver.class);
    private final ClassRealm pluginRealm;
    private final IPath projectLocation;
    private final List<IPath> projectLocations;

    public ResourceResolver(ClassRealm pluginRealm, IPath projectLocation, List<IPath> projectLocations) {
        Preconditions.checkNotNull((Object)projectLocation);
        Preconditions.checkNotNull(projectLocations);
        this.pluginRealm = pluginRealm;
        this.projectLocation = projectLocation;
        this.projectLocations = projectLocations;
    }

    public URL resolveLocation(String location) {
        if (location == null || location.isEmpty()) {
            return null;
        }
        URL url = null;
        for (IPath path : this.projectLocations) {
            url = this.getResourceRelativeFromIPath(path, location);
            if (url == null) continue;
            return url;
        }
        url = this.getResourceFromPluginRealm(location);
        if (url == null) {
            url = this.getResourceFromRemote(location);
        }
        if (url == null) {
            url = this.getResourceFromFileSystem(location);
        }
        if (url == null) {
            url = this.getResourceRelativeFromProjectLocation(location);
        }
        return url;
    }

    public URL getResourceFromPluginRealm(String resource) {
        ArrayList urls;
        String fixedResource;
        block5: {
            if (this.pluginRealm == null) {
                return null;
            }
            fixedResource = resource.startsWith("/") ? resource.substring(1) : resource;
            try {
                urls = Collections.list(this.pluginRealm.getResources(fixedResource));
                if (!urls.isEmpty()) break block5;
                return null;
            }
            catch (IOException e) {
                LOG.warn("getResources() failed: " + fixedResource, (Throwable)e);
                return null;
            }
        }
        if (urls.size() > 1) {
            LOG.warn("Resource appears more than once on classpath, this is dangerous because it makes resolving this resource dependant on classpath ordering; location {} found in {}", (Object)fixedResource, urls);
        }
        return (URL)urls.get(0);
    }

    public URL getResourceFromRemote(String resource) {
        try {
            return new URL(resource);
        }
        catch (IOException e) {
            LOG.trace("Could not open resource {} from remote", (Object)resource, (Object)e);
            return null;
        }
    }

    public URL getResourceFromFileSystem(String resource) {
        try {
            Path path = Paths.get(resource, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                return path.toUri().toURL();
            }
        }
        catch (IOException | InvalidPathException e) {
            LOG.trace("Could not open resource {} from file system", (Object)resource, (Object)e);
        }
        return null;
    }

    public URL getResourceRelativeFromProjectLocation(String resource) {
        return this.getResourceRelativeFromIPath(this.projectLocation, resource);
    }

    public URL getResourceRelativeFromIPath(IPath path, String resource) {
        try {
            File file = path.append(resource).toFile();
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (IOException e) {
            LOG.trace("Could not open resource {} relative to project location", (Object)resource, (Object)e);
        }
        return null;
    }
}

