/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.shared;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPluginWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MavenPluginWrapper.class);
    private final String key;
    private final List<MojoExecution> executions;

    private MavenPluginWrapper(String key, List<MojoExecution> executions) {
        this.key = key;
        this.executions = executions;
    }

    public boolean isPluginConfigured() {
        return this.executions != null && !this.executions.isEmpty();
    }

    public List<MojoExecution> getMojoExecutions() {
        return this.executions;
    }

    public static boolean mojoExecutionForPlugin(MojoExecution mojoExecution, String groupId, String artifactId, String goal) {
        return groupId.equals(mojoExecution.getGroupId()) && artifactId.equals(mojoExecution.getArtifactId()) && (goal == null || goal.equals(mojoExecution.getGoal()));
    }

    public static List<MojoExecution> findMojoExecutions(IProgressMonitor monitor, IMavenProjectFacade mavenProjectFacade, String pluginGroupId, String pluginArtifactId, String[] pluginGoal) throws CoreException {
        List mojoExecutions = mavenProjectFacade.getMojoExecutions(pluginGroupId, pluginArtifactId, monitor, pluginGoal);
        return MavenPluginWrapper.searchExecutions(pluginGroupId, pluginArtifactId, pluginGoal, mojoExecutions);
    }

    private static List<MojoExecution> searchExecutions(String pluginGroupId, String pluginArtifactId, String[] pluginGoal, List<MojoExecution> mojoExecutions) {
        ArrayList<MojoExecution> foundMojoExections = new ArrayList<MojoExecution>();
        for (MojoExecution mojoExecution : mojoExecutions) {
            if (pluginGoal != null) {
                String[] stringArray = pluginGoal;
                int n = pluginGoal.length;
                int n2 = 0;
                while (n2 < n) {
                    String goal = stringArray[n2];
                    if (MavenPluginWrapper.mojoExecutionForPlugin(mojoExecution, pluginGroupId, pluginArtifactId, goal)) {
                        foundMojoExections.add(mojoExecution);
                    }
                    ++n2;
                }
                continue;
            }
            if (!MavenPluginWrapper.mojoExecutionForPlugin(mojoExecution, pluginGroupId, pluginArtifactId, null)) continue;
            foundMojoExections.add(mojoExecution);
        }
        if (foundMojoExections.size() != mojoExecutions.size()) {
            LOG.debug("They are different. Additional search is necessary.");
        }
        return foundMojoExections;
    }

    public static MavenPluginWrapper newInstance(IProgressMonitor monitor, String pluginGroupId, String pluginArtifactId, String[] pluginGoal, IMavenProjectFacade mavenProjectFacade) throws CoreException {
        Preconditions.checkNotNull((Object)mavenProjectFacade);
        List<MojoExecution> executions = MavenPluginWrapper.findMojoExecutions(monitor, mavenProjectFacade, pluginGroupId, pluginArtifactId, pluginGoal);
        String key = String.valueOf(pluginGroupId) + ":" + pluginArtifactId;
        return new MavenPluginWrapper(key, executions);
    }

    public String toString() {
        String s = "[MavenPluginWrapper " + this.key;
        if (this.executions == null) {
            s = String.valueOf(s) + " null wrapper]";
        } else if (this.executions.isEmpty()) {
            s = String.valueOf(s) + " empty wrapper]";
        }
        return s;
    }
}

