/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.shared;

import com.basistech.m2e.code.quality.shared.MavenPluginWrapper;
import com.basistech.m2e.code.quality.shared.ResourceResolver;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenPluginProjectConfigurator
extends AbstractProjectConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMavenPluginProjectConfigurator.class);

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        AbstractMavenPluginProjectConfigurator.removeNature(project, natureId, 2, monitor);
    }

    public static void removeNature(IProject project, String natureId, int updateFlags, IProgressMonitor monitor) throws CoreException {
        if (project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            ArrayList<String> natures = new ArrayList<String>(Arrays.asList(prevNatures));
            natures.remove(natureId);
            String[] newNatures = natures.toArray(new String[0]);
            description.setNatureIds(newNatures);
            project.setDescription(description, updateFlags, monitor);
        }
    }

    public <T> T getParameterValue(MavenProject project, String parameter, Class<T> asType, MojoExecution mojoExecution, IProgressMonitor monitor) throws CoreException {
        return (T)super.getParameterValue(project, parameter, asType, mojoExecution, monitor);
    }

    protected MojoExecution findForkedExecution(MojoExecution primary, String groupId, String artifactId, String goal) {
        Map forkedExecutions = primary.getForkedExecutions();
        MojoExecution goalExecution = null;
        for (List possibleExecutionList : forkedExecutions.values()) {
            for (MojoExecution possibleExecution : possibleExecutionList) {
                if (!groupId.equals(possibleExecution.getGroupId()) || !artifactId.equals(possibleExecution.getArtifactId()) || !goal.equals(possibleExecution.getGoal())) continue;
                goalExecution = possibleExecution;
                break;
            }
            if (goalExecution != null) break;
        }
        return goalExecution;
    }

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        LOG.debug("configure {}", (Object)request.getProject());
        MavenProject mavenProject = request.getMavenProject();
        if (mavenProject == null) {
            return;
        }
        MavenPluginWrapper pluginWrapper = this.getMavenPlugin(monitor, request.getMavenProjectFacade());
        IProject project = request.getProject();
        if (!pluginWrapper.isPluginConfigured()) {
            return;
        }
        MavenSession mavenSession = request.getMavenSession();
        this.handleProjectConfigurationChange(request.getMavenProjectFacade(), project, monitor, pluginWrapper, mavenSession);
    }

    public void mavenProjectChanged(MavenProjectChangedEvent mavenProjectChangedEvent, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade mavenProjectFacade = mavenProjectChangedEvent.getMavenProject();
        MavenPluginWrapper pluginWrapper = this.getMavenPlugin(monitor, mavenProjectFacade);
        IProject project = mavenProjectFacade.getProject();
        if (LOG.isDebugEnabled()) {
            switch (mavenProjectChangedEvent.getKind()) {
                case 1: {
                    LOG.debug("mavenProjectChanged {}: KIND_ADDED", (Object)project);
                    break;
                }
                case 3: {
                    LOG.debug("mavenProjectChanged {}: KIND_CHANGED", (Object)project);
                    break;
                }
                case 2: {
                    LOG.debug("mavenProjectChanged {}: KIND_REMOVED", (Object)project);
                    break;
                }
                default: {
                    LOG.debug("mavenProjectChanged {}: {}", (Object)project, (Object)mavenProjectChangedEvent.getKind());
                }
            }
        }
        if (this.checkUnconfigurationRequired(monitor, mavenProjectFacade, mavenProjectChangedEvent.getOldMavenProject())) {
            this.unconfigureEclipsePlugin(project, monitor);
            return;
        }
        if (pluginWrapper.isPluginConfigured()) {
            MavenExecutionRequest request = this.maven.createExecutionRequest(monitor);
            MavenSession session = this.maven.createSession(request, mavenProjectChangedEvent.getMavenProject().getMavenProject(monitor));
            this.handleProjectConfigurationChange(mavenProjectFacade, project, monitor, pluginWrapper, session);
        }
    }

    protected abstract void handleProjectConfigurationChange(IMavenProjectFacade var1, IProject var2, IProgressMonitor var3, MavenPluginWrapper var4, MavenSession var5) throws CoreException;

    protected abstract String getMavenPluginGroupId();

    protected abstract String getMavenPluginArtifactId();

    protected abstract String[] getMavenPluginGoals();

    protected abstract void unconfigureEclipsePlugin(IProject var1, IProgressMonitor var2) throws CoreException;

    private boolean checkUnconfigurationRequired(IProgressMonitor monitor, IMavenProjectFacade curMavenProjectFacade, IMavenProjectFacade oldMavenProjectFacade) throws CoreException {
        Preconditions.checkNotNull((Object)curMavenProjectFacade);
        if (oldMavenProjectFacade == null) {
            return false;
        }
        MavenPluginWrapper newMavenPlugin = this.getMavenPlugin(monitor, curMavenProjectFacade);
        MavenPluginWrapper oldMavenPlugin = this.getMavenPlugin(monitor, oldMavenProjectFacade);
        return !newMavenPlugin.isPluginConfigured() && oldMavenPlugin.isPluginConfigured();
    }

    public static ResourceResolver getResourceResolver(MojoExecution mojoExecution, MavenSession session, IPath projectLocation) throws CoreException {
        IMaven mvn = MavenPlugin.getMaven();
        ArrayList<IPath> pluginDepencyProjectLocations = new ArrayList<IPath>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IMavenProjectRegistry mavenProjectRegistry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade[] projects = mavenProjectRegistry.getProjects();
        List dependencies = mojoExecution.getPlugin().getDependencies();
        for (Dependency dependency : dependencies) {
            IMavenProjectFacade[] iMavenProjectFacadeArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IMavenProjectFacade projectFacade = iMavenProjectFacadeArray[n2];
                IProject project = projectFacade.getProject();
                if (!project.isAccessible()) {
                    LOG.debug("Project registry contains closed project {}", (Object)project);
                } else {
                    IResource outputLocation;
                    ArtifactKey artifactKey = projectFacade.getArtifactKey();
                    if (artifactKey.getGroupId().equals(dependency.getGroupId()) && artifactKey.getArtifactId().equals(dependency.getArtifactId()) && artifactKey.getVersion().equals(dependency.getVersion()) && (outputLocation = root.findMember(projectFacade.getOutputLocation())) != null) {
                        pluginDepencyProjectLocations.add(outputLocation.getLocation());
                    }
                }
                ++n2;
            }
        }
        try {
            Mojo configuredMojo = (Mojo)mvn.getConfiguredMojo(session, mojoExecution, Mojo.class);
            mvn.releaseMojo((Object)configuredMojo, mojoExecution);
        }
        catch (CoreException e) {
            if (pluginDepencyProjectLocations.isEmpty()) {
                throw e;
            }
            LOG.trace("Could not get mojo", (Throwable)e);
        }
        return new ResourceResolver(mojoExecution.getMojoDescriptor().getPluginDescriptor().getClassRealm(), projectLocation, pluginDepencyProjectLocations);
    }

    private MavenPluginWrapper getMavenPlugin(IProgressMonitor monitor, IMavenProjectFacade projectFacade) throws CoreException {
        return MavenPluginWrapper.newInstance(monitor, this.getMavenPluginGroupId(), this.getMavenPluginArtifactId(), this.getMavenPluginGoals(), projectFacade);
    }
}

