/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.shared;

import java.util.Collections;
import java.util.List;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.IMaven;

public class AbstractMavenPluginConfigurationTranslator {
    private final IMaven maven;
    private final MavenProject project;
    private final MojoExecution mojoExecution;
    private final IProgressMonitor monitor;
    private final ConfigurationContainer execution;

    public AbstractMavenPluginConfigurationTranslator(IMaven maven, MavenProject project, MojoExecution mojoExecution, IProgressMonitor monitor) {
        this.maven = maven;
        this.project = project;
        this.mojoExecution = mojoExecution;
        this.monitor = monitor;
        this.execution = new PluginExecution();
        this.execution.setConfiguration((Object)mojoExecution.getConfiguration());
    }

    public <T> T getParameterValue(String parameter, Class<T> asType) throws CoreException {
        return (T)this.maven.getMojoParameterValue(this.project, parameter, asType, this.mojoExecution.getPlugin(), this.execution, this.mojoExecution.getGoal(), this.monitor);
    }

    public <T> T getParameterValue(String parameter, Class<T> asType, T defaultValue) throws CoreException {
        T parameterValue = this.getParameterValue(parameter, asType);
        if (parameterValue == null) {
            return defaultValue;
        }
        return parameterValue;
    }

    public <T> List<T> getParameterList(String parameter, Class<T> asType) throws CoreException {
        List list;
        ConfigurationContainer executionClone = this.execution.clone();
        Xpp3Dom configuration = (Xpp3Dom)executionClone.getConfiguration();
        Xpp3Dom xpp3Dom = configuration = configuration != null ? configuration.getChild(parameter) : null;
        if (configuration != null && configuration.getChildCount() > 0) {
            configuration.setAttribute("default-value", "");
        }
        if ((list = (List)this.maven.getMojoParameterValue(this.project, parameter, List.class, this.mojoExecution.getPlugin(), executionClone, this.mojoExecution.getGoal(), this.monitor)) == null) {
            return Collections.emptyList();
        }
        return list;
    }
}

