/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.pmd;

import com.basistech.m2e.code.quality.shared.AbstractMavenPluginProjectConfigurator;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MavenPluginConfigurationTranslator {
    private static final Map<String, String> PATTERNS_CACHE = new HashMap<String, String>();
    private final MavenProject mavenProject;
    private final URI basedirUri;
    private final List<String> excludeSourceRoots = new ArrayList<String>();
    private final List<String> includeSourceRoots = new ArrayList<String>();
    private final List<String> includePatterns = new ArrayList<String>();
    private final List<String> excludePatterns = new ArrayList<String>();
    private final IProject project;
    private final AbstractMavenPluginProjectConfigurator configurator;
    private final MojoExecution pmdGoalExecution;
    private final IProgressMonitor monitor;

    private MavenPluginConfigurationTranslator(AbstractMavenPluginProjectConfigurator configurator, MavenProject mavenProject, MojoExecution pmdGoalExecution, IProject project, IProgressMonitor monitor) throws CoreException {
        this.mavenProject = mavenProject;
        this.project = project;
        this.monitor = monitor;
        this.basedirUri = this.project.getLocationURI();
        this.pmdGoalExecution = pmdGoalExecution;
        this.configurator = configurator;
    }

    public List<String> getRulesets() throws CoreException {
        String[] rulesets = (String[])this.configurator.getParameterValue(this.mavenProject, "rulesets", String[].class, this.pmdGoalExecution, this.monitor);
        if (rulesets == null) {
            return Arrays.asList("/rulesets/java/basic.xml", "/rulesets/java/unusedcode.xml", "/rulesets/java/imports.xml");
        }
        return Arrays.asList(rulesets);
    }

    private List<String> getExcludePatterns() throws CoreException {
        String[] excludes = (String[])this.configurator.getParameterValue(this.mavenProject, "excludes", String[].class, this.pmdGoalExecution, this.monitor);
        LinkedList<String> transformedPatterns = new LinkedList<String>();
        if (excludes != null && excludes.length > 0) {
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!StringUtils.isBlank((String)(p = StringUtils.strip((String)p)))) {
                    transformedPatterns.add(this.getTransformedPattern(p));
                }
                ++n2;
            }
        }
        return transformedPatterns;
    }

    private List<String> getIncludePatterns() throws CoreException {
        String[] includes = (String[])this.configurator.getParameterValue(this.mavenProject, "includes", String[].class, this.pmdGoalExecution, this.monitor);
        LinkedList<String> transformedPatterns = new LinkedList<String>();
        if (includes != null && includes.length > 0) {
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!StringUtils.isBlank((String)(p = StringUtils.strip((String)p)))) {
                    transformedPatterns.add(this.getTransformedPattern(p));
                }
                ++n2;
            }
        }
        return transformedPatterns;
    }

    public boolean getIncludeTests() throws CoreException {
        Boolean tests = (Boolean)this.configurator.getParameterValue(this.mavenProject, "includeTests", Boolean.class, this.pmdGoalExecution, this.monitor);
        return tests != null && tests != false;
    }

    public List<String> getExcludeRoots() {
        return ImmutableList.copyOf(this.excludeSourceRoots);
    }

    public List<String> getIncludeRoots() {
        return ImmutableList.copyOf(this.includeSourceRoots);
    }

    public List<String> getIncludes() {
        return ImmutableList.copyOf(this.includePatterns);
    }

    public List<String> getExcludes() {
        return ImmutableList.copyOf(this.excludePatterns);
    }

    private String getTransformedPattern(String antStylePattern) {
        String newPattern;
        if (PATTERNS_CACHE.containsKey(antStylePattern)) {
            newPattern = PATTERNS_CACHE.get(antStylePattern);
        } else {
            newPattern = this.convertAntStylePatternToPmdPattern(antStylePattern);
            PATTERNS_CACHE.put(antStylePattern, newPattern);
        }
        return newPattern;
    }

    private String convertAntStylePatternToPmdPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern cannot be null");
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("pattern cannot empty");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            char curChar;
            int nextCharIndex = i + 1;
            char nextChar = '\u0000';
            if (nextCharIndex != pattern.length()) {
                nextChar = pattern.charAt(nextCharIndex);
            }
            if ((curChar = pattern.charAt(i)) == '*' && nextChar == '*') {
                sb.append(".*");
                ++i;
            } else {
                sb.append(curChar);
            }
            ++i;
        }
        return sb.toString();
    }

    private void buildExcludeAndIncludeSourceRoots() throws CoreException {
        ArrayList<File> includeRoots = new ArrayList<File>();
        ArrayList<File> excludeRoots = new ArrayList<File>();
        includeRoots.addAll(this.transformResourceStringsToFiles(this.mavenProject.getCompileSourceRoots()));
        ArrayList<String> targetDirectories = new ArrayList<String>();
        targetDirectories.add(this.mavenProject.getBuild().getDirectory());
        excludeRoots.addAll(this.transformResourceStringsToFiles(targetDirectories));
        List<File> testCompileSourceRoots = this.transformResourceStringsToFiles(this.mavenProject.getTestCompileSourceRoots());
        if (this.getIncludeTests()) {
            includeRoots.addAll(testCompileSourceRoots);
        } else {
            excludeRoots.addAll(testCompileSourceRoots);
        }
        File[] excludeRootsArray = (File[])this.configurator.getParameterValue(this.mavenProject, "excludeRoots", File[].class, this.pmdGoalExecution, this.monitor);
        List<Object> excludeRootsFromConfig = excludeRootsArray == null ? Collections.emptyList() : Arrays.asList(excludeRootsArray);
        LinkedList<File> filteredIncludeRoots = new LinkedList<File>();
        for (File f : includeRoots) {
            int idx = excludeRootsFromConfig.indexOf(f);
            if (idx == -1 && (f.isDirectory() || !f.exists())) {
                filteredIncludeRoots.add(f);
                continue;
            }
            excludeRoots.add(f);
        }
        this.includeSourceRoots.addAll(this.convertFileFoldersToRelativePathStrings(filteredIncludeRoots));
        this.excludeSourceRoots.addAll(this.convertFileFoldersToRelativePathStrings(excludeRoots));
    }

    private List<String> convertFileFoldersToRelativePathStrings(Iterable<? extends File> sources) {
        ArrayList<String> folders = new ArrayList<String>();
        for (File file : sources) {
            String relativePath = !file.isAbsolute() ? this.basedirUri.resolve(file.toURI()).getPath() : file.getAbsolutePath();
            if ("\\".equals(File.separator)) {
                relativePath = relativePath.replace("\\", "/");
            }
            if (relativePath.endsWith("/")) {
                relativePath = relativePath.substring(0, relativePath.length() - 1);
            }
            relativePath = String.valueOf(relativePath) + ".*";
            folders.add(relativePath);
        }
        return folders;
    }

    private List<File> transformResourceStringsToFiles(List<String> srcDirNames) {
        File basedir = this.mavenProject.getBasedir();
        ArrayList<File> sourceDirectories = new ArrayList<File>();
        if (srcDirNames != null) {
            for (String srcDirName : srcDirNames) {
                File srcDir = new File(srcDirName);
                if (!srcDir.isAbsolute()) {
                    srcDir = new File(basedir, srcDir.getPath());
                }
                sourceDirectories.add(srcDir);
            }
        }
        return sourceDirectories;
    }

    private void initialize() throws CoreException {
        this.buildExcludeAndIncludeSourceRoots();
        this.includePatterns.clear();
        this.includePatterns.addAll(this.getIncludePatterns());
        this.excludePatterns.clear();
        this.excludePatterns.addAll(this.getExcludePatterns());
    }

    public static MavenPluginConfigurationTranslator newInstance(AbstractMavenPluginProjectConfigurator configurator, MavenProject mavenProject, MojoExecution pmdGoalExecution, IProject project, IProgressMonitor monitor) throws CoreException {
        MavenPluginConfigurationTranslator m2csConverter = new MavenPluginConfigurationTranslator(configurator, mavenProject, pmdGoalExecution, project, monitor);
        m2csConverter.initialize();
        return m2csConverter;
    }
}

