/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.pmd;

import com.basistech.m2e.code.quality.pmd.MavenPluginConfigurationTranslator;
import com.basistech.m2e.code.quality.pmd.PmdEclipseConstants;
import com.basistech.m2e.code.quality.shared.AbstractMavenPluginProjectConfigurator;
import com.basistech.m2e.code.quality.shared.MavenPluginWrapper;
import com.basistech.m2e.code.quality.shared.ResourceResolver;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.PMDNature;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectPropertiesManager;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipsePmdProjectConfigurator
extends AbstractMavenPluginProjectConfigurator {
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private static final Logger LOG = LoggerFactory.getLogger(EclipsePmdProjectConfigurator.class);
    private final RuleSetFactory factory = new RuleSetFactory();

    protected String getMavenPluginGroupId() {
        return "org.apache.maven.plugins";
    }

    protected String getMavenPluginArtifactId() {
        return "maven-pmd-plugin";
    }

    protected String[] getMavenPluginGoals() {
        return new String[]{"check"};
    }

    protected void handleProjectConfigurationChange(IMavenProjectFacade mavenProjectFacade, IProject project, IProgressMonitor monitor, MavenPluginWrapper mavenPluginWrapper, MavenSession session) throws CoreException {
        MojoExecution execution = this.findMojoExecution(mavenPluginWrapper);
        MojoExecution pmdGoalExecution = this.findForkedExecution(execution, "org.apache.maven.plugins", "maven-pmd-plugin", "pmd");
        MavenPluginConfigurationTranslator pluginCfgTranslator = MavenPluginConfigurationTranslator.newInstance(this, mavenProjectFacade.getMavenProject(monitor), pmdGoalExecution, project, monitor);
        this.createOrUpdateEclipsePmdConfiguration(mavenPluginWrapper, project, pluginCfgTranslator, monitor, session);
        this.addPMDNature(project, monitor);
    }

    private void addPMDNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project.hasNature(JAVA_NATURE)) {
            try {
                PMDNature.addPMDNature((IProject)project, (IProgressMonitor)monitor);
            }
            catch (CoreException pmdNatureProblem) {
                LOG.error("PMD plugin threw exception adding PMD nature", (Throwable)pmdNatureProblem);
                throw pmdNatureProblem;
            }
        }
    }

    protected void unconfigureEclipsePlugin(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectPropertiesManager mgr = PMDPlugin.getDefault().getPropertiesManager();
        try {
            IProjectProperties projectProperties = mgr.loadProjectProperties(project);
            projectProperties.setPmdEnabled(false);
            projectProperties.setRuleSetStoredInProject(false);
            mgr.storeProjectProperties(projectProperties);
        }
        catch (PropertiesException propertiesException) {}
        PMDNature.removePMDNature((IProject)project, (IProgressMonitor)monitor);
        IFile pmdRulesetResource = project.getFile(".pmdruleset.xml");
        pmdRulesetResource.delete(1, monitor);
        IFile pmdPropertiesResource = project.getFile(".pmd");
        pmdPropertiesResource.delete(1, monitor);
    }

    private void createOrUpdateEclipsePmdConfiguration(MavenPluginWrapper pluginWrapper, IProject project, MavenPluginConfigurationTranslator pluginCfgTranslator, IProgressMonitor monitor, MavenSession session) throws CoreException {
        MojoExecution execution = this.findMojoExecution(pluginWrapper);
        ResourceResolver resourceResolver = AbstractMavenPluginProjectConfigurator.getResourceResolver((MojoExecution)execution, (MavenSession)session, (IPath)project.getLocation());
        try {
            List<Rule> allRules = this.locatePmdRules(pluginCfgTranslator, resourceResolver);
            ArrayList<String> excludePatterns = new ArrayList<String>();
            ArrayList<String> includePatterns = new ArrayList<String>();
            this.buildAndAddPmdExcludeAndIncludePatterns(pluginCfgTranslator, excludePatterns, includePatterns);
            RuleSet ruleset = this.factory.createNewRuleSet("M2Eclipse PMD RuleSet", "M2Eclipse PMD RuleSet", ".pmdruleset.xml", excludePatterns, includePatterns, allRules);
            File rulesetFile = this.writeRuleSet(project.getFile(".pmdruleset.xml"), ruleset, monitor);
            try {
                IProjectPropertiesManager mgr = PMDPlugin.getDefault().getPropertiesManager();
                IProjectProperties projectProperties = mgr.loadProjectProperties(project);
                projectProperties.setPmdEnabled(true);
                projectProperties.setRuleSetFile(rulesetFile.getAbsolutePath());
                projectProperties.setRuleSetStoredInProject(true);
                mgr.storeProjectProperties(projectProperties);
            }
            catch (PropertiesException propertiesException) {
                this.unconfigureEclipsePlugin(project, monitor);
            }
        }
        catch (PMDException pMDException) {}
    }

    private List<Rule> locatePmdRules(MavenPluginConfigurationTranslator pluginCfgTranslator, ResourceResolver resourceResolver) throws CoreException, PMDException {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        List<String> rulesetStringLocations = pluginCfgTranslator.getRulesets();
        for (final String loc : rulesetStringLocations) {
            RuleSetReferenceId ruleSetReferenceId = new RuleSetReferenceId(loc);
            final URL resolvedLocation = resourceResolver.resolveLocation(ruleSetReferenceId.getRuleSetFileName());
            if (resolvedLocation == null) {
                throw new PMDException(String.format("Failed to resolve RuleSet from location [%s],SKIPPING Eclipse PMD configuration", loc));
            }
            try {
                RuleSetReferenceId resolvedRuleSetReference = new RuleSetReferenceId(loc){

                    public InputStream getInputStream(ResourceLoader resourceLoader) throws RuleSetNotFoundException {
                        try {
                            return resolvedLocation.openStream();
                        }
                        catch (IOException iOException) {
                            LOG.warn("No ruleset found for {}", (Object)loc);
                            return null;
                        }
                    }
                };
                RuleSet ruleSetAtLocations = this.factory.createRuleSet(resolvedRuleSetReference);
                allRules.addAll(ruleSetAtLocations.getRules());
            }
            catch (RuleSetNotFoundException e) {
                LOG.error("Couldn't find ruleset {}", (Object)loc, (Object)e);
            }
        }
        return allRules;
    }

    private File writeRuleSet(IFile rulesetFile, RuleSet ruleSet, IProgressMonitor monitor) throws CoreException {
        PMDPlugin pmdPlugin = PMDPlugin.getDefault();
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(rulesetFile.getLocation().toFile()));){
                pmdPlugin.getRuleSetWriter().write((OutputStream)byteArrayStream, ruleSet);
                String fixedXml = byteArrayStream.toString("UTF-8").replaceAll("\\<exclude\\>(.*)\\</exclude\\>", "<exclude name=\"$1\"/>");
                outputStream.write(fixedXml.getBytes(Charset.forName("UTF-8")));
                rulesetFile.refreshLocal(0, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | WriterException throwable) {}
        return rulesetFile.getLocation().toFile();
    }

    private void buildAndAddPmdExcludeAndIncludePatterns(MavenPluginConfigurationTranslator pluginCfgTranslator, Collection<String> excludePatterns, Collection<String> includePatterns) {
        List<String> excludeRoots = pluginCfgTranslator.getExcludeRoots();
        List<String> includeRoots = pluginCfgTranslator.getIncludeRoots();
        List<String> pluginIncludes = pluginCfgTranslator.getIncludes();
        boolean includesSpecified = !includePatterns.isEmpty();
        HashSet<String> excludeRootsSet = new HashSet<String>();
        excludeRootsSet.addAll(excludeRoots);
        if (includesSpecified) {
            excludeRootsSet.addAll(includeRoots);
        } else {
            List<String> pluginExcludes = pluginCfgTranslator.getExcludes();
            for (String ir : includeRoots) {
                for (String ep : pluginExcludes) {
                    String fullPattern = ".*" + ir + ep;
                    excludePatterns.add(StringUtils.replace((String)fullPattern, (String)".*.*", (String)".*"));
                }
            }
        }
        for (String er : excludeRootsSet) {
            excludePatterns.add(".*" + er);
        }
        for (String ir : includeRoots) {
            for (String ip : pluginIncludes) {
                String fullPattern = ".*" + ir + ip;
                includePatterns.add(StringUtils.replace((String)fullPattern, (String)".*.*", (String)".*"));
            }
        }
    }

    private MojoExecution findMojoExecution(MavenPluginWrapper mavenPluginWrapper) throws CoreException {
        List mojoExecutions = mavenPluginWrapper.getMojoExecutions();
        if (mojoExecutions.size() != 1) {
            throw new CoreException((IStatus)new Status(4, PmdEclipseConstants.PLUGIN_ID, "Wrong number of executions. Expected 1. Found " + mojoExecutions.size()));
        }
        MojoExecution execution = (MojoExecution)mojoExecutions.get(0);
        return execution;
    }
}

