/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.findbugs;

import com.basistech.m2e.code.quality.shared.AbstractMavenPluginProjectConfigurator;
import com.basistech.m2e.code.quality.shared.ConfigurationException;
import com.basistech.m2e.code.quality.shared.MavenPluginWrapper;
import com.basistech.m2e.code.quality.shared.ResourceResolver;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.URLInputStreamFacade;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPluginConfigurationTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(MavenPluginConfigurationTranslator.class);
    private final IProject project;
    private final AbstractMavenPluginProjectConfigurator configurator;
    private final ResourceResolver resourceResolver;
    private final MojoExecution execution;
    private final IProgressMonitor monitor;
    private final MavenProject mavenProject;

    private MavenPluginConfigurationTranslator(AbstractMavenPluginProjectConfigurator configurator, MojoExecution execution, IProject project, MavenProject mavenProject, IProgressMonitor monitor, ResourceResolver resourceResolver) throws CoreException {
        this.project = project;
        this.mavenProject = mavenProject;
        this.monitor = monitor;
        this.resourceResolver = resourceResolver;
        this.execution = execution;
        this.configurator = configurator;
    }

    public void setIncludeFilterFiles(UserPreferences prefs) throws CoreException {
        String includeFilterFile = (String)this.configurator.getParameterValue(this.mavenProject, "includeFilterFile", String.class, this.execution, this.monitor);
        if (includeFilterFile == null) {
            LOG.debug("includeFilterFile is null");
            return;
        }
        this.copyUrlResourceToProject(includeFilterFile, ".fbIncludeFilterFile");
        Map curIncludeFilteredFiles = prefs.getIncludeFilterFiles();
        HashMap<String, Boolean> newIncludeFilteredFiles = new HashMap<String, Boolean>();
        if (!curIncludeFilteredFiles.containsKey(".fbIncludeFilterFile")) {
            newIncludeFilteredFiles.put(".fbIncludeFilterFile", Boolean.TRUE);
        }
        newIncludeFilteredFiles.putAll(curIncludeFilteredFiles);
        prefs.setIncludeFilterFiles(newIncludeFilteredFiles);
    }

    public void setExcludeFilterFiles(UserPreferences prefs) throws CoreException {
        LOG.debug("entering setExcludeFilterFiles");
        String excludeFilterFile = (String)this.configurator.getParameterValue(this.mavenProject, "excludeFilterFile", String.class, this.execution, this.monitor);
        if (excludeFilterFile == null) {
            LOG.debug("excludeFilterFile is null");
            return;
        }
        this.copyUrlResourceToProject(excludeFilterFile, ".fbExcludeFilterFile");
        Map curExcludeFilteredFiles = prefs.getExcludeFilterFiles();
        HashMap<String, Boolean> newExcludeFilteredFiles = new HashMap<String, Boolean>();
        if (!curExcludeFilteredFiles.containsKey(".fbExcludeFilterFile")) {
            newExcludeFilteredFiles.put(".fbExcludeFilterFile", Boolean.TRUE);
        }
        newExcludeFilteredFiles.putAll(curExcludeFilteredFiles);
        prefs.setExcludeFilterFiles(newExcludeFilteredFiles);
    }

    public void setBugCatagories(UserPreferences prefs) throws CoreException {
        ProjectFilterSettings pfs = prefs.getFilterSettings();
        String bugCatagories = (String)this.configurator.getParameterValue(this.mavenProject, "bugCategories", String.class, this.execution, this.monitor);
        if (bugCatagories == null) {
            LOG.debug("bugCatagories is null");
            return;
        }
        List<String> addBugCatagoriesList = Arrays.asList(StringUtils.split((String)bugCatagories, (String)","));
        LinkedList availableBugCategories = new LinkedList(DetectorFactoryCollection.instance().getBugCategories());
        if (!addBugCatagoriesList.isEmpty()) {
            for (String removeBugCategory : availableBugCategories) {
                pfs.removeCategory(removeBugCategory);
            }
        }
        HashSet<String> removeBugCategoriesSet = new HashSet<String>();
        for (String bc : addBugCatagoriesList) {
            String bcUpper = bc.toUpperCase();
            if (availableBugCategories.contains(bcUpper)) {
                pfs.addCategory(bcUpper);
            } else {
                LOG.debug(String.format("[%s]: Unknown Bug Catagory [%s]", "M2E-FB", bc));
            }
            if (!pfs.getActiveCategorySet().contains(bcUpper)) continue;
            removeBugCategoriesSet.add(bcUpper);
        }
    }

    public boolean debugEnabled() throws CoreException {
        return (Boolean)this.configurator.getParameterValue(this.mavenProject, "debug", Boolean.class, this.execution, this.monitor);
    }

    public void setEffort(UserPreferences prefs) throws CoreException {
        String effort = (String)this.configurator.getParameterValue(this.mavenProject, "effort", String.class, this.execution, this.monitor);
        if (effort == null) {
            LOG.debug("effort is null");
            return;
        }
        effort = effort.toLowerCase();
        try {
            prefs.setEffort(effort);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("{}: could not set <effort>, reason {}, setting it to default {}", new Object[]{"M2E-FB", effort, "default", ex});
        }
    }

    public void setMinRank(UserPreferences prefs) throws CoreException {
        Integer minRank = (Integer)this.configurator.getParameterValue(this.mavenProject, "maxRank", Integer.class, this.execution, this.monitor);
        if (minRank == null) {
            LOG.debug("max rank is null");
            return;
        }
        try {
            prefs.getFilterSettings().setMinRank(minRank.intValue());
        }
        catch (IllegalArgumentException ex) {
            LOG.error("{}: could not set <rank>, reason {}, setting it to default {}", new Object[]{"M2E-FB", minRank, 15, ex});
        }
    }

    public void setPriority(UserPreferences prefs) throws CoreException {
        String priority = (String)this.configurator.getParameterValue(this.mavenProject, "priority", String.class, this.execution, this.monitor);
        if (priority == null) {
            LOG.debug("priority is null");
            return;
        }
        try {
            prefs.getFilterSettings().setMinPriority(priority);
        }
        catch (Exception ex) {
            LOG.error("{}: could not set <threshold>, reason {}, leaving it alone", new Object[]{"M2E-FB", priority, ex});
        }
    }

    public void setOmitVisitors(UserPreferences prefs) throws CoreException {
        String omitVisitors = (String)this.configurator.getParameterValue(this.mavenProject, "omitVisitors", String.class, this.execution, this.monitor);
        if (omitVisitors == null) {
            LOG.debug("omitVisitors is null");
            return;
        }
        List<String> detectorsList = Arrays.asList(StringUtils.split((String)omitVisitors, (String)","));
        DetectorFactoryCollection dfc = DetectorFactoryCollection.instance();
        for (String d : detectorsList) {
            DetectorFactory df = dfc.getFactory(d);
            if (df == null) {
                LOG.error(String.format("[%s]: IGNORING unknown detector [%s]", "M2E-FB", d));
                continue;
            }
            prefs.enableDetector(df, false);
        }
    }

    public void setThreshold(UserPreferences prefs) throws CoreException {
        String threshold = (String)this.configurator.getParameterValue(this.mavenProject, "threshold", String.class, this.execution, this.monitor);
        if (threshold == null) {
            LOG.debug("threshold is null");
            return;
        }
        try {
            prefs.getFilterSettings().setMinPriority(threshold);
        }
        catch (Exception ex) {
            LOG.error("{}: could not set <threshold>, reason {}, leaving it alone", new Object[]{"M2E-FB", threshold, ex});
        }
    }

    public void setVisitors(UserPreferences prefs) throws CoreException {
        String visitors = (String)this.configurator.getParameterValue(this.mavenProject, "visitors", String.class, this.execution, this.monitor);
        if (visitors == null) {
            return;
        }
        List<String> detectorsList = Arrays.asList(StringUtils.split((String)visitors, (String)","));
        prefs.enableAllDetectors(false);
        DetectorFactoryCollection dfc = DetectorFactoryCollection.instance();
        for (String d : detectorsList) {
            DetectorFactory df = dfc.getFactory(d);
            if (df == null) {
                LOG.error(String.format("[%s]: IGNORING unknown detector [%s]", "M2E-FB", d));
                continue;
            }
            prefs.enableDetector(df, true);
        }
    }

    private void copyUrlResourceToProject(String resc, String newLocation) {
        LOG.debug("entering copyUrlResourceToProject");
        Preconditions.checkNotNull((Object)resc);
        Preconditions.checkNotNull((Object)newLocation);
        URL urlResc = this.resourceResolver.resolveLocation(resc);
        if (urlResc == null) {
            throw new ConfigurationException(String.format("[%s]: could not locate resource [%s]", "M2E-FB", resc));
        }
        File newLocationFile = new File(this.project.getLocationURI().getPath(), newLocation);
        try {
            FileUtils.copyStreamToFile((InputStreamFacade)new URLInputStreamFacade(urlResc), (File)newLocationFile);
        }
        catch (IOException ex) {
            throw new ConfigurationException(String.format("[%s]: could not copy resource [%s] to [%s], reason [%s]", "M2E-FB", resc, newLocationFile, ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    public static MavenPluginConfigurationTranslator newInstance(AbstractMavenPluginProjectConfigurator configurator, MavenPluginWrapper mavenPlugin, IProject project, MavenProject mavenProject, IProgressMonitor monitor, MavenSession session) throws CoreException {
        List mojoExecutions = mavenPlugin.getMojoExecutions();
        if (mojoExecutions.size() != 1) {
            throw new CoreException((IStatus)new Status(4, FrameworkUtil.getBundle(MavenPluginConfigurationTranslator.class).getSymbolicName(), "Wrong number of executions. Expected 1. Found " + mojoExecutions.size()));
        }
        MojoExecution execution = (MojoExecution)mojoExecutions.get(0);
        ResourceResolver resourceResolver = AbstractMavenPluginProjectConfigurator.getResourceResolver((MojoExecution)execution, (MavenSession)session, (IPath)project.getLocation());
        return new MavenPluginConfigurationTranslator(configurator, execution, project, mavenProject, monitor, resourceResolver);
    }
}

