/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.findbugs;

import com.basistech.m2e.code.quality.findbugs.EclipseFindbugsConfigManager;
import com.basistech.m2e.code.quality.findbugs.MavenPluginConfigurationTranslator;
import com.basistech.m2e.code.quality.shared.AbstractMavenPluginProjectConfigurator;
import com.basistech.m2e.code.quality.shared.MavenPluginWrapper;
import de.tobject.findbugs.FindbugsPlugin;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseFindbugsProjectConfigurator
extends AbstractMavenPluginProjectConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseFindbugsProjectConfigurator.class);

    protected String getMavenPluginArtifactId() {
        return "findbugs-maven-plugin";
    }

    protected String getMavenPluginGroupId() {
        return "org.codehaus.mojo";
    }

    protected String[] getMavenPluginGoals() {
        return new String[]{"findbugs", "check"};
    }

    protected void handleProjectConfigurationChange(IMavenProjectFacade mavenProjectFacade, IProject project, IProgressMonitor monitor, MavenPluginWrapper mavenPluginWrapper, MavenSession session) throws CoreException {
        LOG.debug("entering handleProjectConfigurationChange");
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists() || !javaProject.getProject().isOpen()) {
            return;
        }
        MavenPluginConfigurationTranslator mavenFindbugsConfig = MavenPluginConfigurationTranslator.newInstance(this, mavenPluginWrapper, project, mavenProjectFacade.getMavenProject(monitor), monitor, session);
        try {
            List mojoExecutions = mavenPluginWrapper.getMojoExecutions();
            if (mojoExecutions.size() != 1) {
                LOG.error("Wrong number of executions. Expected 1. Found " + mojoExecutions.size());
                return;
            }
            UserPreferences prefs = this.buildFindbugsPreferences(mavenFindbugsConfig);
            EclipseFindbugsConfigManager fbPluginNature = EclipseFindbugsConfigManager.newInstance(project);
            fbPluginNature.configure(monitor);
            FindbugsPlugin.saveUserPreferences((IProject)project, (UserPreferences)prefs);
            FindbugsPlugin.setProjectSettingsEnabled((IProject)project, null, (boolean)true);
        }
        catch (CoreException ex) {
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    protected void unconfigureEclipsePlugin(IProject project, IProgressMonitor monitor) throws CoreException {
        LOG.debug("entering unconfigureEclipsePlugin");
        EclipseFindbugsConfigManager fbPluginNature = EclipseFindbugsConfigManager.newInstance(project);
        fbPluginNature.deconfigure(monitor);
    }

    private UserPreferences buildFindbugsPreferences(MavenPluginConfigurationTranslator pluginCfgTranslator) throws CoreException {
        LOG.debug("entering buildFindbugsPreferences");
        UserPreferences prefs = UserPreferences.createDefaultUserPreferences();
        pluginCfgTranslator.setIncludeFilterFiles(prefs);
        pluginCfgTranslator.setExcludeFilterFiles(prefs);
        pluginCfgTranslator.setEffort(prefs);
        pluginCfgTranslator.setMinRank(prefs);
        pluginCfgTranslator.setVisitors(prefs);
        pluginCfgTranslator.setOmitVisitors(prefs);
        pluginCfgTranslator.setPriority(prefs);
        pluginCfgTranslator.setThreshold(prefs);
        prefs.setRunAtFullBuild(false);
        FindbugsPlugin.DEBUG = pluginCfgTranslator.debugEnabled();
        return prefs;
    }
}

