/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.findbugs;

import com.google.common.base.Preconditions;
import de.tobject.findbugs.nature.FindBugsNature;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseFindbugsConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseFindbugsConfigManager.class);
    private final FindBugsNature fbNature;

    private EclipseFindbugsConfigManager(FindBugsNature fbNature) {
        this.fbNature = fbNature;
    }

    public void configure(IProgressMonitor monitor) throws CoreException {
        LOG.debug("entering configure");
        this.fbNature.configure();
        this.configureNature(monitor);
    }

    public void deconfigure(IProgressMonitor monitor) throws CoreException {
        LOG.debug("entering deconfigure");
        this.fbNature.deconfigure();
        this.deconfigureNature(monitor);
        this.deleteEclipseFiles(monitor);
    }

    private void configureNature(IProgressMonitor monitor) throws CoreException {
        LOG.debug("entering configureNature");
        IProject project = this.fbNature.getProject();
        IProjectDescription desc = project.getDescription();
        String[] natures = desc.getNatureIds();
        String[] newNatures = Arrays.copyOf(natures, natures.length + 1);
        newNatures[natures.length] = "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature";
        desc.setNatureIds(newNatures);
        project.setDescription(desc, monitor);
    }

    private void deconfigureNature(IProgressMonitor monitor) throws CoreException {
        LOG.debug("entering deconfigureNature");
        IProject project = this.fbNature.getProject();
        IProjectDescription desc = project.getDescription();
        String[] natures = desc.getNatureIds();
        ArrayList<String> newNaturesList = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            if (!"edu.umd.cs.findbugs.plugin.eclipse.findbugsNature".equals(natures[i])) {
                newNaturesList.add(natures[i]);
            }
            ++i;
        }
        String[] newNatures = newNaturesList.toArray(new String[newNaturesList.size()]);
        desc.setNatureIds(newNatures);
        project.setDescription(desc, monitor);
    }

    private void deleteEclipseFiles(IProgressMonitor monitor) throws CoreException {
        LOG.debug("entering deleteEclipseFiles");
        IProject project = this.fbNature.getProject();
        IFile findbugsFile = project.getFile(".fbprefs");
        findbugsFile.delete(1, monitor);
    }

    public static EclipseFindbugsConfigManager newInstance(IProject project) {
        LOG.debug("entering newInstance");
        Preconditions.checkNotNull((Object)project);
        FindBugsNature fbNature = new FindBugsNature();
        fbNature.setProject(project);
        return new EclipseFindbugsConfigManager(fbNature);
    }
}

