/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.checkstyle;

import com.basistech.m2e.code.quality.checkstyle.CheckstyleUtil;
import com.basistech.m2e.code.quality.shared.AbstractMavenPluginConfigurationTranslator;
import com.basistech.m2e.code.quality.shared.AbstractMavenPluginProjectConfigurator;
import com.basistech.m2e.code.quality.shared.MavenPluginWrapper;
import com.basistech.m2e.code.quality.shared.ResourceResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationWorkingCopy;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.IMaven;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPluginConfigurationTranslator
extends AbstractMavenPluginConfigurationTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(MavenPluginConfigurationTranslator.class);
    private static final String CHECKSTYLE_DEFAULT_CONFIG_LOCATION = "config/sun_checks.xml";
    private static final Map<String, String> PATTERNS_CACHE = new HashMap<String, String>();
    private final MavenProject mavenProject;
    private final URI basedirUri;
    private final ResourceResolver resourceResolver;
    private final MojoExecution execution;
    private final Path workingDirectory;

    private MavenPluginConfigurationTranslator(IMaven maven, MavenProject mavenProject, MojoExecution mojoExecution, URI basedirUri, IProgressMonitor monitor, ResourceResolver resourceResolver, Path workingDirectory) throws CoreException {
        super(maven, mavenProject, mojoExecution, monitor);
        this.mavenProject = mavenProject;
        this.workingDirectory = workingDirectory;
        this.basedirUri = basedirUri;
        this.resourceResolver = resourceResolver;
        this.execution = mojoExecution;
    }

    public boolean isSkip() throws CoreException {
        return (Boolean)this.getParameterValue("skip", Boolean.class, Boolean.FALSE);
    }

    public URL getRuleset() throws CheckstylePluginException, CoreException {
        URL ruleset = this.resourceResolver.resolveLocation(this.getConfigLocation());
        if (ruleset == null) {
            throw new CheckstylePluginException("Failed to resolve RuleSet from configLocation,SKIPPING Eclipse checkstyle configuration");
        }
        return ruleset;
    }

    public String getHeaderFile() throws CheckstylePluginException, CoreException {
        URL headerLocation = this.getHeaderLocation();
        if (headerLocation == null) {
            return null;
        }
        Path headerFile = this.workingDirectory.resolve("checkstyle-header-" + this.getExecutionId() + ".txt");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = headerLocation.openStream();){
                Files.copy(inputStream, headerFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("Could not copy header file {}", (Object)headerLocation, (Object)e);
            throw new CheckstylePluginException("Failed to copy header file, SKIPPING Eclipse checkstyle configuration");
        }
        return headerFile.toAbsolutePath().toString();
    }

    public String getSuppressionsFile() throws CheckstylePluginException, CoreException {
        URL suppressionsLocation = this.getSuppressionsLocation();
        if (suppressionsLocation == null) {
            return null;
        }
        Path suppressionsFile = this.workingDirectory.resolve("checkstyle-suppressions-" + this.getExecutionId() + ".xml");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = suppressionsLocation.openStream();){
                Files.copy(inputStream, suppressionsFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.error("Could not copy suppressions file {}", (Object)suppressionsLocation, (Object)e);
            throw new CheckstylePluginException("Failed to copy suppressions file, SKIPPING Eclipse checkstyle configuration");
        }
        return suppressionsFile.toAbsolutePath().toString();
    }

    public String getSuppressionsFileExpression() throws CoreException {
        return (String)this.getParameterValue("suppressionsFileExpression", String.class, "checkstyle.suppressions.file");
    }

    public void updateCheckConfigWithIncludeExcludePatterns(ProjectConfigurationWorkingCopy pcWorkingCopy, ICheckConfiguration checkCfg) throws CheckstylePluginException, CoreException {
        FileSet fs = new FileSet("java-sources-" + this.getExecutionId(), checkCfg);
        fs.setEnabled(true);
        fs.setFileMatchPatterns(this.getIncludesExcludesFileMatchPatterns());
        pcWorkingCopy.getFileSets().add(fs);
    }

    private String getPropertiesLocation() throws CoreException {
        return (String)this.getParameterValue("propertiesLocation", String.class);
    }

    private String getPropertyExpansion() throws CoreException {
        return (String)this.getParameterValue("propertyExpansion", String.class);
    }

    private boolean isIncludeTestSourceDirectory() throws CoreException {
        return (Boolean)this.getParameterValue("includeTestSourceDirectory", Boolean.class, Boolean.FALSE);
    }

    private boolean isIncludeResources() throws CoreException {
        return (Boolean)this.getParameterValue("includeResources", Boolean.class, Boolean.TRUE);
    }

    private boolean isIncludeTestResources() throws CoreException {
        return (Boolean)this.getParameterValue("includeTestResources", Boolean.class, Boolean.TRUE);
    }

    public String getExecutionId() {
        return this.execution.getExecutionId();
    }

    private String getConfigLocation() throws CoreException {
        return (String)this.getParameterValue("configLocation", String.class, CHECKSTYLE_DEFAULT_CONFIG_LOCATION);
    }

    private URL getHeaderLocation() throws CoreException {
        String headerLocation = (String)this.getParameterValue("headerLocation", String.class, "LICENSE.txt");
        if ("config/maven_checks.xml".equals(this.getConfigLocation()) && "LICENSE.txt".equals(headerLocation)) {
            headerLocation = "config/maven-header.txt";
        }
        return this.resourceResolver.resolveLocation(headerLocation);
    }

    private URL getSuppressionsLocation() throws CoreException {
        String suppressionsLocation = (String)this.getParameterValue("suppressionsLocation", String.class);
        if (suppressionsLocation == null) {
            suppressionsLocation = (String)this.getParameterValue("suppressionsFile", String.class);
        }
        return this.resourceResolver.resolveLocation(suppressionsLocation);
    }

    private List<String> getSourceDirectories() throws CoreException {
        ArrayList<String> sourceDirectories = new ArrayList<String>(this.getParameterList("sourceDirectories", String.class));
        String sourceDirectory = (String)this.getParameterValue("sourceDirectory", String.class);
        if (sourceDirectory != null) {
            sourceDirectories.add(sourceDirectory);
        }
        return sourceDirectories;
    }

    private List<String> getTestSourceDirectories() throws CoreException {
        ArrayList<String> testSourceDirectories = new ArrayList<String>(this.getParameterList("testSourceDirectories", String.class));
        String testSourceDirectory = (String)this.getParameterValue("testSourceDirectory", String.class);
        if (testSourceDirectory != null) {
            testSourceDirectories.add(testSourceDirectory);
        }
        return testSourceDirectories;
    }

    private List<String> getIncludes() throws CoreException {
        return this.getPatterns("includes");
    }

    private List<String> getExcludes() throws CoreException {
        return this.getPatterns("excludes");
    }

    private List<String> getResourceIncludes() throws CoreException {
        return this.getPatterns("resourceIncludes");
    }

    private List<String> getResourceExcludes() throws CoreException {
        return this.getPatterns("resourceExcludes");
    }

    private List<FileMatchPattern> getIncludesExcludesFileMatchPatterns() throws CheckstylePluginException, CoreException {
        String folderRelativePath;
        List<String> resourceExcludePatterns;
        Object folderRelativePath2;
        List<String> resourceIncludePatterns;
        LinkedList<FileMatchPattern> patterns = new LinkedList<FileMatchPattern>();
        HashSet<String> sourceFolders = new HashSet<String>(this.getSourceDirectories());
        if (this.isIncludeTestSourceDirectory()) {
            sourceFolders.addAll(this.getTestSourceDirectories());
        }
        List<String> includePatterns = this.getIncludes();
        for (String folder : sourceFolders) {
            String folderRelativePath3 = this.relativize(folder);
            if (!includePatterns.isEmpty()) {
                patterns.addAll(this.normalizePatternsToCheckstyleFileMatchPattern(includePatterns, folderRelativePath3, true));
                continue;
            }
            patterns.add(new FileMatchPattern(folderRelativePath3));
        }
        List<String> excludePatterns = this.getExcludes();
        for (String folder : sourceFolders) {
            String folderRelativePath4 = this.relativize(folder);
            patterns.addAll(this.normalizePatternsToCheckstyleFileMatchPattern(excludePatterns, this.convertToEclipseCheckstyleRegExpPath(folderRelativePath4), false));
        }
        if (this.isIncludeResources()) {
            resourceIncludePatterns = this.getResourceIncludes();
            for (Resource resource : this.mavenProject.getBuild().getResources()) {
                folderRelativePath2 = this.relativize(resource.getDirectory());
                patterns.addAll(this.normalizePatternsToCheckstyleFileMatchPattern(resourceIncludePatterns, (String)folderRelativePath2, true));
            }
            resourceExcludePatterns = this.getResourceExcludes();
            for (Resource resource : this.mavenProject.getBuild().getResources()) {
                folderRelativePath = this.relativize(resource.getDirectory());
                patterns.addAll(this.normalizePatternsToCheckstyleFileMatchPattern(resourceExcludePatterns, folderRelativePath, false));
            }
        }
        if (this.isIncludeTestResources()) {
            resourceIncludePatterns = this.getResourceIncludes();
            for (Resource resource : this.mavenProject.getBuild().getTestResources()) {
                if (!resource.getExcludes().isEmpty() || !resource.getIncludes().isEmpty()) continue;
                folderRelativePath2 = "^" + this.basedirUri.relativize(new File(resource.getDirectory()).toURI()).getPath();
                patterns.addAll(this.normalizePatternsToCheckstyleFileMatchPattern(resourceIncludePatterns, (String)folderRelativePath2, true));
            }
            resourceExcludePatterns = this.getResourceExcludes();
            for (Resource resource : this.mavenProject.getBuild().getTestResources()) {
                if (!resource.getExcludes().isEmpty() || !resource.getIncludes().isEmpty()) continue;
                folderRelativePath = "^" + this.basedirUri.relativize(new File(resource.getDirectory()).toURI()).getPath();
                patterns.addAll(this.normalizePatternsToCheckstyleFileMatchPattern(resourceExcludePatterns, folderRelativePath, false));
            }
        }
        return patterns;
    }

    private String relativize(String folder) {
        String folderRelativePath = "^";
        File file = new File(folder);
        folderRelativePath = file.isAbsolute() ? String.valueOf(folderRelativePath) + this.basedirUri.relativize(file.toURI()).getPath() : String.valueOf(folderRelativePath) + folder;
        return folderRelativePath;
    }

    private String convertToEclipseCheckstyleRegExpPath(String path) {
        String csCompatiblePath = path;
        if (path.endsWith("/")) {
            csCompatiblePath = path.substring(0, path.length() - 1);
        }
        csCompatiblePath = String.valueOf(csCompatiblePath) + ".*";
        return csCompatiblePath;
    }

    private List<FileMatchPattern> normalizePatternsToCheckstyleFileMatchPattern(List<String> patterns, String relativePath, boolean setIsIncludePatternFlag) throws CheckstylePluginException {
        LinkedList<FileMatchPattern> fileMatchPatterns = new LinkedList<FileMatchPattern>();
        for (String p : patterns) {
            FileMatchPattern fmp = new FileMatchPattern(String.format("%s%s", relativePath, p));
            fmp.setIsIncludePattern(setIsIncludePatternFlag);
            fileMatchPatterns.add(fmp);
        }
        return fileMatchPatterns;
    }

    private List<String> getPatterns(String elemName) throws CoreException {
        String[] patternsArray;
        LinkedList<String> transformedPatterns = new LinkedList<String>();
        String patternsString = (String)this.getParameterValue(elemName, String.class);
        if (patternsString == null || patternsString.isEmpty()) {
            return transformedPatterns;
        }
        String[] stringArray = patternsArray = StringUtils.split((String)patternsString, (String)",");
        int n = patternsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if ((p = StringUtils.strip((String)p)) != null && !p.isEmpty()) {
                String csPattern;
                if (PATTERNS_CACHE.containsKey(p)) {
                    csPattern = PATTERNS_CACHE.get(p);
                } else {
                    csPattern = CheckstyleUtil.convertAntStylePatternToCheckstylePattern(p);
                    PATTERNS_CACHE.put(p, csPattern);
                }
                transformedPatterns.add(csPattern);
            }
            ++n2;
        }
        return transformedPatterns;
    }

    public Properties getConfiguredProperties() throws CoreException, CheckstylePluginException {
        String propertiesLocation = this.getPropertiesLocation();
        Properties properties = new Properties();
        if (propertiesLocation != null) {
            URL url = this.resourceResolver.resolveLocation(propertiesLocation);
            if (url == null) {
                throw new CheckstylePluginException(String.format("Failed to resolve propertiesLocation [%s]", propertiesLocation));
            }
            try {
                properties.load(url.openStream());
            }
            catch (IOException iOException) {
                throw new CheckstylePluginException(String.format("Failed to LOAD properties from propertiesLocation [%s]", propertiesLocation));
            }
        }
        return properties;
    }

    public void updatePropertiesWithPropertyExpansion(Properties props) throws CheckstylePluginException, CoreException {
        String propertyExpansion = this.getPropertyExpansion();
        if (propertyExpansion != null) {
            try {
                String escapedPropertyExpansion = StringEscapeUtils.escapeJava((String)propertyExpansion);
                props.load(new StringReader(escapedPropertyExpansion));
            }
            catch (IOException iOException) {
                throw new CheckstylePluginException(String.format("[%s]: Failed to checkstyle propertyExpansion [%s]", "M2E-CS", propertyExpansion));
            }
        }
    }

    public static List<MavenPluginConfigurationTranslator> newInstance(IMaven maven, AbstractMavenPluginProjectConfigurator configurator, MavenProject mavenProject, MavenPluginWrapper mavenPlugin, IProject project, IProgressMonitor monitor, MavenSession session) throws CoreException {
        ArrayList<MavenPluginConfigurationTranslator> m2csConverters = new ArrayList<MavenPluginConfigurationTranslator>();
        for (MojoExecution execution : mavenPlugin.getMojoExecutions()) {
            ResourceResolver resourceResolver = AbstractMavenPluginProjectConfigurator.getResourceResolver((MojoExecution)execution, (MavenSession)session, (IPath)project.getLocation());
            Path path = project.getWorkingLocation(configurator.getId()).toFile().toPath();
            m2csConverters.add(new MavenPluginConfigurationTranslator(maven, mavenProject, execution, project.getLocationURI(), monitor, resourceResolver, path));
        }
        return m2csConverters;
    }
}

