/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.checkstyle;

import com.basistech.m2e.code.quality.checkstyle.Activator;
import com.basistech.m2e.code.quality.checkstyle.MavenPluginConfigurationTranslator;
import com.basistech.m2e.code.quality.shared.AbstractMavenPluginProjectConfigurator;
import com.basistech.m2e.code.quality.shared.MavenPluginWrapper;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationTypes;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationWorkingCopy;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.maven.execution.MavenSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseCheckstyleProjectConfigurator
extends AbstractMavenPluginProjectConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseCheckstyleProjectConfigurator.class);
    private static final IConfigurationType REMOTE_CONFIGURATION_TYPE = ConfigurationTypes.getByInternalName((String)"remote");

    protected String getMavenPluginArtifactId() {
        return "maven-checkstyle-plugin";
    }

    protected String getMavenPluginGroupId() {
        return "org.apache.maven.plugins";
    }

    protected String[] getMavenPluginGoals() {
        return new String[]{"checkstyle", "check"};
    }

    protected void handleProjectConfigurationChange(IMavenProjectFacade mavenProjectFacade, IProject project, IProgressMonitor monitor, MavenPluginWrapper mavenPluginWrapper, MavenSession session) throws CoreException {
        List<MavenPluginConfigurationTranslator> mavenCheckstyleConfigs = MavenPluginConfigurationTranslator.newInstance(this.maven, this, mavenProjectFacade.getMavenProject(monitor), mavenPluginWrapper, project, monitor, session);
        try {
            ProjectConfigurationWorkingCopy pcWorkingCopy = new ProjectConfigurationWorkingCopy(ProjectConfigurationFactory.getConfiguration((IProject)project));
            pcWorkingCopy.setUseSimpleConfig(false);
            pcWorkingCopy.setSyncFormatter(Activator.getDefault().getPreferenceStore().getBoolean("eclipseCheckstyleGenerateFormatterSettings"));
            pcWorkingCopy.getFileSets().clear();
            for (MavenPluginConfigurationTranslator mavenCheckstyleConfig : mavenCheckstyleConfigs) {
                if (!mavenCheckstyleConfig.isSkip()) {
                    this.buildCheckstyleConfiguration(pcWorkingCopy, mavenCheckstyleConfig);
                    EclipseCheckstyleProjectConfigurator.addNature((IProject)project, (String)"net.sf.eclipsecs.core.CheckstyleNature", (IProgressMonitor)monitor);
                    continue;
                }
                this.deleteEclipseFiles(project, monitor);
                EclipseCheckstyleProjectConfigurator.removeNature((IProject)project, (String)"net.sf.eclipsecs.core.CheckstyleNature", (IProgressMonitor)monitor);
            }
            if (pcWorkingCopy.isDirty()) {
                pcWorkingCopy.store();
            }
        }
        catch (CheckstylePluginException ex) {
            LOG.error("CheckstylePluginException", (Throwable)ex);
        }
    }

    private void deleteEclipseFiles(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile checkstyleFile = project.getFile(".checkstyle");
        checkstyleFile.delete(1, monitor);
        IFile checkstyleCacheFileResource = project.getFile("${project_loc}/target/checkstyle-cachefile");
        checkstyleCacheFileResource.delete(1, monitor);
    }

    protected void unconfigureEclipsePlugin(IProject project, IProgressMonitor monitor) throws CoreException {
        this.deleteEclipseFiles(project, monitor);
        EclipseCheckstyleProjectConfigurator.removeNature((IProject)project, (String)"net.sf.eclipsecs.core.CheckstyleNature", (IProgressMonitor)monitor);
    }

    private void buildCheckstyleConfiguration(ProjectConfigurationWorkingCopy pcWorkingCopy, MavenPluginConfigurationTranslator cfgTranslator) throws CheckstylePluginException, CoreException {
        String suppressionsFile;
        URL ruleset = cfgTranslator.getRuleset();
        ICheckConfiguration checkCfg = this.createOrGetCheckstyleConfig(pcWorkingCopy, ruleset, cfgTranslator.getExecutionId());
        cfgTranslator.updateCheckConfigWithIncludeExcludePatterns(pcWorkingCopy, checkCfg);
        Properties props = cfgTranslator.getConfiguredProperties();
        cfgTranslator.updatePropertiesWithPropertyExpansion(props);
        String headerFile = cfgTranslator.getHeaderFile();
        if (headerFile != null) {
            props.setProperty("checkstyle.header.file", headerFile);
        }
        if ((suppressionsFile = cfgTranslator.getSuppressionsFile()) != null) {
            props.setProperty(cfgTranslator.getSuppressionsFileExpression(), suppressionsFile);
        }
        props.setProperty("checkstyle.cache.file", "${project_loc}/target/checkstyle-cachefile");
        List csProps = checkCfg.getResolvableProperties();
        csProps.clear();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            csProps.add(new ResolvableProperty((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    private ICheckConfiguration createOrGetCheckstyleConfig(ProjectConfigurationWorkingCopy pcWorkingCopy, URL ruleset, String executionId) throws CheckstylePluginException {
        String configName = "maven-checkstyle-plugin " + executionId;
        ICheckConfigurationWorkingSet workingSet = pcWorkingCopy.getLocalCheckConfigWorkingSet();
        CheckConfigurationWorkingCopy workingCopy = null;
        CheckConfigurationWorkingCopy[] workingCopies = workingSet.getWorkingCopies();
        if (workingCopies == null) {
            LOG.error("The working copies are null");
            workingCopies = new CheckConfigurationWorkingCopy[]{};
        }
        CheckConfigurationWorkingCopy[] checkConfigurationWorkingCopyArray = workingCopies;
        int n = workingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            CheckConfigurationWorkingCopy copy = checkConfigurationWorkingCopyArray[n2];
            if (configName.equals(copy.getName())) {
                if (REMOTE_CONFIGURATION_TYPE.equals(copy.getType())) {
                    workingCopy = copy;
                    break;
                }
                throw new CheckstylePluginException(String.format("A local Checkstyle configuration already exists with name  [%s] with incompatible type [%s]", configName, copy.getType()));
            }
            ++n2;
        }
        if (workingCopy == null) {
            workingCopy = workingSet.newWorkingCopy(REMOTE_CONFIGURATION_TYPE);
            workingCopy.setName(configName);
            workingSet.addCheckConfiguration(workingCopy);
        }
        workingCopy.setDescription("maven-checkstyle-plugin configuration " + executionId);
        workingCopy.setLocation(ruleset.toExternalForm());
        return workingCopy;
    }
}

