/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.m2e.code.quality.checkstyle;

import com.google.common.base.Preconditions;
import java.io.File;

public final class CheckstyleUtil {
    private CheckstyleUtil() {
    }

    public static String convertAntStylePatternToCheckstylePattern(String pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern cannot be null");
        Preconditions.checkArgument((!pattern.isEmpty() ? 1 : 0) != 0, (Object)"pattern cannot be empty");
        String sanitizedPattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar);
        String dupeSeperatorChar = String.valueOf(File.separator) + File.separator;
        while (sanitizedPattern.contains(dupeSeperatorChar)) {
            sanitizedPattern = sanitizedPattern.replace(dupeSeperatorChar, File.separator);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < sanitizedPattern.length()) {
            char curChar = sanitizedPattern.charAt(i);
            char nextChar = '\u0000';
            char nextNextChar = '\u0000';
            if (i + 1 < sanitizedPattern.length()) {
                nextChar = sanitizedPattern.charAt(i + 1);
            }
            if (i + 2 < sanitizedPattern.length()) {
                nextNextChar = sanitizedPattern.charAt(i + 2);
            }
            if (curChar == '*' && nextChar == '*' && nextNextChar == File.separatorChar) {
                sb.append(".*");
                ++i;
                ++i;
            } else if (curChar == '*') {
                sb.append(".*");
            } else if (curChar == '.') {
                sb.append("\\.");
            } else {
                sb.append(curChar);
            }
            ++i;
        }
        String result = sb.toString();
        if (result.endsWith(File.separator)) {
            result = String.valueOf(result) + ".*";
        }
        while (result.contains(".*.*")) {
            result = result.replace(".*.*", ".*");
        }
        return result;
    }
}

