/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;

public class UIUtil {
    public static void openBrowser(String url) {
        try {
            URL urlToOpen = new URL(url);
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            if (browser != null) {
                browser.openURL(urlToOpen);
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    public static JavaDecompilerClassFileEditor getActiveEditor() {
        final JavaDecompilerClassFileEditor[] editors = new JavaDecompilerClassFileEditor[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart editor = UIUtil.getActiveEditor(true);
                if (editor instanceof JavaDecompilerClassFileEditor) {
                    editors[0] = (JavaDecompilerClassFileEditor)editor;
                } else {
                    IEditorPart editorPart;
                    IWorkbenchPage pg;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (pg = window.getActivePage()) != null && (editorPart = pg.getActiveEditor()) instanceof JavaDecompilerClassFileEditor) {
                        editors[0] = (JavaDecompilerClassFileEditor)editorPart;
                    }
                }
            }
        });
        return editors[0];
    }

    public static JavaDecompilerClassFileEditor getActiveDecompilerEditor() {
        final JavaDecompilerClassFileEditor[] editors = new JavaDecompilerClassFileEditor[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart editor = UIUtil.getActiveEditor(true);
                if (editor instanceof JavaDecompilerClassFileEditor) {
                    editors[0] = (JavaDecompilerClassFileEditor)editor;
                }
            }
        });
        return editors[0];
    }

    public static List getActiveSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        List classes = UIUtil.getSelectedElements(window.getSelectionService(), IClassFile.class);
        if (classes != null && !classes.isEmpty()) {
            return classes;
        }
        return null;
    }

    public static String getActivePerspectiveId() {
        final String[] ids = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb == null) {
                    ids[0] = null;
                    return;
                }
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (win == null) {
                    ids[0] = null;
                    return;
                }
                IWorkbenchPage page = win.getActivePage();
                if (page == null) {
                    ids[0] = null;
                    return;
                }
                IPerspectiveDescriptor perspective = page.getPerspective();
                if (perspective == null) {
                    ids[0] = null;
                    return;
                }
                ids[0] = perspective.getId();
            }
        });
        return ids[0];
    }

    public static boolean isDebug() {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        boolean debug = showLineNumber && align || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode();
        return debug;
    }

    public static boolean isDebugPerspective() {
        return "org.eclipse.debug.ui.DebugPerspective".equals(UIUtil.getActivePerspectiveId());
    }

    public static List getSelectedElements(ISelectionService selService, Class eleClass) {
        Iterator selections = UIUtil.getSelections(selService);
        ArrayList elements = new ArrayList();
        while (selections != null && selections.hasNext()) {
            Object select = selections.next();
            if (!eleClass.isInstance(select)) continue;
            elements.add(select);
        }
        return elements;
    }

    public static Iterator getSelections(ISelectionService selService) {
        ISelection selection = selService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.iterator();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IWorkbenchPart getActiveEditor(boolean activePageOnly) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) return null;
        if (activePageOnly) {
            IWorkbenchPage pg = window.getActivePage();
            if (pg == null) return null;
            IWorkbenchPart activePart = pg.getActivePart();
            if (!(activePart instanceof ContentOutline)) return activePart;
            ContentOutline outline = (ContentOutline)activePart;
            IWorkbenchPart part = (IWorkbenchPart)ReflectionUtils.invokeMethod(outline, "getCurrentContributingPart");
            if (part != null) return null;
            return (IWorkbenchPart)ReflectionUtils.getFieldValue(outline, "hiddenPart");
        }
        IWorkbenchPage[] pgs = window.getPages();
        int i = 0;
        while (i < pgs.length) {
            IWorkbenchPart part;
            IWorkbenchPage pg = pgs[i];
            if (pg != null && (part = pg.getActivePart()) != null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static boolean isOpenClassEditor() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null) {
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] pgs = window.getPages();
                int j = 0;
                while (j < pgs.length) {
                    IEditorPart[] parts;
                    IWorkbenchPage pg = pgs[j];
                    if (pg != null && (parts = pg.getEditors()) != null) {
                        int k = 0;
                        while (k < parts.length) {
                            if (parts[i] instanceof JavaDecompilerClassFileEditor) {
                                return true;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public static List getExportSelections() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        List selectedJars = UIUtil.getSelectedElements(window.getSelectionService(), IPackageFragmentRoot.class);
        if (selectedJars.size() == 1) {
            return selectedJars;
        }
        if (selectedJars.size() > 1) {
            return null;
        }
        List selectedPackages = UIUtil.getSelectedElements(window.getSelectionService(), IPackageFragment.class);
        List selectedClasses = UIUtil.getSelectedElements(window.getSelectionService(), IClassFile.class);
        selectedClasses.addAll(selectedPackages);
        if (!selectedClasses.isEmpty()) {
            return selectedClasses;
        }
        return null;
    }

    public static boolean isPackageFlat() {
        boolean isFlat = false;
        try {
            IWorkbenchPart view = UIUtil.getActiveEditor(true);
            if (view != null) {
                if (view.getSite().getId().equals("org.eclipse.ui.navigator.ProjectExplorer")) {
                    CommonNavigator explorer = (CommonNavigator)view;
                    Field field = CommonNavigator.class.getDeclaredField("commonManager");
                    if (field != null) {
                        field.setAccessible(true);
                        CommonNavigatorManager manager = (CommonNavigatorManager)field.get(explorer);
                        field = CommonNavigatorManager.class.getDeclaredField("contentService");
                        if (field != null) {
                            field.setAccessible(true);
                            INavigatorContentService service = (INavigatorContentService)field.get(manager);
                            IExtensionStateModel model = service.findStateModel("org.eclipse.jdt.java.ui.javaContent");
                            isFlat = model.getBooleanProperty("isLayoutFlat");
                        }
                    }
                } else if (view.getSite().getId().equals("org.eclipse.jdt.ui.PackageExplorer")) {
                    PackageExplorerPart explorer = (PackageExplorerPart)view;
                    isFlat = explorer.isFlatLayout();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isFlat;
    }

    public static boolean isWin32() {
        return "win32".equalsIgnoreCase(Platform.getOS());
    }

    public static boolean isMacOS() {
        return "macosx".equalsIgnoreCase(Platform.getOS());
    }

    public static String getPathLocation(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IResource resource = root.findMember(path);
        if (resource != null) {
            return resource.getLocation().toOSString();
        }
        return null;
    }

    public static boolean requestFromJavadocHover() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 12) {
            if (stacks[i].getClassName().indexOf("BinaryType") != -1 && stacks[i].getMethodName().equals("getJavadocRange")) {
                return false;
            }
            if (stacks[i].getClassName().indexOf("JavadocHover") != -1 && stacks[i].getMethodName().equals("getHoverInfo")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestFromDisassemblerSelection() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 10) {
            if (stacks[i].getMethodName().equals("doHandleCursorPositionChanged")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestCreateBuffer() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 12) {
            if (stacks[i].getClassName().indexOf("BinaryType") != -1 && stacks[i].getMethodName().equals("getJavadocRange")) {
                return false;
            }
            if (stacks[i].getClassName().indexOf("JavadocHover") != -1 && stacks[i].getMethodName().equals("getHoverInfo2")) {
                return true;
            }
            if (stacks[i].getClassName().indexOf("JavaSourceHover") != -1 && stacks[i].getMethodName().equals("getHoverInfo")) {
                return true;
            }
            if (stacks[i].getClassName().indexOf("FindOccurrencesInFileAction") != -1 && stacks[i].getMethodName().equals("getMember")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestFromShowMatch() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length) {
            if (stacks[i].getClassName().indexOf("JavaSearchResultPage") != -1 && stacks[i].getMethodName().equals("showMatch")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static StyleRange getAdTextStyleRange(StyledText textWidget, int offset, int length) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IPreferenceStore preferences = (IPreferenceStore)ReflectionUtils.getFieldValue(textTools, "fPreferenceStore");
        String textColor = preferences.getString("java_doc_link");
        StyleRange styleRange = null;
        if (UIUtil.isDark((Control)textWidget)) {
            String darkStyleValue = JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("darkStyle");
            if (darkStyleValue != null && darkStyleValue.trim().length() > 0) {
                styleRange = UIUtil.handleStyleValue(textWidget, offset, length, darkStyleValue, "text", textColor, false);
            }
        } else {
            String brightStyleValue = JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("brightStyle");
            if (brightStyleValue != null && brightStyleValue.trim().length() > 0) {
                styleRange = UIUtil.handleStyleValue(textWidget, offset, length, brightStyleValue, "text", textColor, false);
            }
        }
        if (styleRange == null) {
            styleRange = UIUtil.getDefaultCommonRange(textWidget, offset, length);
        }
        return styleRange;
    }

    private static StyleRange handleStyleValue(StyledText textWidget, int offset, int length, String brightStyleValue, String property, String defaultColor, boolean isLink) {
        JsonObject style;
        JsonValue styleValue = null;
        try {
            styleValue = Json.parse((String)brightStyleValue);
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        if (styleValue != null && styleValue.isObject() && (style = styleValue.asObject()).get(property) != null && style.get(property).isObject()) {
            return UIUtil.getStyleRange(textWidget, offset, length, style.get(property).asObject(), defaultColor, isLink);
        }
        return null;
    }

    private static StyleRange getStyleRange(StyledText textWidget, int offset, int length, JsonObject style, String defaultColor, boolean isLink) {
        String foregroundString;
        RGB rgb;
        JsonValue foregroundValue;
        String backgroundString;
        RGB rgb2;
        JsonValue backgroundValue;
        JsonValue hideUnderlineValue;
        JsonValue underlineStyleValue;
        JsonValue underlineValue;
        JsonValue fontSizeValue;
        JsonValue fontFamilyValue;
        int contentLength = textWidget.getCharCount();
        if (contentLength - offset < 0) {
            return null;
        }
        StyleRange range = new StyleRange(offset, offset + length < contentLength ? length : contentLength - offset, defaultColor == null ? null : JFaceResources.getResources().createColor(ColorUtil.getColorValue((String)defaultColor)), null);
        JsonValue fontStyleValue = style.get("fontStyle");
        if (fontStyleValue != null && fontStyleValue.isNumber()) {
            range.fontStyle = fontStyleValue.asInt();
        }
        if ((fontFamilyValue = style.get("fontFamily")) != null && fontFamilyValue.isString()) {
            FontData fontData;
            if (range.font == null) {
                Font font;
                fontData = textWidget.getFont().getFontData()[0];
                fontData.setName(fontFamilyValue.asString());
                range.font = font = new Font((Device)textWidget.getDisplay(), fontData);
            } else {
                fontData = range.font.getFontData()[0];
                fontData.setName(fontFamilyValue.asString());
            }
        }
        if ((fontSizeValue = style.get("fontSize")) != null && fontSizeValue.isNumber()) {
            FontData textFontData = textWidget.getFont().getFontData()[0];
            if (fontSizeValue.asInt() > textFontData.getHeight()) {
                FontData fontData;
                if (range.font == null) {
                    Font font;
                    fontData = textFontData;
                    fontData.setHeight(fontSizeValue.asInt());
                    range.font = font = new Font((Device)textWidget.getDisplay(), fontData);
                } else {
                    fontData = range.font.getFontData()[0];
                    fontData.setHeight(fontSizeValue.asInt());
                }
            }
        }
        if (isLink) {
            range.underline = true;
            range.underlineStyle = 4;
        }
        if ((underlineValue = style.get("underline")) != null && underlineValue.isBoolean()) {
            range.underline = underlineValue.asBoolean();
            if (range.underline) {
                range.underlineStyle = 4;
            }
        }
        if ((underlineStyleValue = style.get("underlineStyle")) != null && underlineStyleValue.isNumber()) {
            range.underlineStyle = underlineStyleValue.asInt();
        }
        if ((hideUnderlineValue = style.get("hideUnderline")) != null && hideUnderlineValue.isBoolean() && hideUnderlineValue.asBoolean()) {
            range.underlineColor = textWidget.getBackground();
        }
        if ((backgroundValue = style.get("background")) != null && backgroundValue.isString() && (rgb2 = ColorUtil.getColorValue((String)(backgroundString = backgroundValue.asString()))) != null) {
            range.background = new Color((Device)textWidget.getDisplay(), rgb2);
        }
        if ((foregroundValue = style.get("foreground")) != null && foregroundValue.isString() && (rgb = ColorUtil.getColorValue((String)(foregroundString = foregroundValue.asString()))) != null) {
            range.foreground = new Color((Device)textWidget.getDisplay(), rgb);
            if (range.underlineColor == null) {
                range.underlineColor = range.foreground;
            }
        }
        return range;
    }

    public static boolean isDark(Control textWidget) {
        if (textWidget != null && !textWidget.isDisposed()) {
            Color color = textWidget.getBackground();
            int red = color.getRed();
            int blue = color.getBlue();
            int green = color.getGreen();
            return red < 127 || blue < 127 || green < 127;
        }
        return false;
    }

    public static StyleRange getAdLinkStyleRange(StyledText textWidget, int offset, int length) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IPreferenceStore preferences = (IPreferenceStore)ReflectionUtils.getFieldValue(textTools, "fPreferenceStore");
        String linkColor = preferences.getString("java_doc_default");
        StyleRange styleRange = null;
        if (UIUtil.isDark((Control)textWidget)) {
            String darkStyleValue = JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("darkStyle");
            if (darkStyleValue != null && darkStyleValue.trim().length() > 0) {
                styleRange = UIUtil.handleStyleValue(textWidget, offset, length, darkStyleValue, "link", linkColor, true);
            }
        } else {
            String brightStyleValue = JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("brightStyle");
            if (brightStyleValue != null && brightStyleValue.trim().length() > 0) {
                styleRange = UIUtil.handleStyleValue(textWidget, offset, length, brightStyleValue, "link", linkColor, true);
            }
        }
        if (styleRange == null) {
            styleRange = UIUtil.getDefaultLinkRange(textWidget, offset, length);
        }
        return styleRange;
    }

    private static StyleRange getDefaultLinkRange(StyledText textWidget, int offset, int length) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IPreferenceStore preferences = (IPreferenceStore)ReflectionUtils.getFieldValue(textTools, "fPreferenceStore");
        String linkColor = preferences.getString("java_doc_link");
        StyleRange range = new StyleRange(offset, length, JFaceResources.getResources().createColor(ColorUtil.getColorValue((String)linkColor)), null);
        range.font = textWidget.getFont();
        range.underline = true;
        range.underlineStyle = 4;
        return range;
    }

    private static StyleRange getDefaultCommonRange(StyledText textWidget, int offset, int length) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IPreferenceStore preferences = (IPreferenceStore)ReflectionUtils.getFieldValue(textTools, "fPreferenceStore");
        String commentColor = preferences.getString("java_doc_default");
        StyleRange range = new StyleRange(offset, length, new Color((Device)textWidget.getDisplay(), ColorUtil.getColorValue((String)commentColor)), null);
        range.font = textWidget.getFont();
        return range;
    }

    public static boolean requestFromLinkToSelection() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 10) {
            if (stacks[i].getMethodName().equals("linkToEditor") || stacks[i].getMethodName().equals("showSource")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestFromCopyOperation() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 10) {
            if (stacks[i].getMethodName().equals("doCutCopyWithImportsOperation")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

