/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.util.IOUtils;

public class FileUtil {
    public static void writeToFile(File file, String string) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            String encoding = null;
            try {
                encoding = JavaDecompilerPlugin.getDefault().getExportEncoding();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (encoding == null || encoding.trim().length() == 0) {
                encoding = "UTF-8";
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            out.print(string);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToBinarayFile(File file, InputStream source, boolean close) {
        block12: {
            BufferedInputStream bis = null;
            FilterOutputStream fouts = null;
            try {
                bis = new BufferedInputStream(source);
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                fouts = new BufferedOutputStream(new FileOutputStream(file));
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = bis.read(b)) != -1) {
                    ((BufferedOutputStream)fouts).write(b, 0, i);
                }
                ((BufferedOutputStream)fouts).flush();
                fouts.close();
                if (close) {
                    bis.close();
                }
            }
            catch (IOException e) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Write binaray file failed.", e);
                try {
                    if (fouts != null) {
                        fouts.close();
                    }
                }
                catch (IOException f) {
                    Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Close output stream failed.", f);
                }
                if (!close) break block12;
                try {
                    if (bis != null) {
                        bis.close();
                    }
                }
                catch (IOException f) {
                    Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Close input stream failed.", f);
                }
            }
        }
    }

    public static boolean copyFile(String src, String des) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            FileUtil.writeToBinarayFile(new File(des), fis, false);
            fis.close();
        }
        catch (Exception e) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Copy file failed.", e);
            try {
                fis.close();
                return true;
            }
            catch (IOException f) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Close input stream failed.", f);
            }
        }
        return false;
    }

    public static boolean copyDirectory(File srcDirectory, File desDirectory) {
        if (srcDirectory == null || desDirectory == null) {
            return false;
        }
        return FileUtil.copyDirectory(srcDirectory.getAbsolutePath(), desDirectory.getAbsolutePath(), null);
    }

    public static boolean copyDirectory(String srcDirectory, String desDirectory) {
        return FileUtil.copyDirectory(srcDirectory, desDirectory, null);
    }

    public static boolean copyDirectory(String srcDirectory, String desDirectory, FileFilter filter) {
        try {
            File des = new File(desDirectory);
            if (!des.exists()) {
                des.mkdirs();
            }
            File src = new File(srcDirectory);
            File[] allFile = src.listFiles();
            int totalNum = allFile.length;
            String srcName = "";
            String desName = "";
            int currentFile = 0;
            currentFile = 0;
            while (currentFile < totalNum) {
                if (!allFile[currentFile].isDirectory()) {
                    srcName = allFile[currentFile].toString();
                    desName = String.valueOf(desDirectory) + File.separator + allFile[currentFile].getName();
                    if (filter == null || filter.accept(new File(srcName))) {
                        FileUtil.copyFile(srcName, desName);
                    }
                } else if (!FileUtil.copyDirectory(allFile[currentFile].getPath().toString(), String.valueOf(desDirectory) + File.separator + allFile[currentFile].getName().toString(), filter)) {
                    Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Copy sub directory " + srcDirectory + "failed.");
                }
                ++currentFile;
            }
            return true;
        }
        catch (Exception e) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.WARNING, "Copy directory " + srcDirectory + "failed.", e);
            return false;
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        FileUtil.copyDirectoryToDirectory(srcDir, destDir, null);
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        if (srcDir == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (srcDir.exists() && !srcDir.isDirectory()) {
            throw new IllegalArgumentException("Source '" + destDir + "' is not a directory");
        }
        if (destDir == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination '" + destDir + "' is not a directory");
        }
        FileUtil.copyDirectory(srcDir.getAbsolutePath(), new File(destDir, srcDir.getName()).getAbsolutePath(), filter);
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null) {
            return 0L;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            size = file.isDirectory() ? (size += FileUtil.sizeOfDirectory(file)) : (size += file.length());
            ++i;
        }
        return size;
    }

    public static void deleteDirectory(IProgressMonitor monitor, File directory, File base, int step) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(monitor, directory, base, step);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void deleteDirectory(IProgressMonitor monitor, File directory, int step) throws IOException {
        FileUtil.deleteDirectory(monitor, directory, directory, step);
    }

    public static void cleanDirectory(IProgressMonitor monitor, File directory, File base, int step) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        IOException exception = null;
        boolean isPackage = false;
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (!isPackage && file.isFile()) {
                isPackage = true;
            }
            try {
                FileUtil.forceDelete(monitor, file, base, step);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
            ++i;
        }
        if (isPackage && monitor != null) {
            monitor.worked(step);
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void forceDelete(IProgressMonitor monitor, File file, File base, int step) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(monitor, file, base, step);
        } else {
            if (monitor != null) {
                String taskName = file.getAbsolutePath().substring(base.getAbsolutePath().length() + new Long(System.currentTimeMillis()).toString().length() + 2);
                monitor.subTask(taskName);
            }
            if (!file.exists()) {
                throw new FileNotFoundException("File does not exist: " + file);
            }
            if (!file.delete()) {
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static void recursiveZip(IProgressMonitor monitor, ZipOutputStream zos, File file, String path, FileFilter filter, int step) throws FileNotFoundException, IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    FileUtil.recursiveZip(monitor, zos, files[i], String.valueOf(path.length() > 0 ? String.valueOf(path) + "/" : path) + files[i].getName(), filter, step);
                    ++i;
                }
            }
            if (monitor != null) {
                monitor.worked(step);
            }
        }
        if (file.isFile()) {
            if (monitor != null) {
                monitor.subTask(path);
            }
            byte[] bt = new byte[512];
            ZipEntry ze = new ZipEntry(path);
            ze.setSize(file.length());
            zos.putNextEntry(ze);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            int i = 0;
            while ((i = fis.read(bt)) != -1) {
                zos.write(bt, 0, i);
            }
            fis.close();
        }
    }

    public static void zipFile(File file, String zipFile) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
        ZipEntry ze = null;
        byte[] buf = new byte[1024];
        int readLen = 0;
        ze = new ZipEntry(file.getName());
        ze.setSize(file.length());
        ze.setTime(file.lastModified());
        zos.putNextEntry(ze);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
            zos.write(buf, 0, readLen);
        }
        ((InputStream)is).close();
        zos.close();
    }

    public static void filterZipFile(String filePath, Filter filter) throws Exception {
        if (FileUtil.isZipFile(filePath) && filter != null) {
            File file = new File(filePath);
            ZipFile zipFile = new ZipFile(file);
            ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = null;
            InputStream input = null;
            File tmpFile = new File(file + ".tmp");
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmpFile));
            zos.setLevel(1);
            while ((entry = zis.getNextEntry()) != null) {
                if (!filter.accept(entry.getName())) continue;
                input = zipFile.getInputStream(entry);
                ZipEntry ze = new ZipEntry(entry.getName());
                ze.setSize(entry.getSize());
                ze.setTime(entry.getTime());
                zos.putNextEntry(ze);
                IOUtils.copy(zis, zos);
                input.close();
            }
            zis.close();
            zos.close();
            zipFile.close();
            file.delete();
            tmpFile.renameTo(file);
        }
    }

    public static void zipDir(File dir, String classPackage, String zipFile) throws Exception {
        File[] files = null;
        if (new File(dir, classPackage).exists()) {
            files = new File(dir, classPackage).listFiles();
        } else if (dir.exists()) {
            files = dir.listFiles();
        }
        if (files != null) {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipEntry ze = null;
            byte[] buf = new byte[1024];
            int readLen = 0;
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (!file.isDirectory()) {
                    ze = new ZipEntry(String.valueOf(classPackage.length() > 0 ? String.valueOf(classPackage) + "/" : "") + file.getName());
                    ze.setSize(file.length());
                    ze.setTime(file.lastModified());
                    zos.putNextEntry(ze);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                    while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                        zos.write(buf, 0, readLen);
                    }
                    ((InputStream)is).close();
                }
                ++i;
            }
            zos.close();
        }
    }

    public static boolean isZipFile(String path) {
        if (path == null) {
            return false;
        }
        try {
            new ZipFile(path).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] tmp = new byte[4096];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((r = ((InputStream)is).read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
            byte[] bytes = out.toByteArray();
            ((InputStream)is).close();
            out.close();
            String content = new String(bytes);
            return content.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContent(File file, String enconding) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] tmp = new byte[4096];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((r = ((InputStream)is).read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
            byte[] bytes = out.toByteArray();
            ((InputStream)is).close();
            out.close();
            String content = new String(bytes, enconding);
            return content.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContent(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] tmp = new byte[4096];
            while ((r = is.read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
            byte[] bytes = out.toByteArray();
            is.close();
            out.close();
            String content = new String(bytes);
            return content.trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getBytes(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            int r;
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            byte[] tmp = new byte[4096];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((r = ((InputStream)is).read(tmp)) != -1) {
                out.write(tmp, 0, r);
            }
            byte[] bytes = out.toByteArray();
            ((InputStream)is).close();
            out.close();
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeToFile(File file, String string, String encoding) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            out.print(string);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deltree(File root) {
        if (root == null || !root.exists()) {
            return;
        }
        if (root.isFile()) {
            root.delete();
            return;
        }
        File[] children = root.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                FileUtil.deltree(children[i]);
                ++i;
            }
        }
        root.delete();
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

