/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.fernflower;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class FernFlowerDecompiler
implements IDecompiler {
    private String source = "";
    private long time;
    private long start;
    private String log = "";
    ByteArrayOutputStream loggerStream;

    @Override
    public void decompile(String root, String packege, final String className) {
        File tmpDir;
        if (root == null || packege == null || className == null) {
            return;
        }
        this.start = System.currentTimeMillis();
        this.log = "";
        this.source = "";
        this.loggerStream = new ByteArrayOutputStream();
        File workingDir = new File(String.valueOf(root) + "/" + packege);
        HashMap<String, String> mapOptions = new HashMap<String, String>();
        mapOptions.put("rsy", "1");
        mapOptions.put("dgs", "1");
        mapOptions.put("din", "1");
        mapOptions.put("den", "1");
        mapOptions.put("log", IFernflowerLogger.Severity.ERROR.name());
        mapOptions.put("asc", "1");
        if (ClassUtil.isDebug()) {
            mapOptions.put("__dump_original_lines__", "1");
            mapOptions.put("bsm", "1");
        }
        if (!(tmpDir = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()))).exists()) {
            tmpDir.mkdirs();
        }
        class EmbeddedConsoleDecompiler
        extends ConsoleDecompiler {
            protected EmbeddedConsoleDecompiler(File file, Map map) {
                super(file, map, (IFernflowerLogger)new PrintStreamLogger(new PrintStream(FernFlowerDecompiler.this.loggerStream)));
            }
        }
        EmbeddedConsoleDecompiler decompiler = new EmbeddedConsoleDecompiler(tmpDir, mapOptions);
        File[] files = workingDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().indexOf(className.toLowerCase()) != -1;
            }
        });
        if (files != null) {
            int j = 0;
            while (j < files.length) {
                decompiler.addSource(files[j]);
                ++j;
            }
        }
        decompiler.decompileContext();
        File classFile = new File(tmpDir, className.replaceAll("(?i)\\.class", ".java"));
        this.source = UnicodeUtil.decode(FileUtil.getContent(classFile));
        classFile.delete();
        FileUtil.deltree(tmpDir);
        Pattern wp = Pattern.compile("/\\*.+?\\*/", 32);
        Matcher m = wp.matcher(this.source);
        while (m.find()) {
            if (m.group().matches("/\\*\\s*\\d*\\s*\\*/")) continue;
            String group = m.group();
            group = group.replace("/*", "");
            group = group.replace("*/", "");
            group = group.replace("*", "");
            if (this.log.length() > 0) {
                this.log = String.valueOf(this.log) + "\n";
            }
            this.log = String.valueOf(this.log) + group;
            this.source = this.source.replace(m.group(), "");
        }
        this.time = System.currentTimeMillis() - this.start;
    }

    @Override
    public void decompileFromArchive(String archivePath, String packege, String className) {
        this.start = System.currentTimeMillis();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract(archivePath, packege, className, true, workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.logError(e, e.getMessage());
                FileUtil.deltree(workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree(workingDir);
        }
    }

    @Override
    public long getDecompilationTime() {
        return this.time;
    }

    @Override
    public List getExceptions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getLog() {
        if (this.loggerStream != null) {
            return String.valueOf(this.log) + this.loggerStream.toString();
        }
        return this.log;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getDecompilerType() {
        return "FernFlower";
    }

    @Override
    public String removeComment(String source) {
        return source;
    }

    @Override
    public boolean supportLevel(int level) {
        return true;
    }

    @Override
    public boolean supportDebugLevel(int level) {
        return true;
    }

    @Override
    public boolean supportDebug() {
        return true;
    }
}

