/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.bytecode.ByteCodeConstants;
import com.drgarbage.javasrc.JavaKeywords;
import com.drgarbage.javasrc.JavaLexicalConstants;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class RenderedBytecodeScanner
extends AbstractJavaScanner
implements JavaLexicalConstants,
JavaKeywords {
    private static final String[] RENDERED_BYTECODE_KEYWORDS = new String[]{"abstract", "catch", "class", "const", "default", "extends", "final", "finally", "implements", "import", "interface", "native", "package", "private", "protected", "public", "static", "super", "synchronized", "this", "throws", "transient", "try", "volatile", "enum", "void", "boolean", "char", "byte", "short", "strictfp", "int", "long", "float", "double", "false", "null", "true"};
    private static String[] tokenProperties = new String[]{"java_keyword", "java_string", "java_default", "java_operator", "BYTECODEMNEMONIC_bytecodeMnemonic"};

    public RenderedBytecodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return tokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("java_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        token = this.getToken("java_operator");
        rules.add(new OperatorRule((IToken)token));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector());
        token = this.getToken("java_keyword");
        int i = 0;
        while (i < RENDERED_BYTECODE_KEYWORDS.length) {
            wordRule.addWord(RENDERED_BYTECODE_KEYWORDS[i], (IToken)token);
            ++i;
        }
        token = this.getToken("BYTECODEMNEMONIC_bytecodeMnemonic");
        i = 0;
        while (i < ByteCodeConstants.OPCODE_MNEMONICS.length) {
            String word = ByteCodeConstants.OPCODE_MNEMONICS[i];
            if (word != null) {
                wordRule.addWord(word, (IToken)token);
            }
            ++i;
        }
        rules.add(wordRule);
        token = this.getToken("java_default");
        rules.add((Object)new SimpleRule(new WordDetector(), (IToken)token));
        token = this.getToken("java_string");
        rules.add((Object)new SimpleRule(new NumberWordDetector(), (IToken)token));
        this.setDefaultReturnToken((IToken)this.getToken("java_default"));
        return rules;
    }

    private static class NumberWordDetector
    implements IWordDetector {
        private NumberWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isDigit(c);
        }

        public boolean isWordPart(char c) {
            return Character.isDigit(c) || c == '.';
        }
    }

    private class OperatorRule
    implements IRule {
        private final char[] JAVA_OPERATORS = new char[]{';', '(', ')', '{', '}', '.', '=', '/', '\\', '+', '-', '*', '[', ']', '<', '>', ':', '?', '!', ',', '|', '&', '^', '&', '~'};
        private final IToken fToken;

        public OperatorRule(IToken token) {
            this.fToken = token;
        }

        public boolean isOperator(char character) {
            int index = 0;
            while (index < this.JAVA_OPERATORS.length) {
                if (this.JAVA_OPERATORS[index] == character) {
                    return true;
                }
                ++index;
            }
            return false;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isOperator((char)character)) {
                while (this.isOperator((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.fToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class SimpleRule
    extends WordRule {
        private IToken token;
        private StringBuffer fBuffer = new StringBuffer();

        public SimpleRule(IWordDetector detector, IToken token) {
            super(detector);
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int c = scanner.read();
            if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    private static class WhitespaceDetector
    implements IWhitespaceDetector {
        private WhitespaceDetector() {
        }

        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }

    private static class WordDetector
    implements IWordDetector {
        private WordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }
}

