/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.ImportDeclarationElementInfo;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.sf.feeling.decompiler.editor.ClassImportContainer;
import org.sf.feeling.decompiler.util.DecompilerOutputUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.SourceMapperUtil;

public class ImportSourceMapper
extends SourceMapper {
    private static Map<String, String> options = new HashMap<String, String>();
    protected Stack infoStack;
    protected HashMap children;
    protected Stack handleStack;
    protected ClassFile unit;
    protected OpenableElementInfo unitInfo;
    protected ImportContainerInfo importContainerInfo = null;
    protected ImportContainer importContainer;
    private JavaModelManager manager = JavaModelManager.getJavaModelManager();

    static {
        CompilerOptions option = new CompilerOptions();
        options = option.getMap();
        options.put("org.eclipse.jdt.core.compiler.compliance", DecompilerOutputUtil.getMaxDecompileLevel());
        options.put("org.eclipse.jdt.core.compiler.source", DecompilerOutputUtil.getMaxDecompileLevel());
    }

    public ImportSourceMapper(IPath sourcePath, String rootPath) {
        this(sourcePath, rootPath, options);
    }

    public ImportSourceMapper(IPath sourcePath, String rootPath, Map options) {
        super(sourcePath, rootPath, options);
    }

    public void enterCompilationUnit() {
        this.infoStack = new Stack();
        this.children = new HashMap();
        this.handleStack = new Stack();
        this.infoStack.push(this.unitInfo);
        this.handleStack.push(this.unit);
    }

    public ISourceRange mapSourceSwitch(IType type, char[] contents, IBinaryType info, IJavaElement elementToFind) {
        this.unit = (ClassFile)type.getClassFile();
        try {
            this.unitInfo = (OpenableElementInfo)this.unit.getElementInfo();
        }
        catch (JavaModelException e) {
            Logger.debug(e);
        }
        try {
            SourceMapperUtil.mapSource(this, type, contents, info, elementToFind);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void exitCompilationUnit(int declarationEnd) {
        IJavaElement[] oldChildren = (IJavaElement[])ReflectionUtils.getFieldValue(this.unitInfo, "children");
        if (this.importContainerInfo != null) {
            ReflectionUtils.setFieldValue(this.importContainerInfo, "children", this.getChildren(this.importContainerInfo));
        }
        ArrayList<IJavaElement> children = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < oldChildren.length) {
            IJavaElement child = oldChildren[i];
            if (!(child instanceof ImportContainer)) {
                children.add(child);
            }
            ++i;
        }
        children.addAll(Arrays.asList(this.getChildren(this.unitInfo)));
        ReflectionUtils.setFieldValue(this.unitInfo, "children", children.toArray(new IJavaElement[0]));
        if (this.importContainer != null) {
            this.manager.getTemporaryCache().put(this.importContainer, this.importContainerInfo);
        }
        ReflectionUtils.invokeMethod((Object)this.manager, "putInfos", new Class[]{IJavaElement.class, Object.class, Boolean.TYPE, Map.class}, new Object[]{this.unit, this.unitInfo, false, this.manager.getTemporaryCache()});
    }

    private IJavaElement[] getChildren(Object info) {
        ArrayList childrenList = (ArrayList)this.children.get(info);
        if (childrenList != null) {
            return childrenList.toArray(new IJavaElement[childrenList.size()]);
        }
        return new JavaElement[0];
    }

    protected ImportContainer createImportContainer(ClassFile parent) {
        return new ClassImportContainer(parent);
    }

    private void addToChildren(Object parentInfo, JavaElement handle) {
        ArrayList<JavaElement> childrenList = (ArrayList<JavaElement>)this.children.get(parentInfo);
        if (childrenList == null) {
            childrenList = new ArrayList<JavaElement>();
            this.children.put(parentInfo, childrenList);
        }
        childrenList.add(handle);
    }

    protected ImportDeclaration createImportDeclaration(ImportContainer parent, String name, boolean onDemand) {
        try {
            Constructor c = ImportDeclaration.class.getDeclaredConstructor(ImportContainer.class, String.class, Boolean.TYPE);
            c.setAccessible(true);
            ImportDeclaration dec = (ImportDeclaration)c.newInstance(parent, name, onDemand);
            return dec;
        }
        catch (Exception e) {
            Logger.debug(e);
            return null;
        }
    }

    public void acceptImport(int declarationStart, int declarationEnd, int nameSourceStart, int nameSourceEnd, char[][] tokens, boolean onDemand, int modifiers) {
        JavaElement parentHandle = (JavaElement)this.handleStack.peek();
        if (parentHandle.getElementType() != 6) {
            Assert.isTrue((boolean)false);
        }
        ClassFile parentCU = (ClassFile)parentHandle;
        if (this.importContainer == null) {
            this.importContainer = this.createImportContainer(parentCU);
            this.importContainerInfo = new ImportContainerInfo();
            Object parentInfo = this.infoStack.peek();
            this.addToChildren(parentInfo, (JavaElement)this.importContainer);
        }
        String elementName = JavaModelManager.getJavaModelManager().intern(new String(CharOperation.concatWith((char[][])tokens, (char)'.')));
        ImportDeclaration handle = this.createImportDeclaration(this.importContainer, elementName, onDemand);
        ImportDeclarationElementInfo info = new ImportDeclarationElementInfo();
        ReflectionUtils.invokeMethod((Object)info, "setSourceRangeStart", Integer.TYPE, declarationStart);
        ReflectionUtils.invokeMethod((Object)info, "setSourceRangeEnd", Integer.TYPE, declarationEnd);
        ReflectionUtils.invokeMethod((Object)info, "setNameSourceStart", Integer.TYPE, nameSourceStart);
        ReflectionUtils.invokeMethod((Object)info, "setNameSourceEnd", Integer.TYPE, nameSourceEnd);
        ReflectionUtils.invokeMethod((Object)info, "setFlags", Integer.TYPE, modifiers);
        this.addToChildren(this.importContainerInfo, (JavaElement)handle);
        this.manager.getTemporaryCache().put(handle, info);
    }
}

