/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.classfile.editors.ClassFileParser;
import com.drgarbage.utils.ClassFileDocumentsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.breadcrumb.EditorBreadcrumb;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.actions.ByteCodeAction;
import org.sf.feeling.decompiler.actions.DisassemblerAction;
import org.sf.feeling.decompiler.actions.SourceCodeAction;
import org.sf.feeling.decompiler.editor.ByteCodeDocument;
import org.sf.feeling.decompiler.editor.DisassemblerDocumentProvider;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.UIUtil;

public class ByteCodeSourceViewer
extends AbstractDecoratedTextEditor {
    private JavaDecompilerClassFileEditor editor;
    private ByteCodeDocument byteCodeDocument;
    private Composite container;

    public ByteCodeSourceViewer(JavaDecompilerClassFileEditor editor) {
        this.editor = editor;
    }

    public StyledText getTextWidget() {
        return this.getSourceViewer().getTextWidget();
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        stores.add(JavaDecompilerPlugin.getDefault().getPreferenceStore());
        stores.add(JavaPlugin.getDefault().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    public Composite createControl(Composite parent) {
        this.setSite(this.editor.getSite());
        DisassemblerDocumentProvider provider = new DisassemblerDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)provider);
        this.setInput(this.editor.getEditorInput());
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new FillLayout());
        IPreferenceStore store = this.createCombinedPreferenceStore();
        this.setPreferenceStore(store);
        int styles = 68354;
        IVerticalRuler fVerticalRuler = this.createVerticalRuler();
        ReflectionUtils.setFieldValue((Object)this, "fVerticalRuler", fVerticalRuler);
        JavaSourceViewer fSourceViewer = new JavaSourceViewer(this.container, fVerticalRuler, null, false, styles, store);
        ReflectionUtils.setFieldValue((Object)this, "fSourceViewer", fSourceViewer);
        this.getSourceViewerDecorationSupport((ISourceViewer)fSourceViewer);
        this.createActions();
        ReflectionUtils.invokeMethod((Object)this, "initializeSourceViewer", new Class[]{IEditorInput.class}, new Object[]{this.getEditorInput()});
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        }
        StyledText styledText = fSourceViewer.getTextWidget();
        styledText.addMouseListener((MouseListener)this.getCursorListener());
        styledText.addKeyListener((KeyListener)this.getCursorListener());
        ReflectionUtils.setFieldValue((Object)this, "fEditorContextMenuId", "#TextEditorContext");
        String id = "#TextEditorContext";
        MenuManager manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Menu fTextContextMenu = manager.createContextMenu((Control)styledText);
        styledText.setMenu(fTextContextMenu);
        ReflectionUtils.setFieldValue((Object)this, "fRulerContextMenuId", "#TextRulerContext");
        id = "#TextRulerContext";
        manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Control rulerControl = fVerticalRuler.getControl();
        Menu fRulerContextMenu = manager.createContextMenu(rulerControl);
        rulerControl.setMenu(fRulerContextMenu);
        rulerControl.addMouseListener(this.getRulerMouseListener());
        this.createOverviewRulerContextMenu();
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager colorManager = textTools.getColorManager();
        JavaSourceViewerConfiguration classFileConfiguration = new JavaSourceViewerConfiguration(colorManager, store, (ITextEditor)this.editor, "___java_partitioning");
        fSourceViewer.configure((SourceViewerConfiguration)classFileConfiguration);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)classFileConfiguration);
        this.getSourceViewerDecorationSupport((ISourceViewer)fSourceViewer).install(this.getPreferenceStore());
        this.initializeViewerColors((ISourceViewer)fSourceViewer);
        ReflectionUtils.invokeMethod((Object)this, "initializeViewerFont", new Class[]{ISourceViewer.class}, new Object[]{fSourceViewer});
        ClassFile cf = (ClassFile)((IClassFileEditorInput)this.editor.getEditorInput()).getClassFile();
        this.byteCodeDocument = new ByteCodeDocument(this);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)this.byteCodeDocument, "___java_partitioning");
        try {
            ClassFileParser parser = new ClassFileParser();
            String content = parser.parseClassFile(cf.getBytes());
            this.byteCodeDocument.set(content == null ? "" : content);
        }
        catch (Exception e) {
            ClassFileBytesDisassembler disassembler = ToolFactory.createDefaultClassFileBytesDisassembler();
            try {
                String content = disassembler.disassemble(cf.getBytes(), "\n", 1);
                this.byteCodeDocument.set(content == null ? "" : content);
            }
            catch (Exception ex) {
                Logger.debug(e);
            }
        }
        EditorSelectionChangedListener fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        fEditorSelectionChangedListener.install(this.getSelectionProvider());
        fSourceViewer.setDocument((IDocument)this.byteCodeDocument);
        provider.setDocument((IDocument)this.byteCodeDocument);
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof CompositeRuler) {
            this.updateContributedRulerColumns((CompositeRuler)ruler);
        }
        IColumnSupport columnSupport = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        RulerColumnDescriptor lineNumberColumnDescriptor = RulerColumnRegistry.getDefault().getColumnDescriptor("org.eclipse.ui.editors.columns.linenumbers");
        if (lineNumberColumnDescriptor != null) {
            columnSupport.setColumnVisible(lineNumberColumnDescriptor, this.isLineNumberRulerVisible());
        }
        IPropertyChangeListener fFontPropertyChangeListener = (IPropertyChangeListener)ReflectionUtils.getFieldValue((Object)this, "fFontPropertyChangeListener");
        JFaceResources.getFontRegistry().addListener(fFontPropertyChangeListener);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ByteCodeSourceViewer.this.dispose();
            }
        });
        return this.container;
    }

    private void doHandleCursorPositionChanged() {
        int selectedRange;
        StyledText byteCodeText = this.getSourceViewer().getTextWidget();
        String byteCode = byteCodeText.getText();
        IJavaElement element = this.getJavaElement(byteCode, selectedRange = byteCodeText.getSelectionRange().x);
        if (element != null) {
            this.editor.setSelection(element);
        }
    }

    public IJavaElement getJavaElement(String byteCode, int index) {
        if (byteCode.lastIndexOf("/* Methods: */") != -1) {
            int methodStartIndex = byteCode.substring(0, byteCode.lastIndexOf("/* Methods: */")).lastIndexOf("\n") + 1;
            int methodEndIndex = byteCode.substring(0, byteCode.lastIndexOf("attributes_count")).lastIndexOf("\n");
            if (index >= methodStartIndex && index <= methodEndIndex) {
                return this.getMethod(byteCode.substring(methodStartIndex, methodEndIndex), index - methodStartIndex);
            }
            if (byteCode.lastIndexOf("/* Fields: */") != -1) {
                int fieldStartIndex = byteCode.substring(0, byteCode.lastIndexOf("/* Fields: */")).lastIndexOf("\n") + 1;
                int fieldEndIndex = methodStartIndex - 1;
                if (index >= fieldStartIndex && index <= fieldEndIndex) {
                    return this.getField(byteCode.substring(fieldStartIndex, fieldEndIndex), index - fieldStartIndex);
                }
            }
        } else if (byteCode.lastIndexOf("/* Fields: */") != -1) {
            int fieldStartIndex = byteCode.substring(0, byteCode.lastIndexOf("/* Fields: */")).lastIndexOf("\n") + 1;
            int fieldEndIndex = byteCode.substring(0, byteCode.lastIndexOf("attributes_count")).lastIndexOf("\n");
            if (index >= fieldStartIndex && index <= fieldEndIndex) {
                return this.getField(byteCode.substring(fieldStartIndex, fieldEndIndex), index - fieldStartIndex);
            }
        }
        ClassFile cf = (ClassFile)((IClassFileEditorInput)this.getEditorInput()).getClassFile();
        return cf.getType();
    }

    private IField getField(String text, int index) {
        int end;
        int start;
        Pattern pattern = Pattern.compile("Field\\[\\d+\\].+?Field\\[\\d+\\]", 32);
        Matcher matcher = pattern.matcher(text);
        int fieldStartIndex = text.substring(0, index).lastIndexOf("\n") + 1;
        int findIndex = 0;
        while (matcher.find(findIndex)) {
            start = text.substring(0, matcher.start()).lastIndexOf("\n") + 1;
            end = text.substring(0, matcher.end()).lastIndexOf("\n");
            if (fieldStartIndex >= start && fieldStartIndex <= end) {
                String field = text.substring(start, end);
                return this.getField(field);
            }
            findIndex = end;
        }
        if (text.lastIndexOf("Field[") != -1) {
            start = text.substring(0, text.lastIndexOf("Field[")).lastIndexOf("\n") + 1;
            end = text.length();
            if (fieldStartIndex >= start && fieldStartIndex <= end) {
                String field = text.substring(start, end);
                return this.getField(field);
            }
        }
        return null;
    }

    private IField getField(String field) {
        int lastIndex;
        String startText;
        int firstIndex;
        ClassFile cf = (ClassFile)((IClassFileEditorInput)this.getEditorInput()).getClassFile();
        int nameIndex = field.indexOf("name_index");
        if (nameIndex != -1 && (firstIndex = (startText = field.substring(nameIndex)).indexOf(34)) != -1 && (lastIndex = startText.indexOf(34, firstIndex + 1)) != -1) {
            String fieldName = startText.substring(firstIndex + 1, lastIndex);
            IField f = cf.getType().getField(fieldName);
            if (f != null) {
                return f;
            }
        }
        return null;
    }

    private IMethod getMethod(String text, int index) {
        int end;
        int start;
        Pattern pattern = Pattern.compile("Method\\[\\d+\\].+?Method\\[\\d+\\]", 32);
        Matcher matcher = pattern.matcher(text);
        int methodStartIndex = text.substring(0, index).lastIndexOf("\n") + 1;
        int findIndex = 0;
        while (matcher.find(findIndex)) {
            start = text.substring(0, matcher.start()).lastIndexOf("\n") + 1;
            end = text.substring(0, matcher.end()).lastIndexOf("\n");
            if (methodStartIndex >= start && methodStartIndex <= end) {
                String method = text.substring(start, end);
                return this.getMethod(method);
            }
            findIndex = end;
        }
        if (text.lastIndexOf("Method[") != -1) {
            start = text.substring(0, text.lastIndexOf("Method[")).lastIndexOf("\n") + 1;
            end = text.length();
            if (methodStartIndex >= start && methodStartIndex <= end) {
                String method = text.substring(start, end);
                return this.getMethod(method);
            }
        }
        return null;
    }

    private IMethod getMethod(String method) {
        int lastIndex;
        String startText;
        int firstIndex;
        int descriptorIndex;
        int lastIndex2;
        String startText2;
        int firstIndex2;
        ClassFile cf = (ClassFile)((IClassFileEditorInput)this.getEditorInput()).getClassFile();
        String methodName = null;
        String descriptor = null;
        int nameIndex = method.indexOf("name_index");
        if (nameIndex != -1 && (firstIndex2 = (startText2 = method.substring(nameIndex)).indexOf(34)) != -1 && (lastIndex2 = startText2.indexOf(34, firstIndex2 + 1)) != -1) {
            methodName = startText2.substring(firstIndex2 + 1, lastIndex2);
        }
        if (methodName == null) {
            return null;
        }
        if ("<init>".equals(methodName)) {
            methodName = cf.getTypeName();
        }
        if ((descriptorIndex = method.indexOf("descriptor_index")) != -1 && (firstIndex = (startText = method.substring(descriptorIndex)).indexOf(34)) != -1 && (lastIndex = startText.indexOf(34, firstIndex + 1)) != -1) {
            descriptor = startText.substring(firstIndex + 1, lastIndex);
        }
        if (descriptor == null) {
            return null;
        }
        try {
            IMethod m = ClassFileDocumentsUtils.findMethod((IType)cf.getType(), (String)methodName, descriptor);
            if (m != null) {
                return m;
            }
        }
        catch (JavaModelException e) {
            Logger.debug(e);
        }
        return null;
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        String text = (String)ReflectionUtils.invokeMethod((Object)this, "getShowInMenuLabel");
        int i = 0;
        while (i < menu.getItems().length) {
            if (menu.getItems()[i] instanceof MenuManager && ((MenuManager)menu.getItems()[i]).getMenuText().equals(text)) {
                menu.remove(menu.getItems()[i]);
            }
            ++i;
        }
        menu.appendToGroup("group.open", this.getAction("SourceCode"));
        menu.appendToGroup("group.open", this.getAction("ByteCode"));
        menu.appendToGroup("group.open", this.getAction("Disassembler"));
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ByteCodeSourceViewer.this.showMenu(manager);
            }
        });
    }

    private void showMenu(IMenuManager submenu) {
        for (IContributionItem item : Arrays.asList(submenu.getItems())) {
            IAction action;
            if (!(item instanceof ActionContributionItem) || !((action = ((ActionContributionItem)item).getAction()) instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    protected void createActions() {
        super.createActions();
        this.setAction("SourceCode", (IAction)new SourceCodeAction());
        this.setAction("ByteCode", (IAction)new ByteCodeAction());
        this.setAction("Disassembler", (IAction)new DisassemblerAction());
    }

    public String[] collectContextMenuPreferencePages() {
        return this.editor.collectContextMenuPreferencePages();
    }

    public boolean isEditorInputModifiable() {
        return false;
    }

    public Control getControl() {
        return this.container;
    }

    public void setSelectionElement(ISourceReference selectedElement) {
        this.setSelectionElement(selectedElement, false);
    }

    public void setSelectionElement(ISourceReference selectedElement, boolean force) {
        StyledText byteCodeText = this.getSourceViewer().getTextWidget();
        if (JavaDecompilerPlugin.getDefault().getSourceMode() == 1 && byteCodeText != null && !byteCodeText.isDisposed()) {
            if (!force) {
                if (UIUtil.requestFromDisassemblerSelection()) {
                    return;
                }
                if (!UIUtil.requestFromLinkToSelection()) {
                    return;
                }
            }
            if (selectedElement instanceof IMethod || selectedElement instanceof IField || selectedElement instanceof BinaryType) {
                try {
                    IRegion element = this.searchElement(byteCodeText, selectedElement);
                    if (element != null) {
                        this.selectElement(byteCodeText, element);
                    }
                }
                catch (Exception e) {
                    Logger.debug(e);
                }
            }
        }
    }

    private IRegion searchElement(StyledText byteCodeText, ISourceReference reference) throws CoreException {
        block6: {
            String byteCode;
            int index;
            BinaryType jdtType;
            ClassFile cf;
            block7: {
                String byteCode2;
                int index2;
                block5: {
                    cf = (ClassFile)((IClassFileEditorInput)this.getEditorInput()).getClassFile();
                    if (!(reference instanceof BinaryType)) break block5;
                    String byteCode3 = byteCodeText.getText();
                    String className = ((BinaryType)reference).getElementName();
                    Pattern pattern = Pattern.compile("this_class.+?\\*", 32);
                    Matcher matcher = pattern.matcher(byteCode3);
                    while (matcher.find()) {
                        String text = matcher.group();
                        int classIndex = text.indexOf(className);
                        if (classIndex == -1) continue;
                        return new Region(matcher.start() + classIndex, className.length());
                    }
                    break block6;
                }
                if (!(reference instanceof IField)) break block7;
                BinaryType jdtType2 = (BinaryType)((IField)reference).getParent();
                if (!jdtType2.equals((Object)cf.getType()) || (index2 = (byteCode2 = byteCodeText.getText()).indexOf("/* Fields: */")) == -1) break block6;
                String fieldName = ((IField)reference).getElementName();
                String fieldByteCode = "bytes=\"" + fieldName + "\"";
                Pattern pattern = Pattern.compile("Field\\[\\d+\\].+?attributes_count", 32);
                Matcher matcher = pattern.matcher(byteCode2);
                while (matcher.find()) {
                    String text = matcher.group();
                    int fieldIndex = text.indexOf(fieldByteCode);
                    if (fieldIndex == -1) continue;
                    return new Region(matcher.start() + fieldIndex + "bytes=\"".length(), fieldName.length());
                }
                break block6;
            }
            if (reference instanceof IMethod && (jdtType = (BinaryType)((IMethod)reference).getParent()).equals((Object)cf.getType()) && (index = (byteCode = byteCodeText.getText()).indexOf("/* Methods: */")) != -1) {
                String methodName = ((IMethod)reference).getElementName();
                if (((IMethod)reference).isConstructor()) {
                    methodName = "<init>";
                }
                String methodByteCode = "bytes=\"" + methodName + "\"";
                String methodSignature = ((IMethod)reference).getSignature();
                Pattern pattern = Pattern.compile("Method\\[\\d+\\].+?attributes_count", 32);
                Matcher matcher = pattern.matcher(byteCode);
                while (matcher.find()) {
                    String text = matcher.group();
                    int methodIndex = text.indexOf(methodByteCode);
                    int methodSignatureIndex = text.indexOf(methodSignature);
                    if (methodIndex == -1 || methodSignatureIndex == -1) continue;
                    return new Region(matcher.start() + methodIndex + "bytes=\"".length(), methodName.length());
                }
            }
        }
        return null;
    }

    private void selectElement(StyledText byteCodeText, IRegion region) {
        if (region != null && region.getOffset() != -1) {
            byteCodeText.setSelection(region.getOffset(), region.getOffset() + region.getLength());
        }
    }

    protected IConfigurationElement getConfigurationElement() {
        return (IConfigurationElement)ReflectionUtils.invokeMethod((Object)this.editor, "getConfigurationElement");
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    protected void handleCursorPositionChanged() {
        ReflectionUtils.invokeMethod((Object)this.editor, "handleCursorPositionChanged");
    }

    private class EditorSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
            super((AbstractTextEditor)ByteCodeSourceViewer.this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ByteCodeSourceViewer.this.doHandleCursorPositionChanged();
        }
    }

    class JdtSelectionProvider
    extends AbstractTextEditor.SelectionProvider {
        private List<ISelectionChangedListener> fSelectionListeners;
        private List<ISelectionChangedListener> fPostSelectionListeners;
        private ITextSelection fInvalidSelection;
        private ISelection fValidSelection;

        JdtSelectionProvider() {
            super((AbstractTextEditor)ByteCodeSourceViewer.this);
            this.fSelectionListeners = new ArrayList<ISelectionChangedListener>();
            this.fPostSelectionListeners = new ArrayList<ISelectionChangedListener>();
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            super.addSelectionChangedListener(listener);
            if (ByteCodeSourceViewer.this.getSourceViewer() != null) {
                this.fSelectionListeners.add(listener);
            }
        }

        public ISelection getSelection() {
            if (this.fInvalidSelection != null) {
                return this.fInvalidSelection;
            }
            return super.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            super.removeSelectionChangedListener(listener);
            if (ByteCodeSourceViewer.this.getSourceViewer() != null) {
                this.fSelectionListeners.remove(listener);
            }
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof ITextSelection) {
                if (this.fInvalidSelection != null) {
                    this.fInvalidSelection = null;
                    ITextSelection newSelection = (ITextSelection)selection;
                    ITextSelection oldSelection = (ITextSelection)this.getSelection();
                    if (newSelection.getOffset() == oldSelection.getOffset() && newSelection.getLength() == oldSelection.getLength()) {
                        this.markValid();
                    } else {
                        super.setSelection(selection);
                    }
                } else {
                    super.setSelection(selection);
                }
            } else if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EditorBreadcrumb) {
                this.markInvalid();
            }
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            super.addPostSelectionChangedListener(listener);
            if (ByteCodeSourceViewer.this.getSourceViewer() != null && ByteCodeSourceViewer.this.getSourceViewer().getSelectionProvider() instanceof IPostSelectionProvider) {
                this.fPostSelectionListeners.add(listener);
            }
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            super.removePostSelectionChangedListener(listener);
            if (ByteCodeSourceViewer.this.getSourceViewer() != null) {
                this.fPostSelectionListeners.remove(listener);
            }
        }

        public boolean isValid(ISelection postSelection) {
            return this.fInvalidSelection == null && super.isValid(postSelection);
        }

        private void markInvalid() {
            this.fValidSelection = this.getSelection();
            this.fInvalidSelection = new TextSelection(0, 0);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.fInvalidSelection);
            for (ISelectionChangedListener listener : this.fSelectionListeners) {
                listener.selectionChanged(event);
            }
            for (ISelectionChangedListener listener : this.fPostSelectionListeners) {
                listener.selectionChanged(event);
            }
        }

        private void markValid() {
            this.fInvalidSelection = null;
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.fValidSelection);
            for (ISelectionChangedListener listener : this.fSelectionListeners) {
                listener.selectionChanged(event);
            }
            for (ISelectionChangedListener listener : this.fPostSelectionListeners) {
                listener.selectionChanged(event);
            }
        }
    }
}

