/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.sf.feeling.decompiler.SetupRunnable;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.extension.DecompilerAdapterManager;
import org.sf.feeling.decompiler.source.attach.IAttachSourceHandler;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.SortMemberUtil;

public class JavaDecompilerPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    public static final String EDITOR_ID = "org.sf.feeling.decompiler.ClassFileEditor";
    public static final String PLUGIN_ID = "org.sf.feeling.decompiler";
    public static final String TEMP_DIR = "org.sf.feeling.decompiler.tempd";
    public static final String REUSE_BUFFER = "org.sf.feeling.decompiler.reusebuff";
    public static final String IGNORE_EXISTING = "org.sf.feeling.decompiler.alwaysuse";
    public static final String USE_ECLIPSE_FORMATTER = "org.sf.feeling.decompiler.use_eclipse_formatter";
    public static final String USE_ECLIPSE_SORTER = "org.sf.feeling.decompiler.use_eclipse_sorter";
    public static final String DECOMPILER_TYPE = "org.sf.feeling.decompiler.type";
    public static final String PREF_DISPLAY_LINE_NUMBERS = "jd.ide.eclipse.prefs.DisplayLineNumbers";
    public static final String PREF_DISPLAY_METADATA = "jd.ide.eclipse.prefs.DisplayMetadata";
    public static final String ALIGN = "jd.ide.eclipse.prefs.RealignLineNumbers";
    public static final String DEFAULT_EDITOR = "org.sf.feeling.decompiler.default_editor";
    public static final String EXPORT_ENCODING = "org.sf.feeling.decompiler.export.encoding";
    public static final String ATTACH_SOURCE = "org.sf.feeling.decompiler.attach_source";
    public static final String bytecodeMnemonicPreferencesPrefix = "BYTECODEMNEMONIC_";
    public static final String BYTECODE_MNEMONIC = "BYTECODEMNEMONIC_bytecodeMnemonic";
    public static final String BYTECODE_MNEMONIC_BOLD = "BYTECODEMNEMONIC_bytecodeMnemonic_bold";
    public static final String BYTECODE_MNEMONIC_ITALIC = "BYTECODEMNEMONIC_bytecodeMnemonic_italic";
    public static final String BYTECODE_MNEMONIC_STRIKETHROUGH = "BYTECODEMNEMONIC_bytecodeMnemonic_strikethrough";
    public static final String BYTECODE_MNEMONIC_UNDERLINE = "BYTECODEMNEMONIC_bytecodeMnemonic_underline";
    public static final String classFileAttributePreferencesPrefix = "CLASS_FILE_ATTR_";
    public static final String CLASS_FILE_ATTR_SHOW_CONSTANT_POOL = "CLASS_FILE_ATTR_show_constantPool";
    public static final String CLASS_FILE_ATTR_SHOW_LINE_NUMBER_TABLE = "CLASS_FILE_ATTR_show_lineNumberTable";
    public static final String CLASS_FILE_ATTR_SHOW_VARIABLE_TABLE = "CLASS_FILE_ATTR_show_localVariableTable";
    public static final String CLASS_FILE_ATTR_SHOW_EXCEPTION_TABLE = "CLASS_FILE_ATTR_show_exceptionTable";
    public static final String CLASS_FILE_ATTR_SHOW_MAXS = "CLASS_FILE_ATTR_show_maxs";
    public static final String CLASS_FILE_ATTR_RENDER_TRYCATCH_BLOCKS = "CLASS_FILE_ATTR_render_tryCatchBlocks";
    public static final String CLASS_FILE_ATTR_SHOW_SOURCE_LINE_NUMBERS = "CLASS_FILE_ATTR_render_sourceLineNumbers";
    public static final String BRANCH_TARGET_ADDRESS_RENDERING = "BRANCH_TARGET_ADDRESS_RENDERING";
    public static final String BRANCH_TARGET_ADDRESS_ABSOLUTE = "BRANCH_TARGET_ADDRESS_RENDERING_ABSOLUTE";
    public static final String BRANCH_TARGET_ADDRESS_RELATIVE = "BRANCH_TARGET_ADDRESS_RENDERING_RELATIVE";
    private static JavaDecompilerPlugin plugin;
    private IPreferenceStore preferenceStore;
    private TreeMap<String, IDecompilerDescriptor> decompilerDescriptorMap = new TreeMap();
    private boolean isDebugMode = false;
    public static final int SOURCE_MODE = 0;
    public static final int BYTE_CODE_MODE = 1;
    public static final int DISASSEMBLER_MODE = 2;
    private int sourceMode = 0;
    private Set<String> librarys = new ConcurrentSkipListSet<String>();

    public Map<String, IDecompilerDescriptor> getDecompilerDescriptorMap() {
        return this.decompilerDescriptorMap;
    }

    public String[] getDecompilerDescriptorTypes() {
        return this.decompilerDescriptorMap.keySet().toArray(new String[0]);
    }

    public IDecompilerDescriptor getDecompilerDescriptor(String decompilerType) {
        return this.decompilerDescriptorMap.get(decompilerType);
    }

    public static JavaDecompilerPlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t, String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
    }

    public static void logInfo(String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, message, null));
    }

    public static void log(int severity, Throwable t, String message) {
        JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, message, t));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL base = JavaDecompilerPlugin.getDefault().getBundle().getEntry("/");
        URL url = null;
        try {
            url = new URL(base, path);
        }
        catch (MalformedURLException e) {
            Logger.debug(e);
        }
        ImageDescriptor actionIcon = null;
        if (url != null) {
            actionIcon = ImageDescriptor.createFromURL((URL)url);
        }
        return actionIcon;
    }

    public JavaDecompilerPlugin() {
        plugin = this;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(TEMP_DIR, String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + ".org.sf.feeling.decompiler" + System.currentTimeMillis());
        store.setDefault(REUSE_BUFFER, true);
        store.setDefault(IGNORE_EXISTING, false);
        store.setDefault(USE_ECLIPSE_FORMATTER, true);
        store.setDefault(USE_ECLIPSE_SORTER, false);
        store.setDefault(PREF_DISPLAY_METADATA, false);
        store.setDefault(DEFAULT_EDITOR, true);
        store.setDefault(ATTACH_SOURCE, true);
        store.setDefault(EXPORT_ENCODING, "UTF-8");
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)BYTECODE_MNEMONIC, (RGB)new RGB(0, 0, 0));
        store.setDefault(BYTECODE_MNEMONIC_BOLD, true);
        store.setDefault(BYTECODE_MNEMONIC_ITALIC, false);
        store.setDefault(BYTECODE_MNEMONIC_STRIKETHROUGH, false);
        store.setDefault(BYTECODE_MNEMONIC_UNDERLINE, false);
        store.setDefault(CLASS_FILE_ATTR_SHOW_CONSTANT_POOL, false);
        store.setDefault(CLASS_FILE_ATTR_SHOW_LINE_NUMBER_TABLE, false);
        store.setDefault(CLASS_FILE_ATTR_SHOW_VARIABLE_TABLE, false);
        store.setDefault(CLASS_FILE_ATTR_SHOW_EXCEPTION_TABLE, false);
        store.setDefault(CLASS_FILE_ATTR_SHOW_MAXS, false);
        store.setDefault(BRANCH_TARGET_ADDRESS_RENDERING, BRANCH_TARGET_ADDRESS_RELATIVE);
        store.setDefault(CLASS_FILE_ATTR_RENDER_TRYCATCH_BLOCKS, true);
        store.setDefault(CLASS_FILE_ATTR_SHOW_SOURCE_LINE_NUMBERS, true);
        store.setDefault(CLASS_FILE_ATTR_SHOW_MAXS, false);
    }

    private void setDefaultDecompiler(IPreferenceStore store) {
        Object[] decompilerAdapters = DecompilerAdapterManager.getAdapters((Object)this, IDecompilerDescriptor.class);
        if (decompilerAdapters != null) {
            int i = 0;
            while (i < decompilerAdapters.length) {
                IDecompilerDescriptor descriptor;
                Object adapter = decompilerAdapters[i];
                if (adapter instanceof IDecompilerDescriptor && (descriptor = (IDecompilerDescriptor)adapter).isEnabled()) {
                    this.decompilerDescriptorMap.put(descriptor.getDecompilerType(), descriptor);
                }
                ++i;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IGNORE_EXISTING)) {
            JavaDecompilerBufferManager.closeDecompilerBuffers(false);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.setDefaultDecompiler(this.getPreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        SortMemberUtil.deleteDecompilerProject();
        Display.getDefault().asyncExec((Runnable)new SetupRunnable());
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            IDecompilerDescriptor descriptor;
            this.preferenceStore = super.getPreferenceStore();
            String decompilerType = this.preferenceStore.getString(DECOMPILER_TYPE);
            if (!"FernFlower".equals(decompilerType) && (descriptor = this.getDecompilerDescriptor(decompilerType)) == null) {
                this.preferenceStore.setDefault(DECOMPILER_TYPE, this.getDefalutDecompilerType());
            }
        }
        return this.preferenceStore;
    }

    public void stop(BundleContext context) throws Exception {
        FileUtil.deltree(new File(this.getPreferenceStore().getString(TEMP_DIR)));
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
    }

    public Boolean isDisplayLineNumber() {
        return this.getPreferenceStore().getBoolean(PREF_DISPLAY_LINE_NUMBERS);
    }

    public Boolean isDebug() {
        return this.getPreferenceStore().getBoolean(ALIGN);
    }

    public void displayLineNumber(Boolean display) {
        this.getPreferenceStore().setValue(PREF_DISPLAY_LINE_NUMBERS, display.booleanValue());
    }

    public void setExportEncoding(String encoding) {
        this.getPreferenceStore().setValue(EXPORT_ENCODING, encoding);
    }

    public String getExportEncoding() {
        return this.getPreferenceStore().getString(EXPORT_ENCODING);
    }

    public boolean enableAttachSourceSetting() {
        Object attachSourceAdapter = DecompilerAdapterManager.getAdapter((Object)this, IAttachSourceHandler.class);
        return attachSourceAdapter instanceof IAttachSourceHandler;
    }

    public void attachSource(IPackageFragmentRoot library, boolean force) {
        Object attachSourceAdapter = DecompilerAdapterManager.getAdapter((Object)this, IAttachSourceHandler.class);
        if (attachSourceAdapter instanceof IAttachSourceHandler && (!this.librarys.contains(library.getPath().toOSString()) || force)) {
            this.librarys.add(library.getPath().toOSString());
            ((IAttachSourceHandler)attachSourceAdapter).execute(library, force);
        }
    }

    public void syncLibrarySource(IPackageFragmentRoot library) {
        try {
            Object attachSourceAdapter;
            IPreferenceStore prefs;
            if (library.getPath() != null && library.getSourceAttachmentPath() != null && !this.librarys.contains(library.getPath().toOSString()) && (prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore()).getBoolean(DEFAULT_EDITOR) && (attachSourceAdapter = DecompilerAdapterManager.getAdapter((Object)JavaDecompilerPlugin.getDefault(), IAttachSourceHandler.class)) instanceof IAttachSourceHandler) {
                this.librarys.add(library.getPath().toOSString());
                if (!((IAttachSourceHandler)attachSourceAdapter).syncAttachSource(library)) {
                    this.librarys.remove(library.getPath().toOSString());
                }
            }
        }
        catch (JavaModelException e) {
            Logger.debug(e);
        }
    }

    public boolean isAutoAttachSource() {
        if (!this.enableAttachSourceSetting()) {
            return false;
        }
        return this.getPreferenceStore().getBoolean(ATTACH_SOURCE);
    }

    public String getDefalutDecompilerType() {
        Collection<IDecompilerDescriptor> descriptors = JavaDecompilerPlugin.getDefault().getDecompilerDescriptorMap().values();
        if (descriptors != null) {
            for (IDecompilerDescriptor iDecompilerDescriptor : descriptors) {
                if (!iDecompilerDescriptor.isDefault()) continue;
                return iDecompilerDescriptor.getDecompilerType();
            }
        }
        return "FernFlower";
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
    }

    public int getSourceMode() {
        return this.sourceMode;
    }

    public void setSourceMode(int sourceMode) {
        this.sourceMode = sourceMode;
    }

    public String getDefaultExportEncoding() {
        return this.getPreferenceStore().getDefaultString(EXPORT_ENCODING);
    }
}

