/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.utils;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import org.sf.feeling.decompiler.source.attach.utils.SourceConstants;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.Logger;

public class SourceBindingUtil {
    private static final File sourceBindingJsonFile = new File(SourceConstants.SourceAttacherDir, "source.json");

    private static synchronized JsonObject loadSourceBindingJson() {
        if (sourceBindingJsonFile.exists()) {
            try {
                return Json.parse((String)FileUtil.getContent((File)sourceBindingJsonFile)).asObject();
            }
            catch (Exception e) {
                Logger.error((String)"Load source attach binding configuration failed.", (Throwable)e);
            }
        }
        return null;
    }

    private static synchronized void saveSourceBindingJson(JsonObject json) {
        try {
            StringWriter sw = new StringWriter();
            json.writeTo((Writer)sw);
            String jsonString = sw.toString();
            FileUtil.writeToFile((File)sourceBindingJsonFile, (String)jsonString);
        }
        catch (Exception e) {
            Logger.error((String)"Save source attach binding configuration failed.", (Throwable)e);
        }
    }

    public static synchronized String[] getSourceFileBySha(String sha) {
        JsonObject config = SourceBindingUtil.loadSourceBindingJson();
        if (config == null) {
            return null;
        }
        JsonArray records = config.get("records").asArray();
        int i = 0;
        while (i < records.size()) {
            JsonObject item = records.get(i).asObject();
            JsonArray shaArray = item.get("sha").asArray();
            int j = 0;
            while (j < shaArray.size()) {
                String shaString = shaArray.get(j).asString();
                if (sha != null && sha.equalsIgnoreCase(shaString)) {
                    String source = item.getString("source", null);
                    String temp = item.getString("temp", null);
                    return new String[]{source, temp};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static synchronized String[] getSourceFileByDownloadUrl(String downloadUrl) {
        JsonObject config = SourceBindingUtil.loadSourceBindingJson();
        if (config == null) {
            return null;
        }
        JsonArray records = config.get("records").asArray();
        int i = 0;
        while (i < records.size()) {
            JsonObject item = records.get(i).asObject();
            if (!item.get("downloadUrl").isNull()) {
                String downloadUrlValue = item.getString("downloadUrl", null);
                if (downloadUrl != null && downloadUrl.equals(downloadUrlValue)) {
                    String source = item.getString("source", null);
                    String temp = item.getString("temp", null);
                    return new String[]{source, temp};
                }
            }
            ++i;
        }
        return null;
    }

    public static synchronized void saveSourceBindingRecord(File sourceFile, String sha, String downloadUrl, File tempSourceFile) {
        if (sourceFile == null || tempSourceFile == null || !sourceFile.exists() || !tempSourceFile.exists()) {
            return;
        }
        JsonObject config = SourceBindingUtil.loadSourceBindingJson();
        if (config == null) {
            config = SourceBindingUtil.createSourceBindingConfig(sourceFile, sha, downloadUrl, tempSourceFile);
            SourceBindingUtil.saveSourceBindingJson(config);
            return;
        }
        JsonArray records = config.get("records").asArray();
        String sourcePath = sourceFile.getAbsolutePath();
        boolean exist = false;
        int i = 0;
        while (i < records.size()) {
            JsonObject item = records.get(i).asObject();
            String source = item.getString("source", null);
            if (sourcePath.equals(source)) {
                SourceBindingUtil.modifySourceBindingRecord(item, sha, downloadUrl, tempSourceFile);
                exist = true;
            }
            ++i;
        }
        if (!exist) {
            JsonObject record = SourceBindingUtil.createSourceBindingRecord(sourceFile, sha, downloadUrl, tempSourceFile);
            records.add((JsonValue)record);
        }
        SourceBindingUtil.saveSourceBindingJson(config);
    }

    private static synchronized void modifySourceBindingRecord(JsonObject item, String sha, String downloadUrl, File tempSourceFile) {
        JsonArray shaArray = item.get("sha").asArray();
        boolean exist = false;
        int i = 0;
        while (i < shaArray.size()) {
            String shaString = shaArray.get(i).asString();
            if (sha.equalsIgnoreCase(shaString)) {
                exist = true;
                break;
            }
            ++i;
        }
        if (!exist) {
            shaArray.add(sha);
        }
        if (downloadUrl != null) {
            item.set("downloadUrl", downloadUrl);
        }
        if (tempSourceFile != null && tempSourceFile.exists()) {
            item.set("temp", tempSourceFile.getAbsolutePath());
        }
    }

    private static synchronized JsonObject createSourceBindingConfig(File sourceFile, String sha, String downloadUrl, File tempSourceFile) {
        JsonObject config = new JsonObject();
        config.set("version", "1.0");
        JsonArray records = new JsonArray();
        config.set("records", (JsonValue)records);
        JsonObject record = SourceBindingUtil.createSourceBindingRecord(sourceFile, sha, downloadUrl, tempSourceFile);
        records.add((JsonValue)record);
        return config;
    }

    private static synchronized JsonObject createSourceBindingRecord(File sourceFile, String sha, String downloadUrl, File tempSourceFile) {
        JsonObject record = new JsonObject();
        record.set("source", sourceFile.getAbsolutePath());
        record.set("downloadUrl", downloadUrl);
        JsonArray shaArray = new JsonArray();
        shaArray.add(sha);
        record.set("sha", (JsonValue)shaArray);
        record.set("temp", tempSourceFile.getAbsolutePath());
        return record;
    }

    public static void checkSourceBindingConfig() {
        JsonObject config = SourceBindingUtil.loadSourceBindingJson();
        if (config == null) {
            return;
        }
        JsonArray records = config.get("records").asArray();
        int i = records.size() - 1;
        while (i >= 0) {
            JsonObject item = records.get(i).asObject();
            String source = item.getString("source", null);
            if (source == null || !new File(source).exists()) {
                records.remove(i);
            }
            --i;
        }
        SourceBindingUtil.saveSourceBindingJson(config);
    }
}

