/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.handler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.sf.feeling.decompiler.source.attach.attacher.SourceAttacher;
import org.sf.feeling.decompiler.source.attach.finder.EclipseSourceReferencesSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.FinderManager;
import org.sf.feeling.decompiler.source.attach.finder.JreSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCheck;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinderFacade;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.i18n.Messages;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceConstants;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class JavaSourceAttacherHandler
extends AbstractHandler {
    static final Map<String, IPackageFragmentRoot> requests = new HashMap<String, IPackageFragmentRoot>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        final ArrayList<IPackageFragmentRoot> selections = new ArrayList<IPackageFragmentRoot>();
        for (IJavaElement aSelection : structuredSelection) {
            if (aSelection instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)aSelection;
                selections.add(pkgRoot);
                continue;
            }
            if (!(aSelection instanceof IJavaProject)) continue;
            IJavaProject p = (IJavaProject)aSelection;
            try {
                IPackageFragmentRoot[] packageFragmentRoots = p.getPackageFragmentRoots();
                int length = packageFragmentRoots.length;
                int i = 0;
                while (i < length) {
                    IPackageFragmentRoot pkgRoot2 = packageFragmentRoots[i];
                    selections.add(pkgRoot2);
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.debug((Throwable)e);
            }
        }
        Iterator it = selections.iterator();
        while (it.hasNext()) {
            IPackageFragmentRoot pkgRoot3 = (IPackageFragmentRoot)it.next();
            try {
                if (pkgRoot3.getKind() == 2 && pkgRoot3.isArchive() && (pkgRoot3.getRawClasspathEntry().getEntryKind() == 1 || pkgRoot3.getRawClasspathEntry().getEntryKind() == 4 || pkgRoot3.getRawClasspathEntry().getEntryKind() == 5)) {
                    IPath source = pkgRoot3.getSourceAttachmentPath();
                    if (source == null || source.isEmpty() || !new File(source.toOSString()).exists()) continue;
                    File binFile = !pkgRoot3.isExternal() ? pkgRoot3.getResource().getLocation().toFile() : pkgRoot3.getPath().toFile();
                    if (SourceCheck.isWrongSource(new File(source.toOSString()), binFile)) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
            catch (Exception e2) {
                Logger.debug((Throwable)e2);
            }
        }
        if (!selections.isEmpty()) {
            Job job = new Job(Messages.getString("JavaSourceAttacherHandler.Job.Name")){

                protected IStatus run(IProgressMonitor monitor) {
                    return JavaSourceAttacherHandler.updateSourceAttachments(selections, monitor);
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus updateSourceAttachments(List<IPackageFragmentRoot> roots, IProgressMonitor monitor) {
        block14: {
            for (IPackageFragmentRoot pkgRoot : roots) {
                file = pkgRoot.isExternal() == false ? pkgRoot.getResource().getLocation().toFile() : pkgRoot.getPath().toFile();
                try {
                    if (roots.size() == 1 && JavaSourceAttacherHandler.requests.containsKey(file.getCanonicalPath())) {
                        return Status.CANCEL_STATUS;
                    }
                    JavaSourceAttacherHandler.requests.put(file.getCanonicalPath(), pkgRoot);
                }
                catch (Exception e) {
                    Logger.debug((Throwable)e);
                }
            }
            notProcessedLibs = new HashSet<String>();
            notProcessedLibs.addAll(JavaSourceAttacherHandler.requests.keySet());
            responses = Collections.synchronizedList(new ArrayList<E>());
            libs = new ArrayList<String>();
            libs.addAll(JavaSourceAttacherHandler.requests.keySet());
            mgr = new FinderManager();
            mgr.findSources(libs, responses);
            if (monitor != null) ** GOTO lbl37
            while (mgr.isRunning() && !notProcessedLibs.isEmpty()) {
                JavaSourceAttacherHandler.processLibSources(notProcessedLibs, responses);
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e2) {
                    Logger.debug((Throwable)e2);
                }
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                JavaSourceAttacherHandler.processLibSources(notProcessedLibs, responses);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e2) {
                    Logger.debug((Throwable)e2);
                }
lbl37:
                // 3 sources

                ** while (!monitor.isCanceled() && mgr.isRunning() && !notProcessedLibs.isEmpty())
            }
        }
        mgr.cancel();
        if (!notProcessedLibs.isEmpty()) {
            JavaSourceAttacherHandler.processLibSources(notProcessedLibs, responses);
        }
        for (IPackageFragmentRoot pkgRoot : roots) {
            file = pkgRoot.isExternal() == false ? pkgRoot.getResource().getLocation().toFile() : pkgRoot.getPath().toFile();
            try {
                JavaSourceAttacherHandler.requests.remove(file.getCanonicalPath());
            }
            catch (Exception e) {
                Logger.debug((Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private static void processLibSources(Set<String> notProcessedLibs, List<SourceFileResult> responses) {
        while (!responses.isEmpty()) {
            SourceFileResult response = responses.remove(0);
            String binFile = response.getBinFile();
            if (!notProcessedLibs.contains(binFile) || response.getSource() == null) continue;
            IPackageFragmentRoot pkgRoot = requests.get(binFile);
            try {
                String[] files;
                File sourceTempFile;
                File sourceFile;
                notProcessedLibs.remove(response.getBinFile());
                String source = response.getSource();
                String tempSource = response.getTempSource();
                String suggestedSourceFileName = response.getSuggestedSourceFileName();
                String downloadUrl = response.getFinder().getDownloadUrl();
                if (downloadUrl == null && !(response.getFinder() instanceof SourceCodeFinderFacade)) continue;
                if (!SourceConstants.SourceAttacherDir.exists()) {
                    SourceConstants.SourceAttacherDir.mkdirs();
                }
                if (!SourceConstants.SourceTempDir.exists()) {
                    SourceConstants.SourceTempDir.mkdirs();
                }
                if (tempSource == null || !new File(tempSource).exists()) {
                    File tempFile = new File(source);
                    sourceFile = new File(SourceConstants.SourceAttacherDir, suggestedSourceFileName);
                    if (!sourceFile.exists()) {
                        FileUtils.copyFile((File)tempFile, (File)sourceFile);
                    }
                    if (!(sourceTempFile = new File(SourceConstants.SourceTempDir, suggestedSourceFileName)).exists()) {
                        FileUtils.copyFile((File)tempFile, (File)sourceTempFile);
                    }
                    sourceTempFile.deleteOnExit();
                    if (!tempFile.getAbsolutePath().startsWith(SourceConstants.SourceAttachPath)) {
                        tempFile.delete();
                    }
                } else {
                    sourceFile = new File(source);
                    sourceTempFile = new File(tempSource);
                    sourceTempFile.deleteOnExit();
                }
                if (pkgRoot.getSourceAttachmentPath() != null && sourceTempFile.equals(pkgRoot.getSourceAttachmentPath().toFile())) {
                    if (!SourceAttachUtil.reattchSource(pkgRoot, sourceFile, sourceTempFile, downloadUrl)) continue;
                    files = SourceBindingUtil.getSourceFileByDownloadUrl(downloadUrl);
                    JavaSourceAttacherHandler.attachLibrarys(response, pkgRoot, new File(files[1]), sourceFile);
                    continue;
                }
                if (!JavaSourceAttacherHandler.attachSource(pkgRoot, sourceTempFile)) continue;
                SourceBindingUtil.saveSourceBindingRecord(sourceFile, HashUtils.sha1Hash((File)new File(response.getBinFile())), downloadUrl, sourceTempFile);
                files = SourceBindingUtil.getSourceFileByDownloadUrl(downloadUrl);
                JavaSourceAttacherHandler.attachLibrarys(response, pkgRoot, new File(files[1]), sourceFile);
            }
            catch (Exception e) {
                if (pkgRoot == null || pkgRoot.getResource() == null || pkgRoot.getResource().getLocation() == null) continue;
                Logger.debug((String)("Cannot attach to " + pkgRoot.getResource().getLocation().toOSString()), (Throwable)e);
            }
        }
    }

    private static void attachLibrarys(final SourceFileResult response, final IPackageFragmentRoot pkgRoot, final File sourceTempFile, final File sourceFile) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (sourceFile.getName().startsWith("jre_")) {
                        JavaSourceAttacherHandler.attachJRELibrarySources(response, pkgRoot, sourceTempFile);
                    }
                    if (sourceFile.getName().startsWith("eclipse_")) {
                        JavaSourceAttacherHandler.attachEclipseLibrarySources(response, pkgRoot, sourceTempFile);
                    }
                }
                catch (Exception e) {
                    Logger.debug((Throwable)e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static void attachJRELibrarySources(SourceFileResult response, IPackageFragmentRoot pkgRoot, File sourceTempFile) throws Exception {
        if (response.getFinder() instanceof JreSourceCodeFinder) {
            IPackageFragmentRoot[] roots = pkgRoot.getJavaProject().getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                List<String> paths;
                IPackageFragmentRoot element = roots[i];
                if (!(element.equals(pkgRoot) || !(paths = Arrays.asList(element.getPath().segments())).contains("jre") || element.getSourceAttachmentPath() != null && element.getSourceAttachmentPath().toOSString() != null && new File(element.getSourceAttachmentPath().toOSString()).exists())) {
                    JavaSourceAttacherHandler.attachSource(element, sourceTempFile);
                }
                ++i;
            }
        }
    }

    private static void attachEclipseLibrarySources(SourceFileResult response, IPackageFragmentRoot pkgRoot, File sourceTempFile) throws Exception {
        if (response.getFinder() instanceof EclipseSourceReferencesSourceCodeFinder) {
            List<String> plugins = SourceAttachUtil.getEclipsePlugins(sourceTempFile);
            IPackageFragmentRoot[] roots = pkgRoot.getJavaProject().getAllPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                String fileName;
                IPackageFragmentRoot element = roots[i];
                if (!(element.equals(pkgRoot) || !plugins.contains((fileName = element.getPath().lastSegment()).split("_")[0]) || element.getSourceAttachmentPath() != null && element.getSourceAttachmentPath().toOSString() != null && new File(element.getSourceAttachmentPath().toOSString()).exists() && SourceAttachUtil.isSourceCodeFor(element.getSourceAttachmentPath().toOSString(), SourceAttachUtil.getBinFile(element).getAbsolutePath()))) {
                    JavaSourceAttacherHandler.attachSource(element, sourceTempFile);
                }
                ++i;
            }
        }
    }

    public static boolean attachSource(IPackageFragmentRoot root, File sourcePath) throws Exception {
        SourceAttacher attacher;
        boolean attached = false;
        try {
            attacher = (SourceAttacher)Class.forName("org.sf.feeling.decompiler.source.attach.attacher.InternalBasedSourceAttacherImpl36").newInstance();
            Logger.debug((String)("Trying (using InternalBasedSourceAttacherImpl36):  " + sourcePath), null);
            attached = attacher.attachSource(root, sourcePath);
        }
        catch (Throwable e) {
            Logger.debug((String)("Exception when trying InternalBasedSourceAttacherImpl36 to attach to " + sourcePath), (Throwable)e);
        }
        if (!attached) {
            Logger.debug((String)("Previous attempt failed:  " + sourcePath), null);
            try {
                attacher = (SourceAttacher)Class.forName("org.sf.feeling.decompiler.source.attach.attacher.InternalBasedSourceAttacherImpl35").newInstance();
                Logger.debug((String)("Trying (using InternalBasedSourceAttacherImpl35):  " + sourcePath), null);
                attached = attacher.attachSource(root, sourcePath);
            }
            catch (Throwable e) {
                Logger.debug((String)("Exception when trying InternalBasedSourceAttacherImpl35 to attach to " + sourcePath), (Throwable)e);
            }
        }
        if (!attached) {
            Logger.debug((String)("Previous attempt failed:  " + sourcePath), null);
            try {
                attacher = (SourceAttacher)Class.forName("org.sf.feeling.decompiler.source.attach.attacher.MySourceAttacher").newInstance();
                Logger.debug((String)("Trying (using MySourceAttacher):  " + sourcePath), null);
                attached = attacher.attachSource(root, sourcePath);
            }
            catch (Throwable e) {
                Logger.debug((String)("Exception when trying MySourceAttacher to attach to " + sourcePath), (Throwable)e);
            }
        }
        if (!attached) {
            Logger.debug((String)("Previous attempt failed:  " + sourcePath), null);
            try {
                attacher = (SourceAttacher)Class.forName("org.sf.feeling.decompiler.source.attach.attacher.MySourceAttacher2").newInstance();
                Logger.debug((String)("Trying (using MySourceAttacher2):  " + sourcePath), null);
                attached = attacher.attachSource(root, sourcePath);
            }
            catch (Throwable e) {
                Logger.debug((String)("Exception when trying MySourceAttacher2 to attach to " + sourcePath), (Throwable)e);
            }
        }
        if (attached) {
            SourceAttachUtil.updateSourceAttachStatus(root);
            Logger.debug((String)("Attached library source " + sourcePath), null);
        } else {
            Logger.info((String)("Failed to attach library source " + sourcePath));
        }
        return attached;
    }
}

