/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.handler;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.sf.feeling.decompiler.source.attach.IAttachSourceHandler;
import org.sf.feeling.decompiler.source.attach.handler.JavaSourceAttacherHandler;
import org.sf.feeling.decompiler.source.attach.i18n.Messages;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.util.Logger;

public class AttachSourceHandler
implements IAttachSourceHandler {
    public void execute(IPackageFragmentRoot library, boolean showUI) {
        if (!showUI && SourceAttachUtil.isMavenLibrary(library) && SourceAttachUtil.enableMavenDownload()) {
            return;
        }
        final ArrayList<IPackageFragmentRoot> selections = new ArrayList<IPackageFragmentRoot>();
        selections.add(library);
        if (!selections.isEmpty()) {
            if (showUI) {
                Job job = new Job(Messages.getString("AttachSourceHandler.Job.Name")){

                    protected IStatus run(IProgressMonitor monitor) {
                        return JavaSourceAttacherHandler.updateSourceAttachments(selections, monitor);
                    }
                };
                job.setPriority(30);
                job.schedule();
            } else {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        JavaSourceAttacherHandler.updateSourceAttachments(selections, null);
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public boolean syncAttachSource(IPackageFragmentRoot root) {
        try {
            boolean download = SourceAttachUtil.needDownloadSource(Arrays.asList(root));
            if (download) {
                return SourceAttachUtil.refreshSourceAttachStatus(root);
            }
            return true;
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
            return false;
        }
    }
}

