/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.GAV;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class MavenRepoSourceCodeFinder
extends AbstractSourceCodeFinder
implements SourceCodeFinder {
    private boolean canceled = false;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public String toString() {
        return this.getClass().toString();
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        HashSet<GAV> gavs = new HashSet<GAV>();
        try {
            String sha1 = HashUtils.sha1Hash((File)new File(binFile));
            gavs.addAll(this.findArtifactsUsingMavenCentral(sha1));
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
        if (this.canceled) {
            return;
        }
        if (gavs.isEmpty()) {
            try {
                gavs.addAll(this.findGAVFromFile(binFile));
            }
            catch (Exception e) {
                Logger.debug((Throwable)e);
            }
        }
        if (this.canceled) {
            return;
        }
        HashMap<GAV, String> sourcesUrls = new HashMap<GAV, String>();
        try {
            sourcesUrls.putAll(this.findSourcesUsingMavenCentral(gavs));
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
        for (Map.Entry entry : sourcesUrls.entrySet()) {
            try {
                String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl((String)entry.getValue());
                if (sourceFiles == null || sourceFiles[0] == null || !new File(sourceFiles[0]).exists()) continue;
                File sourceFile = new File(sourceFiles[0]);
                File tempFile = new File(sourceFiles[1]);
                SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFile, sourceFile, tempFile, 100);
                results.add(result);
                return;
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
        for (Map.Entry entry : sourcesUrls.entrySet()) {
            String name = String.valueOf(((GAV)entry.getKey()).getA()) + '-' + ((GAV)entry.getKey()).getV() + "-sources.jar";
            try {
                String tmpFile = new UrlDownloader().download((String)entry.getValue());
                if (tmpFile == null || !new File(tmpFile).exists() || !SourceAttachUtil.isSourceCodeFor(tmpFile, binFile)) continue;
                this.setDownloadUrl((String)entry.getValue());
                SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, tmpFile, name, 100);
                Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
                results.add(object);
            }
            catch (Exception e) {
                Logger.debug((Throwable)e);
            }
        }
    }

    private Map<GAV, String> findSourcesUsingMavenCentral(Collection<GAV> gavs) throws Exception {
        HashMap<GAV, String> results = new HashMap<GAV, String>();
        for (GAV gav : gavs) {
            if (this.canceled) {
                return results;
            }
            String qVal = "g:\"" + gav.getG() + "\" AND a:\"" + gav.getA() + "\" AND v:\"" + gav.getV() + "\" AND l:\"sources\"";
            String url = "http://search.maven.org/solrsearch/select?q=" + URLEncoder.encode(qVal, "UTF-8") + "&rows=20&wt=json";
            String json = IOUtils.toString((InputStream)new URL(url).openStream());
            JsonObject jsonObject = Json.parse((String)json).asObject();
            JsonObject response = jsonObject.get("response").asObject();
            int i = 0;
            while (i < response.getInt("numFound", 0)) {
                JsonArray docs = response.get("docs").asArray();
                JsonObject doci = docs.get(i).asObject();
                String g = doci.getString("g", "");
                String a = doci.getString("a", "");
                String v = doci.getString("v", "");
                JsonArray array = doci.get("ec").asArray();
                if (array.toString().contains("-sources.jar")) {
                    String path = String.valueOf(g.replace('.', '/')) + '/' + a + '/' + v + '/' + a + '-' + v + "-sources.jar";
                    path = "http://search.maven.org/remotecontent?filepath=" + path;
                    results.put(gav, path);
                }
                ++i;
            }
        }
        return results;
    }

    private Collection<GAV> findArtifactsUsingMavenCentral(String sha1) throws Exception {
        HashSet<GAV> results = new HashSet<GAV>();
        String json = IOUtils.toString((InputStream)new URL("http://search.maven.org/solrsearch/select?q=" + URLEncoder.encode("1:\"" + sha1 + "\"", "UTF-8") + "&rows=20&wt=json").openStream());
        JsonObject jsonObject = Json.parse((String)json).asObject();
        JsonObject response = jsonObject.get("response").asObject();
        int i = 0;
        while (i < response.getInt("numFound", 0)) {
            JsonArray docs = response.get("docs").asArray();
            JsonObject doci = docs.get(i).asObject();
            GAV gav = new GAV();
            gav.setG(doci.getString("g", ""));
            gav.setA(doci.getString("a", ""));
            gav.setV(doci.getString("v", ""));
            results.add(gav);
            ++i;
        }
        return results;
    }
}

