/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.Logger;

public class JreSourceCodeFinder
extends AbstractSourceCodeFinder {
    private boolean canceled = false;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        try {
            String u;
            String[] metaInfo = this.findMetaInfoFromFile(binFile);
            if (metaInfo == null || !"Java Runtime Environment".equals(metaInfo[0])) {
                return;
            }
            String version = metaInfo[1];
            String lookup = null;
            String linkText = null;
            if (version.startsWith("1.7.0")) {
                lookup = "http://hg.openjdk.java.net/jdk7u/jdk7u/jdk/tags";
                u = "u" + version.substring(6);
                linkText = "jdk7" + u + "-";
            }
            if (version.startsWith("1.8.0")) {
                lookup = "http://hg.openjdk.java.net/jdk8u/jdk8u/jdk/tags";
                u = "u" + version.substring(6);
                linkText = "jdk8" + u + "-";
            }
            if (lookup != null) {
                URL baseUrl = new URL(lookup);
                String html = this.getString(baseUrl);
                HTMLEditorKit kit = new HTMLEditorKit();
                HTMLDocument doc = (HTMLDocument)((EditorKit)kit).createDefaultDocument();
                doc.putProperty("IgnoreCharsetDirective", new Boolean(true));
                StringReader reader = new StringReader(html);
                ((EditorKit)kit).read(reader, (Document)doc, 0);
                HTMLDocument.Iterator it = doc.getIterator(HTML.Tag.A);
                String srcUrl = null;
                while (it.isValid()) {
                    String text;
                    SimpleAttributeSet s = (SimpleAttributeSet)it.getAttributes();
                    String href = (String)s.getAttribute(HTML.Attribute.HREF);
                    if (href != null && href.contains("/rev/") && (text = this.getText(doc, it).trim()).startsWith(linkText)) {
                        srcUrl = new URL(baseUrl, String.valueOf(href.replace("/rev/", "/archive/")) + ".zip").toString();
                        break;
                    }
                    it.next();
                }
                if (srcUrl != null && !this.canceled) {
                    String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl(srcUrl);
                    if (sourceFiles != null && sourceFiles[0] != null && new File(sourceFiles[0]).exists()) {
                        File sourceFile = new File(sourceFiles[0]);
                        File tempFile = new File(sourceFiles[1]);
                        SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFile, sourceFile, tempFile, 100);
                        results.add(result);
                        return;
                    }
                    String tmpFile = new UrlDownloader().download(srcUrl);
                    FileUtil.filterZipFile((String)tmpFile, (FileUtil.Filter)new FileUtil.Filter(){

                        public boolean accept(String fileName) {
                            return fileName.endsWith(".java") && fileName.indexOf("src/share/classes") != -1;
                        }
                    });
                    if (tmpFile != null && new File(tmpFile).exists() && SourceAttachUtil.isSourceCodeFor(tmpFile, binFile)) {
                        this.setDownloadUrl(srcUrl);
                        String name = srcUrl.substring(srcUrl.lastIndexOf(47) + 1);
                        name = "jre_" + name;
                        SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, tmpFile, name, 50);
                        Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
                        results.add(object);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
    }

    protected String[] findMetaInfoFromFile(String binFile) throws Exception {
        int read;
        String zipEntryName;
        ZipEntry entry;
        String[] result = null;
        ZipInputStream in = new ZipInputStream(new FileInputStream(binFile));
        byte[] data = new byte[2048];
        while ((entry = in.getNextEntry()) != null && !(zipEntryName = entry.getName()).equals("META-INF/MANIFEST.MF")) {
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((read = in.read(data)) >= 0) {
            os.write(data, 0, read);
        }
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(os.toByteArray()));
        String title = props.getProperty("Implementation-Title");
        String version = props.getProperty("Implementation-Version");
        result = new String[]{title, version};
        in.close();
        return result;
    }

    public static void main(String[] args) {
        JreSourceCodeFinder finder = new JreSourceCodeFinder();
        ArrayList<SourceFileResult> results = new ArrayList<SourceFileResult>();
        finder.find("C:\\develop\\jdk1.6\\jre\\lib\\deploy.jar", results);
        System.out.println(((SourceFileResult)results.get(0)).getSource());
    }
}

