/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class GrepCodeSourceCodeFinder
extends AbstractSourceCodeFinder {
    protected boolean canceled = false;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        try {
            String md5 = HashUtils.md5Hash((File)new File(binFile));
            String srcUrl = "http://grepcode.com/snapshot/" + md5 + "?rel=file&kind=source&n=0";
            String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl(srcUrl);
            if (sourceFiles != null && sourceFiles[0] != null && new File(sourceFiles[0]).exists()) {
                File sourceFile = new File(sourceFiles[0]);
                File tempFile = new File(sourceFiles[1]);
                SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFile, sourceFile, tempFile, 100);
                results.add(result);
                return;
            }
            String tmpFile = new UrlDownloader().download(srcUrl);
            if (tmpFile != null && new File(tmpFile).exists() && SourceAttachUtil.isSourceCodeFor(tmpFile, binFile)) {
                this.setDownloadUrl(srcUrl);
                String name = String.valueOf(FilenameUtils.getBaseName((String)binFile)) + "-sources.jar";
                SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, tmpFile, name, 50);
                Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
                results.add(object);
            }
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
    }

    public static void main(String[] args) {
        GrepCodeSourceCodeFinder finder = new GrepCodeSourceCodeFinder();
        ArrayList<SourceFileResult> results = new ArrayList<SourceFileResult>();
        finder.find("C:\\Users\\Feeling\\.m2\\repository\\ant\\ant\\1.6.5\\ant-1.6.5.jar", results);
        System.out.println(((SourceFileResult)results.get(0)).getSource());
    }
}

