/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.util.LinkedList;
import java.util.List;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinderFacade;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.util.Logger;

public class FinderManager {
    private Worker[] workers = new Worker[10];

    public boolean isRunning() {
        boolean result = false;
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] != null && this.workers[i].isAlive()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public void cancel() {
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i] != null && this.workers[i].isAlive()) {
                this.workers[i].cancel();
            }
            ++i;
        }
    }

    public void findSources(List<String> libs, List<SourceFileResult> results) {
        WorkQueue queue = new WorkQueue();
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i] = new Worker(queue, results);
            this.workers[i].start();
            ++i;
        }
        for (String lib : libs) {
            queue.addWork(lib);
        }
        i = 0;
        while (i < this.workers.length) {
            queue.addWork(Worker.NO_MORE_WORK);
            ++i;
        }
    }

    private static class WorkQueue {
        LinkedList<String> queue = new LinkedList();

        private WorkQueue() {
        }

        public synchronized void addWork(String o) {
            this.queue.addLast(o);
            this.notify();
        }

        public synchronized String getWork() throws InterruptedException {
            while (this.queue.isEmpty()) {
                this.wait();
            }
            return this.queue.removeFirst();
        }
    }

    private static class Worker
    extends Thread {
        public static final String NO_MORE_WORK = new String("NO_MORE_WORK");
        private WorkQueue q;
        private List<SourceFileResult> results;
        private boolean canceled;
        private SourceCodeFinder finder;

        public Worker(WorkQueue q, List<SourceFileResult> results) {
            this.q = q;
            this.results = results;
            this.finder = new SourceCodeFinderFacade();
        }

        public void cancel() {
            this.canceled = true;
            this.finder.cancel();
        }

        @Override
        public void run() {
            try {
                while (!this.canceled) {
                    String binFile = this.q.getWork();
                    if (binFile != NO_MORE_WORK) {
                        this.finder.find(binFile, this.results);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Logger.debug((Throwable)e);
            }
        }
    }
}

