/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.Logger;

public class EclipseSourceReferencesSourceCodeFinder
extends AbstractSourceCodeFinder {
    private String findMetaInfoFromFile(String binFile) throws Exception {
        String ESR;
        int read;
        String zipEntryName;
        ZipEntry entry;
        String result = null;
        ZipInputStream in = new ZipInputStream(new FileInputStream(binFile));
        byte[] data = new byte[2048];
        while ((entry = in.getNextEntry()) != null && !(zipEntryName = entry.getName()).equals("META-INF/MANIFEST.MF")) {
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((read = in.read(data)) >= 0) {
            os.write(data, 0, read);
        }
        Manifest manifest = new Manifest(new ByteArrayInputStream(os.toByteArray()));
        Attributes attr = manifest.getMainAttributes();
        result = ESR = attr.getValue("Eclipse-SourceReferences");
        in.close();
        return result;
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        try {
            String sourceReferences = this.findMetaInfoFromFile(binFile);
            if (sourceReferences == null) {
                return;
            }
            String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl(sourceReferences);
            if (sourceFiles != null && sourceFiles[0] != null && new File(sourceFiles[0]).exists()) {
                File sourceFile = new File(sourceFiles[0]);
                File tempFile = new File(sourceFiles[1]);
                SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFile, sourceFile, tempFile, 100);
                results.add(result);
                return;
            }
            String tmpFile = new UrlDownloader().download(sourceReferences);
            if (tmpFile != null && new File(tmpFile).exists() && SourceAttachUtil.isSourceCodeFor(tmpFile, new File(binFile).getAbsolutePath())) {
                this.setDownloadUrl(sourceReferences);
                String name = new File(tmpFile).getName().replace("source", "eclipse");
                SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, tmpFile, name, 50);
                Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
                results.add(object);
            }
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
    }

    @Override
    public void cancel() {
    }

    public static void main(String[] args) {
        EclipseSourceReferencesSourceCodeFinder finder = new EclipseSourceReferencesSourceCodeFinder();
        ArrayList<SourceFileResult> results = new ArrayList<SourceFileResult>();
        finder.find("C:\\develop\\eclipse-jee-luna-SR2-win32\\eclipse\\plugins\\org.apache.commons.codec_1.6.0.v201305230611.jar", results);
        System.out.println(((SourceFileResult)results.get(0)).getSource());
    }
}

