/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sf.feeling.decompiler.source.attach.finder.AbstractSourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.GAV;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.source.attach.finder.SourceFileResult;
import org.sf.feeling.decompiler.source.attach.utils.SourceAttachUtil;
import org.sf.feeling.decompiler.source.attach.utils.SourceBindingUtil;
import org.sf.feeling.decompiler.source.attach.utils.UrlDownloader;
import org.sf.feeling.decompiler.util.HashUtils;
import org.sf.feeling.decompiler.util.Logger;

public class ArtifactorySourceCodeFinder
extends AbstractSourceCodeFinder
implements SourceCodeFinder {
    protected boolean canceled = false;
    private String serviceUrl;

    public ArtifactorySourceCodeFinder(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String toString() {
        return this.getClass() + "; serviceUrl=" + this.serviceUrl;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void find(String binFile, List<SourceFileResult> results) {
        HashSet<GAV> gavs = new HashSet<GAV>();
        try {
            String sha1 = HashUtils.sha1Hash((File)new File(binFile));
            gavs.addAll(this.findArtifactsUsingArtifactory(null, null, null, null, sha1, false));
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
        if (this.canceled) {
            return;
        }
        if (gavs.isEmpty()) {
            try {
                gavs.addAll(this.findGAVFromFile(binFile));
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
        if (this.canceled) {
            return;
        }
        HashMap<GAV, String> sourcesUrls = new HashMap<GAV, String>();
        try {
            sourcesUrls.putAll(this.findSourcesUsingArtifactory(gavs));
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
        for (Map.Entry entry : sourcesUrls.entrySet()) {
            try {
                String[] sourceFiles = SourceBindingUtil.getSourceFileByDownloadUrl((String)entry.getValue());
                if (sourceFiles == null || sourceFiles[0] == null || !new File(sourceFiles[0]).exists()) continue;
                File sourceFile = new File(sourceFiles[0]);
                File tempFile = new File(sourceFiles[1]);
                SourceFileResult result = new SourceFileResult((SourceCodeFinder)this, binFile, sourceFile, tempFile, 100);
                results.add(result);
                return;
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
        for (Map.Entry entry : sourcesUrls.entrySet()) {
            String name = String.valueOf(((GAV)entry.getKey()).getA()) + '-' + ((GAV)entry.getKey()).getV() + "-sources.jar";
            try {
                String result = new UrlDownloader().download((String)entry.getValue());
                if (result == null || !new File(result).exists() || !SourceAttachUtil.isSourceCodeFor(result, binFile)) continue;
                this.setDownloadUrl((String)entry.getValue());
                SourceFileResult object = new SourceFileResult((SourceCodeFinder)this, binFile, result, name, 100);
                Logger.debug((String)(String.valueOf(this.toString()) + " FOUND: " + object), null);
                results.add(object);
            }
            catch (Throwable e) {
                Logger.debug((Throwable)e);
            }
        }
    }

    protected Map<GAV, String> findSourcesUsingArtifactory(Collection<GAV> gavs) throws Exception {
        HashMap<GAV, String> results = new HashMap<GAV, String>();
        for (GAV gav : gavs) {
            if (this.canceled) {
                return results;
            }
            Set<GAV> gavs2 = this.findArtifactsUsingArtifactory(gav.getG(), gav.getA(), gav.getV(), "sources", null, true);
            for (GAV gav2 : gavs2) {
                if (!gav2.getArtifactLink().endsWith("-sources.jar") && !gav2.getArtifactLink().endsWith("-sources.zip")) continue;
                String uri = gav2.getArtifactLink();
                File file = new File(new UrlDownloader().download(uri));
                String json = FileUtils.readFileToString((File)file);
                JsonObject resp = Json.parse((String)json).asObject();
                results.put(gav, resp.getString("downloadUri", ""));
            }
        }
        return results;
    }

    protected Set<GAV> findArtifactsUsingArtifactory(String g, String a, String v, String c, String sha1, boolean getLink) throws Exception {
        HashSet<GAV> results = new HashSet<GAV>();
        String apiUrl = this.getArtifactApiUrl();
        String url = sha1 != null ? String.valueOf(apiUrl) + "search/checksum?sha1=" + sha1 : String.valueOf(apiUrl) + "search/gavc?g=" + g + "&a=" + a + "&v=" + v + (c != null ? "&c=" + c : "");
        URLConnection connection = new URL(url).openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.connect();
        try {
            InputStream is = connection.getInputStream();
            String json = IOUtils.toString((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            JsonObject resp = Json.parse((String)json).asObject();
            for (JsonValue elem : resp.get("results").asArray()) {
                JsonObject result = elem.asObject();
                String uri = result.getString("uri", "");
                String regex = "/api/storage/[^/]+/(.+)$";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(uri);
                if (!matcher.find()) continue;
                String[] gavInArray = matcher.group(1).split("/");
                GAV gav = new GAV();
                String group = gavInArray[0];
                int i = 1;
                while (i < gavInArray.length - 3) {
                    group = String.valueOf(group) + "." + gavInArray[i];
                    ++i;
                }
                gav.setG(group);
                gav.setA(gavInArray[gavInArray.length - 3]);
                gav.setV(gavInArray[gavInArray.length - 2]);
                if (getLink) {
                    gav.setArtifactLink(uri);
                }
                results.add(gav);
            }
        }
        catch (Throwable e) {
            Logger.debug((Throwable)e);
        }
        return results;
    }

    private String getArtifactApiUrl() {
        String result = null;
        if (this.serviceUrl.endsWith("/webapp/home.html")) {
            result = this.serviceUrl.replace("/webapp/home.html", "/api/");
        }
        return result;
    }
}

