/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.finder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.apache.commons.io.IOUtils;
import org.sf.feeling.decompiler.source.attach.finder.GAV;
import org.sf.feeling.decompiler.source.attach.finder.SourceCodeFinder;
import org.sf.feeling.decompiler.util.Logger;

public abstract class AbstractSourceCodeFinder
implements SourceCodeFinder {
    protected String downloadUrl;

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    protected String getString(URL url) throws Exception {
        String result = null;
        try {
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36");
            con.setRequestProperty("Accept-Encoding", "gzip,deflate");
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            InputStream is = null;
            byte[] bytes = null;
            InputStream conIs = null;
            try {
                try {
                    conIs = con.getInputStream();
                    bytes = IOUtils.toByteArray((InputStream)conIs);
                    is = new GZIPInputStream(new ByteArrayInputStream(bytes));
                    result = IOUtils.toString((InputStream)is);
                }
                catch (Exception e) {
                    if (bytes != null) {
                        is = new ByteArrayInputStream(bytes);
                        result = IOUtils.toString((InputStream)is);
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)conIs);
                IOUtils.closeQuietly(is);
            }
        }
        catch (Exception e) {
            Logger.debug((Throwable)e);
        }
        return result == null ? "" : result;
    }

    protected Collection<GAV> findGAVFromFile(String binFile) throws Exception {
        ZipEntry entry;
        HashSet<GAV> gavs = new HashSet<GAV>();
        ZipInputStream in = new ZipInputStream(new FileInputStream(binFile));
        byte[] data = new byte[2048];
        while ((entry = in.getNextEntry()) != null) {
            int read;
            String zipEntryName = entry.getName();
            if (!zipEntryName.startsWith("META-INF/maven/") || !zipEntryName.endsWith("/pom.properties")) continue;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((read = in.read(data)) >= 0) {
                os.write(data, 0, read);
            }
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(os.toByteArray()));
            String version = props.getProperty("version");
            String groupId = props.getProperty("groupId");
            String artifactId = props.getProperty("artifactId");
            if (version == null || groupId == null || artifactId == null) continue;
            GAV gav = new GAV();
            gav.setG(groupId);
            gav.setA(artifactId);
            gav.setV(version);
            gavs.add(gav);
        }
        in.close();
        if (gavs.size() > 1) {
            gavs.clear();
        }
        return gavs;
    }

    protected String getText(HTMLDocument doc, HTMLDocument.Iterator iterator) throws BadLocationException {
        int startOffset = iterator.getStartOffset();
        int endOffset = iterator.getEndOffset();
        int length = endOffset - startOffset;
        String text = doc.getText(startOffset, length);
        return text;
    }
}

