/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.source.attach.attacher;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.sf.feeling.decompiler.source.attach.attacher.SourceAttacher;

public class MySourceAttacher
implements SourceAttacher {
    @Override
    public boolean attachSource(IPackageFragmentRoot root, File sourcePath) throws Exception {
        IJavaProject javaProject = root.getJavaProject();
        IClasspathEntry[] entries = (IClasspathEntry[])javaProject.getRawClasspath().clone();
        boolean attached = false;
        int i = 0;
        while (i < entries.length) {
            String rootPath;
            IClasspathEntry entry = entries[i];
            String entryPath = entry.getEntryKind() == 4 ? JavaCore.getResolvedVariablePath((IPath)entry.getPath()).toOSString() : entry.getPath().toOSString();
            if (entryPath.equals(rootPath = root.getPath().toOSString())) {
                entries[i] = MySourceAttacher.addSourceAttachment(root, entries[i], sourcePath.getAbsolutePath(), null);
                attached = true;
                break;
            }
            ++i;
        }
        if (!attached) {
            root.attachSource((IPath)new Path(sourcePath.getAbsolutePath()), null, null);
        }
        javaProject.setRawClasspath(entries, null);
        return true;
    }

    private static IClasspathEntry addSourceAttachment(IPackageFragmentRoot root, IClasspathEntry entry, String sourcePath, String sourceRoot) throws Exception {
        int entryKind = entry.getEntryKind();
        IClasspathEntry result = null;
        switch (entryKind) {
            case 1: {
                result = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)(sourcePath == null ? null : new Path(sourcePath)), (IPath)(sourceRoot == null ? null : new Path(sourceRoot)), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])entry.getExtraAttributes(), (boolean)entry.isExported());
                break;
            }
            case 4: {
                File sourceAttacherDir = new File(sourcePath).getParentFile();
                JavaCore.setClasspathVariable((String)"SOURCE_ATTACHER", (IPath)new Path(sourceAttacherDir.getAbsolutePath()), null);
                Path varAttPath = new Path("SOURCE_ATTACHER/" + new File(sourcePath).getName());
                result = JavaCore.newVariableEntry((IPath)entry.getPath(), (IPath)varAttPath, (IPath)(sourceRoot == null ? null : new Path(sourceRoot)), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])entry.getExtraAttributes(), (boolean)entry.isExported());
                break;
            }
            default: {
                result = entry;
            }
        }
        return result;
    }
}

