/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jad.decompiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.Platform;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;

public final class JadLoader {
    public static String loadJad() {
        String jadFileName = null;
        String jadFilePath = null;
        if ("win32".equalsIgnoreCase(Platform.getOS())) {
            jadFileName = "jad" + System.currentTimeMillis() + ".exe";
            jadFilePath = "/native/jad/win32/jad.exe";
        } else if ("linux".equalsIgnoreCase(Platform.getOS())) {
            jadFileName = "jad" + System.currentTimeMillis();
            jadFilePath = "/native/jad/linux/jad";
        } else if ("macosx".equalsIgnoreCase(Platform.getOS())) {
            jadFileName = "jad" + System.currentTimeMillis();
            jadFilePath = "/native/jad/macosx/jad";
        } else {
            throw new Error("Can't obtain jad executable file.");
        }
        InputStream is = JadLoader.class.getResourceAsStream(jadFilePath);
        if (is == null) {
            throw new Error("Can't obtain jad executable file.");
        }
        FileOutputStream fos = null;
        try {
            int count;
            File tempDir = new File(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd"));
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            File jad = new File(tempDir, jadFileName);
            jad.createNewFile();
            jad.deleteOnExit();
            fos = new FileOutputStream(jad);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, buf.length)) > 0) {
                fos.write(buf, 0, count);
            }
            fos.close();
            fos = null;
            try {
                if ("linux".equalsIgnoreCase(Platform.getOS())) {
                    Runtime.getRuntime().exec("chmod a+x " + jad.getAbsolutePath()).waitFor();
                } else if ("macosx".equalsIgnoreCase(Platform.getOS())) {
                    Runtime.getRuntime().exec("chmod a+x " + jad.getAbsolutePath()).waitFor();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String string = jad.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new Error("Failed to create temporary file for jad.exe: " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

