/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jad;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.jad.decompiler.JadLoader;

public class JadDecompilerPlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    public static final String PLUGIN_ID = "org.sf.feeling.decompiler.jad";
    public static final String CMD = "org.sf.feeling.decompiler.jad.cmd";
    public static final String decompilerType = "Jad";
    private static JadDecompilerPlugin plugin;
    private IPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            IPreferenceStore decompilerStore = this.preferenceStore = JavaDecompilerPlugin.getDefault().getPreferenceStore();
            String jad = JadLoader.loadJad();
            if (jad != null) {
                decompilerStore.setDefault(CMD, jad);
            }
            decompilerStore.setDefault("-t", 4);
            decompilerStore.setDefault("-radix", 10);
            decompilerStore.setDefault("-lradix", 10);
            decompilerStore.setDefault("-l", 0);
            decompilerStore.setDefault("-pi", 0);
            decompilerStore.setDefault("-pv", 0);
            decompilerStore.setDefault("-ff", true);
            decompilerStore.setDefault("-noctor", true);
            decompilerStore.setDefault("-8", false);
        }
        return this.preferenceStore;
    }

    public static JadDecompilerPlugin getDefault() {
        return plugin;
    }

    public JadDecompilerPlugin() {
        plugin = this;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL base = JadDecompilerPlugin.getDefault().getBundle().getEntry("/");
        URL url = null;
        try {
            url = new URL(base, path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageDescriptor actionIcon = null;
        if (url != null) {
            actionIcon = ImageDescriptor.createFromURL((URL)url);
        }
        return actionIcon;
    }
}

