/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.views.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IWorkingSet;

public class CheckstyleMarkerFilter
implements Cloneable {
    private static final String TAG_DIALOG_SECTION = "filter";
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_SELECT_BY_SEVERITY = "selectBySeverity";
    private static final String TAG_SEVERITY = "severity";
    private static final String TAG_SELECT_BY_REGEX = "selectByRegex";
    private static final String TAG_REGULAR_EXPRESSIONS = "regularExpressions";
    public static final int ON_ANY_RESOURCE = 0;
    public static final int ON_SELECTED_RESOURCE_ONLY = 1;
    public static final int ON_SELECTED_RESOURCE_AND_CHILDREN = 2;
    public static final int ON_ANY_RESOURCE_OF_SAME_PROJECT = 3;
    public static final int ON_WORKING_SET = 4;
    private static final int DEFAULT_SEVERITY = 0;
    public static final int SEVERITY_ERROR = 4;
    public static final int SEVERITY_WARNING = 2;
    public static final int SEVERITY_INFO = 1;
    private static final int DEFAULT_ON_RESOURCE = 0;
    private static final boolean DEFAULT_SELECT_BY_SEVERITY = false;
    private static final boolean DEFAULT_ACTIVATION_STATUS = true;
    private boolean mEnabled;
    private int mOnResource;
    private IWorkingSet mWorkingSet;
    private boolean mSelectBySeverity;
    private int mSeverity;
    private IResource[] mFocusResources;
    private boolean mFilterByRegex;
    private List<String> mFilterRegex;

    public IMarker[] findMarkers(IProgressMonitor mon) throws CoreException {
        List<IMarker> unfiltered = Collections.emptyList();
        if (!this.isEnabled()) {
            unfiltered = this.findCheckstyleMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, mon);
        } else {
            switch (this.getOnResource()) {
                case 0: {
                    unfiltered = this.findCheckstyleMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, mon);
                    break;
                }
                case 1: {
                    unfiltered = this.findCheckstyleMarkers(this.mFocusResources, 0, mon);
                    break;
                }
                case 2: {
                    unfiltered = this.findCheckstyleMarkers(this.mFocusResources, 2, mon);
                    break;
                }
                case 3: {
                    unfiltered = this.findCheckstyleMarkers((IResource[])CheckstyleMarkerFilter.getProjects(this.mFocusResources), 2, mon);
                    break;
                }
                case 4: {
                    unfiltered = this.findCheckstyleMarkers(CheckstyleMarkerFilter.getResourcesInWorkingSet(this.mWorkingSet), 2, mon);
                    break;
                }
            }
        }
        if (unfiltered == null) {
            unfiltered = Collections.emptyList();
        }
        return unfiltered.toArray(new IMarker[unfiltered.size()]);
    }

    public int getOnResource() {
        return this.mOnResource;
    }

    public void setOnResource(int onResource) {
        if (onResource >= 0 && onResource <= 4) {
            this.mOnResource = onResource;
        }
    }

    public IResource[] getFocusResource() {
        return this.mFocusResources;
    }

    public void setFocusResource(IResource[] resources) {
        this.mFocusResources = resources;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public IWorkingSet getWorkingSet() {
        return this.mWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.mWorkingSet = workingSet;
    }

    public boolean getSelectBySeverity() {
        return this.mSelectBySeverity;
    }

    public void setSelectBySeverity(boolean selectBySeverity) {
        this.mSelectBySeverity = selectBySeverity;
    }

    public int getSeverity() {
        return this.mSeverity;
    }

    public void setSeverity(int severity) {
        this.mSeverity = severity;
    }

    public boolean isFilterByRegex() {
        return this.mFilterByRegex;
    }

    public void setFilterByRegex(boolean filterByRegex) {
        this.mFilterByRegex = filterByRegex;
    }

    public List<String> getFilterRegex() {
        return this.mFilterRegex;
    }

    public void setFilterRegex(List<String> filterRegex) {
        this.mFilterRegex = filterRegex;
    }

    public void restoreState(IDialogSettings dialogSettings) {
        this.resetState();
        IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null) {
            String[] regex;
            String setting = settings.get(TAG_ENABLED);
            if (setting != null) {
                this.mEnabled = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_ON_RESOURCE)) != null) {
                try {
                    this.mOnResource = Integer.parseInt(setting);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((setting = settings.get(TAG_WORKING_SET)) != null) {
                this.setWorkingSet(CheckstyleUIPlugin.getDefault().getWorkbench().getWorkingSetManager().getWorkingSet(setting));
            }
            if ((setting = settings.get(TAG_SELECT_BY_SEVERITY)) != null) {
                this.mSelectBySeverity = Boolean.valueOf(setting);
            }
            if ((setting = settings.get(TAG_SEVERITY)) != null) {
                try {
                    this.mSeverity = Integer.parseInt(setting);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((setting = settings.get(TAG_SELECT_BY_REGEX)) != null) {
                this.mFilterByRegex = Boolean.valueOf(setting);
            }
            if ((regex = settings.getArray(TAG_REGULAR_EXPRESSIONS)) != null) {
                this.mFilterRegex = Arrays.asList(regex);
            }
        }
    }

    public void saveState(IDialogSettings dialogSettings) {
        if (dialogSettings != null) {
            IDialogSettings settings = dialogSettings.getSection(TAG_DIALOG_SECTION);
            if (settings == null) {
                settings = dialogSettings.addNewSection(TAG_DIALOG_SECTION);
            }
            settings.put(TAG_ENABLED, this.mEnabled);
            settings.put(TAG_ON_RESOURCE, this.mOnResource);
            if (this.mWorkingSet != null) {
                settings.put(TAG_WORKING_SET, this.mWorkingSet.getName());
            }
            settings.put(TAG_SELECT_BY_SEVERITY, this.mSelectBySeverity);
            settings.put(TAG_SEVERITY, this.mSeverity);
            settings.put(TAG_SELECT_BY_REGEX, this.mFilterByRegex);
            if (this.mFilterRegex != null) {
                settings.put(TAG_REGULAR_EXPRESSIONS, this.mFilterRegex.toArray(new String[this.mFilterRegex.size()]));
            }
        }
    }

    public void resetState() {
        this.mEnabled = true;
        this.mOnResource = 0;
        this.setWorkingSet(null);
        this.mSelectBySeverity = false;
        this.mSeverity = 0;
        this.mFilterByRegex = false;
        this.mFilterRegex = new ArrayList<String>();
    }

    private List<IMarker> findCheckstyleMarkers(IResource[] resources, int depth, IProgressMonitor mon) throws CoreException {
        IMarker marker;
        int i;
        int size;
        if (resources == null) {
            return Collections.emptyList();
        }
        ArrayList<IMarker> resultList = new ArrayList<IMarker>(resources.length * 2);
        int i2 = 0;
        int size2 = resources.length;
        while (i2 < size2) {
            if (resources[i2].isAccessible()) {
                List<IMarker> markers = Arrays.asList(resources[i2].findMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, depth));
                resultList.addAll(markers);
            }
            ++i2;
        }
        if (!this.mEnabled) {
            return resultList;
        }
        if (this.mSelectBySeverity) {
            size = resultList.size();
            i = size - 1;
            while (i >= 0) {
                marker = (IMarker)resultList.get(i);
                if (!this.selectBySeverity(marker)) {
                    resultList.remove(i);
                }
                --i;
            }
        }
        if (this.mFilterByRegex) {
            size = resultList.size();
            i = size - 1;
            while (i >= 0) {
                marker = (IMarker)resultList.get(i);
                if (!this.selectByRegex(marker)) {
                    resultList.remove(i);
                }
                --i;
            }
        }
        return resultList;
    }

    private boolean selectBySeverity(IMarker item) {
        if (this.mSelectBySeverity) {
            int markerSeverity = item.getAttribute(TAG_SEVERITY, -1);
            if (markerSeverity == 2) {
                return (this.mSeverity & 4) > 0;
            }
            if (markerSeverity == 1) {
                return (this.mSeverity & 2) > 0;
            }
            if (markerSeverity == 0) {
                return (this.mSeverity & 1) > 0;
            }
        }
        return true;
    }

    private boolean selectByRegex(IMarker item) {
        if (this.mFilterByRegex) {
            int size = this.mFilterRegex != null ? this.mFilterRegex.size() : 0;
            int i = 0;
            while (i < size) {
                String regex = this.mFilterRegex.get(i);
                String message = item.getAttribute("message", null);
                if (message != null && message.matches(regex)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static IProject[] getProjects(IResource[] resources) {
        Collection<IProject> projects = CheckstyleMarkerFilter.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    public static Collection<IProject> getProjectsAsCollection(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int idx = 0;
        int size = resources != null ? resources.length : 0;
        while (idx < size) {
            projects.add(resources[idx].getProject());
            ++idx;
        }
        return projects;
    }

    private static IResource[] getResourcesInWorkingSet(IWorkingSet workingSet) {
        if (workingSet == null) {
            return new IResource[0];
        }
        IAdaptable[] elements = workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        int idx = 0;
        while (idx < elements.length) {
            IResource next = (IResource)elements[idx].getAdapter(IResource.class);
            if (next != null) {
                result.add(next);
            }
            ++idx;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

