/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.views;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.eclipsecs.ui.stats.Messages;
import net.sf.eclipsecs.ui.stats.data.MarkerStat;
import net.sf.eclipsecs.ui.stats.data.Stats;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;

public class GraphPieDataset
extends AbstractDataset
implements PieDataset {
    private static final long serialVersionUID = 9010212577897074893L;
    private static final int POURCENTAGE_MIN = 1;
    private static final int CENT = 100;
    private boolean mShowAllCategories;
    private DefaultKeyedValues mData = new DefaultKeyedValues();

    public void setStats(Stats stats) {
        Collection<Object> markerStatCollection = stats != null ? stats.getMarkerStats() : Collections.emptyList();
        this.mData = new DefaultKeyedValues();
        int leftCount = 0;
        float mCount = new Float(stats.getMarkerCount()).floatValue();
        for (MarkerStat markerStat : markerStatCollection) {
            float percentage = (float)(100 * markerStat.getCount()) / mCount;
            if (this.mShowAllCategories) {
                this.setValue((Comparable<?>)((Object)markerStat.getIdentifiant()), percentage);
                continue;
            }
            if (percentage > 1.0f) {
                this.setValue((Comparable<?>)((Object)markerStat.getIdentifiant()), percentage);
                continue;
            }
            leftCount += markerStat.getCount();
        }
        if (!this.mShowAllCategories && leftCount != 0) {
            this.setValue((Comparable<?>)((Object)Messages.GraphPieDataset_otherCategories), (float)(100 * leftCount) / mCount);
        }
        this.fireDatasetChanged();
    }

    public void removeValues() {
        this.mData = new DefaultKeyedValues();
        this.fireDatasetChanged();
    }

    public void setShowAllCategories(boolean showAllCategories) {
        this.mShowAllCategories = showAllCategories;
    }

    public int getItemCount() {
        return this.mData.getItemCount();
    }

    public List<?> getKeys() {
        return Collections.unmodifiableList(this.mData.getKeys());
    }

    public Comparable<?> getKey(int item) {
        Comparable result = null;
        if (this.getItemCount() > item) {
            result = this.mData.getKey(item);
        }
        return result;
    }

    public int getIndex(Comparable key) {
        return this.mData.getIndex(key);
    }

    public Number getValue(int item) {
        Number result = null;
        if (this.getItemCount() > item) {
            result = this.mData.getValue(item);
        }
        return result;
    }

    public Number getValue(Comparable key) {
        if (key == null) {
            throw new IllegalArgumentException("PieDataset: null key not allowed.");
        }
        return this.mData.getValue(key);
    }

    public void setValue(Comparable<?> key, Number value) {
        this.mData.setValue(key, value);
        this.fireDatasetChanged();
    }

    public void setValue(Comparable<?> key, double value) {
        this.setValue(key, new Double(value));
    }
}

