/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.stats.Messages;
import net.sf.eclipsecs.ui.stats.data.CreateStatsJob;
import net.sf.eclipsecs.ui.stats.data.Stats;
import net.sf.eclipsecs.ui.stats.views.internal.CheckstyleMarkerFilter;
import net.sf.eclipsecs.ui.stats.views.internal.CheckstyleMarkerFilterDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractStatsView
extends ViewPart {
    private Composite mMainComposite;
    private CheckstyleMarkerFilter mFilter;
    private IResource[] mFocusedResources;
    private Stats mStats;
    private ISelectionListener mFocusListener;
    private IResourceChangeListener mResourceListener;

    public void createPartControl(Composite parent) {
        this.mMainComposite = parent;
        this.mFocusListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                AbstractStatsView.this.focusSelectionChanged(part, selection);
            }
        };
        this.getSite().getPage().addSelectionListener(this.mFocusListener);
        this.focusSelectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
        this.mResourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IMarkerDelta[] markerDeltas = event.findMarkerDeltas("net.sf.eclipsecs.core.CheckstyleMarker", true);
                if (markerDeltas.length > 0) {
                    AbstractStatsView.this.refresh();
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.mResourceListener);
        this.makeActions();
        this.initActionBars(this.getViewSite().getActionBars());
    }

    public void setFocus() {
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.mFocusListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.mResourceListener);
        super.dispose();
    }

    public final void openFiltersDialog() {
        CheckstyleMarkerFilterDialog dialog = new CheckstyleMarkerFilterDialog(this.mMainComposite.getShell(), (CheckstyleMarkerFilter)this.getFilter().clone());
        if (dialog.open() == 0) {
            CheckstyleMarkerFilter filter = dialog.getFilter();
            filter.saveState(this.getDialogSettings());
            this.mFilter = filter;
            this.refresh();
        }
    }

    protected void initActionBars(IActionBars actionBars) {
        this.initMenu(actionBars.getMenuManager());
        this.initToolBar(actionBars.getToolBarManager());
    }

    protected abstract void initMenu(IMenuManager var1);

    protected abstract void initToolBar(IToolBarManager var1);

    protected final CheckstyleMarkerFilter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new CheckstyleMarkerFilter();
            this.mFilter.restoreState(this.getDialogSettings());
        }
        return this.mFilter;
    }

    protected final Stats getStats() {
        return this.mStats;
    }

    protected final void refresh() {
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        CreateStatsJob job = new CreateStatsJob(this.getFilter(), this.getViewId());
        job.setPriority(50);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                AbstractStatsView.this.mStats = ((CreateStatsJob)event.getJob()).getStats();
                WorkbenchJob uiJob = new WorkbenchJob(Messages.AbstractStatsView_msgRefreshStats){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AbstractStatsView.this.handleStatsRebuilt();
                        return Status.OK_STATUS;
                    }
                };
                uiJob.setPriority(50);
                uiJob.setSystem(true);
                uiJob.schedule();
            }
        });
        service.schedule((Job)job, 0L, true);
    }

    protected final IDialogSettings getDialogSettings() {
        String concreteViewId = this.getViewId();
        IDialogSettings workbenchSettings = CheckstyleUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(concreteViewId);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(concreteViewId);
        }
        return settings;
    }

    protected abstract String getViewId();

    protected abstract void handleStatsRebuilt();

    protected abstract void makeActions();

    private void focusSelectionChanged(IWorkbenchPart part, ISelection selection) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            IFile file = AbstractStatsView.getFile(editor.getEditorInput());
            if (file != null) {
                resources.add((IResource)file);
            }
        } else if (selection instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)selection) {
                if (object instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)object;
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        this.considerAdaptable(elements[i], resources);
                        ++i;
                    }
                    continue;
                }
                if (!(object instanceof IAdaptable)) continue;
                this.considerAdaptable((IAdaptable)object, resources);
            }
        }
        IResource[] focusedResources = new IResource[resources.size()];
        resources.toArray(focusedResources);
        boolean updateNeeded = this.updateNeeded(this.mFocusedResources, focusedResources);
        if (updateNeeded) {
            this.mFocusedResources = focusedResources;
            this.getFilter().setFocusResource(focusedResources);
            this.refresh();
        }
    }

    private void considerAdaptable(IAdaptable adaptable, Collection<IResource> resources) {
        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource == null) {
            resource = (IResource)adaptable.getAdapter(IFile.class);
        }
        if (resource != null) {
            resources.add(resource);
        }
    }

    public static IFile getFile(IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        Object o = editorInput.getAdapter(IFile.class);
        if (o instanceof IFile) {
            return (IFile)o;
        }
        return null;
    }

    private boolean updateNeeded(IResource[] oldResources, IResource[] newResources) {
        CheckstyleMarkerFilter filter = this.getFilter();
        if (!filter.isEnabled()) {
            return false;
        }
        int onResource = filter.getOnResource();
        if (onResource == 0 || onResource == 4) {
            return false;
        }
        if (newResources == null || newResources.length < 1) {
            return false;
        }
        if (oldResources == null || oldResources.length < 1) {
            return true;
        }
        if (Arrays.equals(oldResources, newResources)) {
            return false;
        }
        if (onResource == 3) {
            Collection<IProject> oldProjects = CheckstyleMarkerFilter.getProjectsAsCollection(oldResources);
            Collection<IProject> newProjects = CheckstyleMarkerFilter.getProjectsAsCollection(newResources);
            if (oldProjects.size() == newProjects.size()) {
                return !newProjects.containsAll(oldProjects);
            }
            return true;
        }
        return true;
    }
}

