/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.blocks;

import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class NeedBracesQuickfix
extends AbstractASTResolution {
    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(IfStatement node) {
                int nodePos = node.getStartPosition();
                int nodeEnd = nodePos + node.getLength();
                if (nodePos >= lineInfo.getOffset() && nodePos <= lineInfo.getOffset() + lineInfo.getLength() || nodePos <= lineInfo.getOffset() && nodeEnd >= lineInfo.getOffset() + lineInfo.getLength()) {
                    this.bracifyIfStatement(node);
                }
                return true;
            }

            public boolean visit(ForStatement node) {
                if (NeedBracesQuickfix.this.containsPosition(lineInfo, node.getStartPosition())) {
                    Block block = this.createBracifiedCopy(node.getAST(), node.getBody());
                    node.setBody((Statement)block);
                }
                return true;
            }

            public boolean visit(DoStatement node) {
                if (NeedBracesQuickfix.this.containsPosition(lineInfo, node.getStartPosition())) {
                    Block block = this.createBracifiedCopy(node.getAST(), node.getBody());
                    node.setBody((Statement)block);
                }
                return true;
            }

            public boolean visit(WhileStatement node) {
                if (NeedBracesQuickfix.this.containsPosition(lineInfo, node.getStartPosition())) {
                    Block block = this.createBracifiedCopy(node.getAST(), node.getBody());
                    node.setBody((Statement)block);
                }
                return true;
            }

            private void bracifyIfStatement(IfStatement ifStatement) {
                Statement elseStatement;
                if (!(ifStatement.getThenStatement() instanceof Block)) {
                    if (ifStatement.getThenStatement() instanceof IfStatement) {
                        this.bracifyIfStatement((IfStatement)ifStatement.getThenStatement());
                    }
                    Block block = this.createBracifiedCopy(ifStatement.getAST(), ifStatement.getThenStatement());
                    ifStatement.setThenStatement((Statement)block);
                }
                if ((elseStatement = ifStatement.getElseStatement()) != null && !(elseStatement instanceof Block)) {
                    if (elseStatement instanceof IfStatement) {
                        this.bracifyIfStatement((IfStatement)elseStatement);
                    } else {
                        Block block = this.createBracifiedCopy(ifStatement.getAST(), ifStatement.getElseStatement());
                        ifStatement.setElseStatement((Statement)block);
                    }
                }
            }

            private Block createBracifiedCopy(AST ast, Statement body) {
                Block block = ast.newBlock();
                block.statements().add(ASTNode.copySubtree((AST)block.getAST(), (ASTNode)body));
                return block;
            }
        };
    }

    public String getDescription() {
        return Messages.NeedBracesQuickfix_description;
    }

    public String getLabel() {
        return Messages.NeedBracesQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_ADD);
    }
}

