/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;
import org.junit.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractQuickfixTestCase
extends TestCase {
    protected void testQuickfix(String testDataXml, AbstractASTResolution quickfix) throws Exception {
        AbstractQuickfixTestCase.assertNotNull((String)("Cannot find resource " + testDataXml + " in package " + ((Object)((Object)this)).getClass().getPackage().getName()), (Object)stream);
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(testDataXml);){
            System.out.println("Test quickfix " + quickfix.getClass() + " with input file `" + testDataXml + "`");
            this.testQuickfix(stream, quickfix);
        }
    }

    protected void testQuickfix(InputStream testdataStream, AbstractASTResolution quickfix) throws Exception {
        QuickfixTestData[] testdata = this.getTestData(testdataStream);
        int i = 0;
        while (i < testdata.length) {
            Document doc = new Document(testdata[i].input);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(doc.get().toCharArray());
            CompilationUnit compUnit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            compUnit.recordModifications();
            IRegion region = doc.getLineInformation(testdata[i].line);
            int markerStartOffset = region.getOffset() + testdata[i].position;
            System.out.println("Invoke quickfix " + quickfix.getClass() + " with markerStartOffset=" + markerStartOffset);
            compUnit.accept(quickfix.handleGetCorrectingASTVisitor(region, markerStartOffset));
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
            options.put("org.eclipse.jdt.core.formatter.tabulation.size", "4");
            options.put("org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_cases", "true");
            options.put("org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_switch", "true");
            TextEdit edit = compUnit.rewrite((IDocument)doc, options);
            edit.apply((IDocument)doc);
            Assert.assertEquals((Object)testdata[i].result, (Object)doc.get());
            ++i;
        }
    }

    private QuickfixTestData[] getTestData(InputStream testDataStream) throws Exception {
        ArrayList<QuickfixTestData> testdata = new ArrayList<QuickfixTestData>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        org.w3c.dom.Document doc = docBuilder.parse(testDataStream);
        NodeList nl = doc.getElementsByTagName("testcase");
        int i = 0;
        int size = nl.getLength();
        while (i < size) {
            Element testCase = (Element)nl.item(i);
            Element input = (Element)testCase.getElementsByTagName("input").item(0);
            int line = Integer.parseInt(input.getAttribute("fix-line"));
            int position = 0;
            if (!Strings.isNullOrEmpty((String)input.getAttribute("position"))) {
                position = Integer.parseInt(input.getAttribute("position"));
            }
            Element result = (Element)testCase.getElementsByTagName("result").item(0);
            String inputString = input.getFirstChild().getNodeValue().trim();
            String resultString = result.getFirstChild().getNodeValue().trim();
            QuickfixTestData td = new QuickfixTestData();
            td.input = inputString;
            td.result = resultString;
            td.line = line;
            td.position = position;
            testdata.add(td);
            ++i;
        }
        return testdata.toArray(new QuickfixTestData[testdata.size()]);
    }

    private class QuickfixTestData {
        String input;
        String result;
        int line;
        int position;

        private QuickfixTestData() {
        }
    }
}

