/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.configtypes.RemoteConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteConfigurationEditor
implements ICheckConfigurationEditor {
    private CheckConfigurationWorkingCopy mWorkingCopy;
    private Text mConfigName;
    private Text mLocation;
    private Text mDescription;
    private Button mChkCacheConfig;
    private Text mUserName;
    private Text mPassword;

    @Override
    public void initialize(CheckConfigurationWorkingCopy checkConfiguration, CheckConfigurationPropertiesDialog dialog) {
        this.mWorkingCopy = checkConfiguration;
    }

    @Override
    public Control createEditorControl(Composite parent, Shell shell) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        Label lblConfigName = new Label(contents, 0);
        lblConfigName.setText(Messages.CheckConfigurationPropertiesDialog_lblName);
        GridData gd = new GridData();
        lblConfigName.setLayoutData((Object)gd);
        this.mConfigName = new Text(contents, 18436);
        gd = new GridData(768);
        this.mConfigName.setLayoutData((Object)gd);
        this.mConfigName.setFocus();
        Label lblConfigLocation = new Label(contents, 0);
        lblConfigLocation.setText(Messages.CheckConfigurationPropertiesDialog_lblLocation);
        gd = new GridData();
        gd.verticalAlignment = 2;
        lblConfigLocation.setLayoutData((Object)gd);
        this.mLocation = new Text(contents, 18436);
        gd = new GridData(768);
        this.mLocation.setLayoutData((Object)gd);
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationPropertiesDialog_lblDescription);
        gd = new GridData();
        gd.horizontalSpan = 2;
        lblDescription.setLayoutData((Object)gd);
        this.mDescription = new Text(contents, 19010);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 100;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.mDescription.setLayoutData((Object)gd);
        Group credentialsGroup = new Group(contents, 0);
        credentialsGroup.setText(Messages.RemoteConfigurationEditor_titleCredentialsGroup);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        credentialsGroup.setLayoutData((Object)gd);
        credentialsGroup.setLayout((Layout)new GridLayout(2, false));
        Label lblUserName = new Label((Composite)credentialsGroup, 0);
        lblUserName.setText(Messages.RemoteConfigurationEditor_lblUserName);
        gd = new GridData();
        lblUserName.setLayoutData((Object)gd);
        this.mUserName = new Text((Composite)credentialsGroup, 2052);
        gd = new GridData();
        gd.widthHint = 100;
        this.mUserName.setLayoutData((Object)gd);
        Label lblPassword = new Label((Composite)credentialsGroup, 0);
        lblPassword.setText(Messages.RemoteConfigurationEditor_lblPassword);
        gd = new GridData();
        lblPassword.setLayoutData((Object)gd);
        this.mPassword = new Text((Composite)credentialsGroup, 0x400804);
        gd = new GridData();
        gd.widthHint = 100;
        this.mPassword.setLayoutData((Object)gd);
        Group advancedGroup = new Group(contents, 0);
        advancedGroup.setText(Messages.RemoteConfigurationEditor_titleAdvancedOptions);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        advancedGroup.setLayoutData((Object)gd);
        advancedGroup.setLayout((Layout)new GridLayout(2, false));
        this.mChkCacheConfig = new Button((Composite)advancedGroup, 32);
        this.mChkCacheConfig.setText(Messages.RemoteConfigurationEditor_btnCacheRemoteConfig);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mChkCacheConfig.setLayoutData((Object)gd);
        if (this.mWorkingCopy.getName() != null) {
            this.mConfigName.setText(this.mWorkingCopy.getName());
        }
        if (this.mWorkingCopy.getLocation() != null) {
            this.mLocation.setText(this.mWorkingCopy.getLocation());
        }
        if (this.mWorkingCopy.getDescription() != null) {
            this.mDescription.setText(this.mWorkingCopy.getDescription());
        }
        this.mChkCacheConfig.setSelection(Boolean.valueOf((String)this.mWorkingCopy.getAdditionalData().get("cache-file")).booleanValue());
        if (this.mWorkingCopy.getLocation() != null) {
            try {
                PasswordAuthentication auth = RemoteConfigurationType.RemoteConfigAuthenticator.getPasswordAuthentication((URL)this.mWorkingCopy.getResolvedConfigurationFileURL());
                if (auth != null) {
                    this.mUserName.setText(auth.getUserName());
                    this.mPassword.setText(new String(auth.getPassword()));
                }
            }
            catch (CheckstylePluginException e) {
                CheckstyleUIPlugin.errorDialog(shell, e, true);
            }
        }
        return contents;
    }

    @Override
    public CheckConfigurationWorkingCopy getEditedWorkingCopy() throws CheckstylePluginException {
        if (this.mChkCacheConfig.getSelection() && this.mWorkingCopy.getAdditionalData().get("cache-file-location") == null) {
            long currentTime = System.currentTimeMillis();
            this.mWorkingCopy.getAdditionalData().put("cache-file-location", String.valueOf(this.mWorkingCopy.getName()) + "_" + currentTime + "_cache.xml");
            this.mWorkingCopy.getAdditionalData().put("cache-props-file-location", String.valueOf(this.mWorkingCopy.getName()) + "_" + currentTime + "_cache.properties");
        }
        try {
            if (Strings.emptyToNull((String)this.mUserName.getText()) != null || Strings.emptyToNull((String)this.mPassword.getText()) != null) {
                RemoteConfigurationType.RemoteConfigAuthenticator.storeCredentials((URL)new URL(this.mLocation.getText()), (String)this.mUserName.getText(), (String)this.mPassword.getText());
            } else {
                RemoteConfigurationType.RemoteConfigAuthenticator.removeCachedAuthInfo((URL)new URL(this.mLocation.getText()));
            }
        }
        catch (MalformedURLException e) {
            CheckstylePluginException.rethrow((Throwable)e);
        }
        this.mWorkingCopy.setName(this.mConfigName.getText());
        this.mWorkingCopy.setLocation(this.mLocation.getText());
        this.mWorkingCopy.setDescription(this.mDescription.getText());
        this.mWorkingCopy.getAdditionalData().put("cache-file", "" + this.mChkCacheConfig.getSelection());
        return this.mWorkingCopy;
    }
}

