/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config.configtypes;

import com.google.common.base.Strings;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ConfigurationWriter;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ExternalFileConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationPropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalFileConfigurationEditor
implements ICheckConfigurationEditor {
    private CheckConfigurationWorkingCopy mWorkingCopy;
    private Text mConfigName;
    private Text mLocation;
    private Button mBtnBrowse;
    private Text mDescription;
    private Button mChkProtectConfig;

    @Override
    public void initialize(CheckConfigurationWorkingCopy checkConfiguration, CheckConfigurationPropertiesDialog dialog) {
        this.mWorkingCopy = checkConfiguration;
    }

    @Override
    public Control createEditorControl(Composite parent, final Shell shell) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        contents.setLayout((Layout)layout);
        Label lblConfigName = new Label(contents, 0);
        lblConfigName.setText(Messages.CheckConfigurationPropertiesDialog_lblName);
        GridData gd = new GridData();
        lblConfigName.setLayoutData((Object)gd);
        this.mConfigName = new Text(contents, 18436);
        gd = new GridData(768);
        this.mConfigName.setLayoutData((Object)gd);
        this.mConfigName.setFocus();
        Label lblConfigLocation = new Label(contents, 0);
        lblConfigLocation.setText(Messages.CheckConfigurationPropertiesDialog_lblLocation);
        gd = new GridData();
        lblConfigLocation.setLayoutData((Object)gd);
        Composite locationComposite = new Composite(contents, 0);
        locationComposite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        locationComposite.setLayout((Layout)layout);
        this.mLocation = new Text(locationComposite, 18436);
        gd = new GridData(768);
        this.mLocation.setLayoutData((Object)gd);
        this.mBtnBrowse = new Button(locationComposite, 8);
        this.mBtnBrowse.setText(Messages.FileConfigurationLocationEditor_btnBrowse);
        gd = new GridData();
        this.mBtnBrowse.setLayoutData((Object)gd);
        this.mBtnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setFileName(ExternalFileConfigurationEditor.this.mLocation.getText());
                String file = fileDialog.open();
                if (file != null) {
                    ExternalFileConfigurationEditor.this.mLocation.setText(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationPropertiesDialog_lblDescription);
        gd = new GridData();
        gd.horizontalSpan = 2;
        lblDescription.setLayoutData((Object)gd);
        this.mDescription = new Text(contents, 19010);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 100;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.mDescription.setLayoutData((Object)gd);
        Group advancedGroup = new Group(contents, 0);
        advancedGroup.setText(Messages.RemoteConfigurationEditor_titleAdvancedOptions);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        advancedGroup.setLayoutData((Object)gd);
        advancedGroup.setLayout((Layout)new GridLayout(2, false));
        this.mChkProtectConfig = new Button((Composite)advancedGroup, 32);
        this.mChkProtectConfig.setText(Messages.ExternalFileConfigurationEditor_btnProtectConfigFile);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mChkProtectConfig.setLayoutData((Object)gd);
        if (this.mWorkingCopy.getName() != null) {
            this.mConfigName.setText(this.mWorkingCopy.getName());
        }
        if (this.mWorkingCopy.getLocation() != null) {
            this.mLocation.setText(this.mWorkingCopy.getLocation());
        }
        if (this.mWorkingCopy.getDescription() != null) {
            this.mDescription.setText(this.mWorkingCopy.getDescription());
        }
        this.mChkProtectConfig.setSelection(Boolean.valueOf((String)this.mWorkingCopy.getAdditionalData().get("protect-config-file")).booleanValue());
        return contents;
    }

    @Override
    public CheckConfigurationWorkingCopy getEditedWorkingCopy() throws CheckstylePluginException {
        this.mWorkingCopy.setName(this.mConfigName.getText());
        this.mWorkingCopy.setDescription(this.mDescription.getText());
        this.mWorkingCopy.getAdditionalData().put("protect-config-file", "" + this.mChkProtectConfig.getSelection());
        try {
            this.mWorkingCopy.setLocation(this.mLocation.getText());
        }
        catch (CheckstylePluginException e) {
            String location = this.mLocation.getText();
            if (Strings.emptyToNull((String)location) != null && this.ensureFileExists(location)) {
                this.mWorkingCopy.setLocation(this.mLocation.getText());
            }
            throw e;
        }
        return this.mWorkingCopy;
    }

    private boolean ensureFileExists(String location) throws CheckstylePluginException {
        String resolvedLocation = ExternalFileConfigurationType.resolveDynamicLocation((String)location);
        File file = new File(resolvedLocation);
        if (!file.exists()) {
            boolean confirm = MessageDialog.openQuestion((Shell)this.mBtnBrowse.getShell(), (String)Messages.ExternalFileConfigurationEditor_titleFileDoesNotExist, (String)Messages.ExternalFileConfigurationEditor_msgFileDoesNotExist);
            if (confirm) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                        ConfigurationWriter.writeNewConfiguration((OutputStream)out, (ICheckConfiguration)this.mWorkingCopy);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException ioe) {
                    CheckstylePluginException.rethrow((Throwable)ioe);
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

