/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckConfigurationTester;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.ResolvablePropertyEditDialog;
import net.sf.eclipsecs.ui.util.SWTUtil;
import net.sf.eclipsecs.ui.util.table.EnhancedTableViewer;
import net.sf.eclipsecs.ui.util.table.ITableComparableProvider;
import net.sf.eclipsecs.ui.util.table.ITableSettingsProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResolvablePropertiesDialog
extends TitleAreaDialog {
    private EnhancedTableViewer mTableViewer;
    private Button mBtnAdd;
    private Button mBtnEdit;
    private Button mBtnRemove;
    private Button mBtnFind;
    private Controller mController = new Controller();
    private CheckConfigurationWorkingCopy mCheckConfig;
    private List<ResolvableProperty> mResolvableProperties;

    public ResolvablePropertiesDialog(Shell parent, CheckConfigurationWorkingCopy checkConfig) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.mCheckConfig = checkConfig;
    }

    public CheckConfigurationWorkingCopy getCheckConfiguration() {
        return this.mCheckConfig;
    }

    public void create() {
        super.create();
        this.initialize();
        SWTUtil.addResizeSupport((Dialog)this, CheckstyleUIPlugin.getDefault().getDialogSettings(), ResolvablePropertiesDialog.class.getName());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.PLUGIN_LOGO));
        this.setTitle(Messages.ResolvablePropertiesDialog_titleMessageArea);
        this.setMessage(Messages.ResolvablePropertiesDialog_msgAdditionalProperties);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        GridData fd = new GridData(1808);
        contents.setLayoutData((Object)fd);
        Table table = new Table(contents, 67586);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.ResolvablePropertiesDialog_colName);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.ResolvablePropertiesDialog_colValue);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this.mTableViewer = new EnhancedTableViewer(table);
        PropertiesLabelProvider multiProvider = new PropertiesLabelProvider();
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)multiProvider);
        this.mTableViewer.setTableComparableProvider(multiProvider);
        this.mTableViewer.setTableSettingsProvider(multiProvider);
        this.mTableViewer.installEnhancements();
        this.mTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mTableViewer.addDoubleClickListener(this.mController);
        this.mTableViewer.getTable().addKeyListener((KeyListener)this.mController);
        Composite buttonBar = new Composite(contents, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        buttonBar.setLayoutData((Object)gd);
        this.mBtnAdd = new Button(buttonBar, 8);
        this.mBtnAdd.setText(Messages.ResolvablePropertiesDialog_btnAdd);
        this.mBtnAdd.setLayoutData((Object)new GridData(768));
        this.mBtnAdd.addSelectionListener((SelectionListener)this.mController);
        this.mBtnEdit = new Button(buttonBar, 8);
        this.mBtnEdit.setText(Messages.ResolvablePropertiesDialog_btnEdit);
        this.mBtnEdit.setLayoutData((Object)new GridData(768));
        this.mBtnEdit.addSelectionListener((SelectionListener)this.mController);
        this.mBtnRemove = new Button(buttonBar, 8);
        this.mBtnRemove.setText(Messages.ResolvablePropertiesDialog_btnRemove);
        this.mBtnRemove.setLayoutData((Object)new GridData(768));
        this.mBtnRemove.addSelectionListener((SelectionListener)this.mController);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.mBtnFind = new Button(composite, 8);
        this.mBtnFind.setText(Messages.ResolvablePropertiesDialog_btnFind);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 5;
        this.mBtnFind.setLayoutData((Object)gd);
        this.mBtnFind.addSelectionListener((SelectionListener)this.mController);
        Control buttonBar = super.createButtonBar(composite);
        gd = new GridData(768);
        gd.horizontalAlignment = 3;
        buttonBar.setLayoutData((Object)gd);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ResolvablePropertiesDialog_titleDialog);
    }

    protected Point getInitialSize() {
        return new Point(650, 500);
    }

    protected void okPressed() {
        for (ResolvableProperty prop : this.mResolvableProperties) {
            if (Strings.emptyToNull((String)prop.getValue()) != null) continue;
            this.setErrorMessage(NLS.bind((String)Messages.ResolvablePropertiesDialog_msgMissingPropertyValue, (Object)prop.getPropertyName()));
            return;
        }
        this.mCheckConfig.getResolvableProperties().clear();
        this.mCheckConfig.getResolvableProperties().addAll(this.mResolvableProperties);
        super.okPressed();
    }

    private void initialize() {
        this.mResolvableProperties = new ArrayList<ResolvableProperty>();
        for (ResolvableProperty prop : this.mCheckConfig.getResolvableProperties()) {
            this.mResolvableProperties.add(prop.clone());
        }
        this.mTableViewer.setInput(this.mResolvableProperties);
    }

    private class Controller
    implements SelectionListener,
    IDoubleClickListener,
    KeyListener {
        private Controller() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ResolvablePropertiesDialog.this.mBtnAdd == e.widget) {
                this.openPropertyItemEditor(null);
            } else if (ResolvablePropertiesDialog.this.mBtnEdit == e.widget && !ResolvablePropertiesDialog.this.mTableViewer.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)ResolvablePropertiesDialog.this.mTableViewer.getSelection();
                ResolvableProperty prop = (ResolvableProperty)selection.getFirstElement();
                this.openPropertyItemEditor(prop);
            } else if (ResolvablePropertiesDialog.this.mBtnRemove == e.widget) {
                this.removePropertyItems();
            } else if (ResolvablePropertiesDialog.this.mBtnFind == e.widget) {
                this.findPropertyItems();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (!event.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)ResolvablePropertiesDialog.this.mTableViewer.getSelection();
                ResolvableProperty prop = (ResolvableProperty)selection.getFirstElement();
                this.openPropertyItemEditor(prop);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.widget == ResolvablePropertiesDialog.this.mTableViewer.getTable()) {
                if (e.character == '\u007f') {
                    this.removePropertyItems();
                }
                if (e.character == ' ') {
                    IStructuredSelection selection = (IStructuredSelection)ResolvablePropertiesDialog.this.mTableViewer.getSelection();
                    ResolvableProperty prop = (ResolvableProperty)selection.getFirstElement();
                    this.openPropertyItemEditor(prop);
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        private void openPropertyItemEditor(ResolvableProperty prop) {
            if (prop == null) {
                ResolvableProperty newProp = new ResolvableProperty(null, null);
                ResolvablePropertyEditDialog dialog = new ResolvablePropertyEditDialog(ResolvablePropertiesDialog.this.getShell(), newProp);
                if (dialog.open() == 0) {
                    ResolvablePropertiesDialog.this.mResolvableProperties.add(newProp);
                    ResolvablePropertiesDialog.this.mTableViewer.refresh();
                }
            } else {
                ResolvablePropertyEditDialog dialog = new ResolvablePropertyEditDialog(ResolvablePropertiesDialog.this.getShell(), prop);
                if (dialog.open() == 0) {
                    ResolvablePropertiesDialog.this.mTableViewer.refresh();
                }
            }
        }

        private void removePropertyItems() {
            boolean confirm = MessageDialog.openQuestion((Shell)ResolvablePropertiesDialog.this.getShell(), (String)Messages.ResolvablePropertiesDialog_titleRemoveConfirmation, (String)Messages.ResolvablePropertiesDialog_msgRemoveConfirmation);
            if (confirm) {
                IStructuredSelection selection = (IStructuredSelection)ResolvablePropertiesDialog.this.mTableViewer.getSelection();
                ResolvablePropertiesDialog.this.mResolvableProperties.removeAll(selection.toList());
                ResolvablePropertiesDialog.this.mTableViewer.refresh();
            }
        }

        private void findPropertyItems() {
            CheckConfigurationWorkingCopy clone = ResolvablePropertiesDialog.this.mCheckConfig.clone();
            clone.getResolvableProperties().clear();
            clone.getResolvableProperties().addAll(ResolvablePropertiesDialog.this.mResolvableProperties);
            CheckConfigurationTester tester = new CheckConfigurationTester((ICheckConfiguration)clone);
            try {
                List unresolvedProps = tester.getUnresolvedProperties();
                Iterator it = unresolvedProps.iterator();
                block2: while (it.hasNext()) {
                    ResolvableProperty prop = (ResolvableProperty)it.next();
                    Iterator it2 = ResolvablePropertiesDialog.this.mResolvableProperties.iterator();
                    while (it2.hasNext()) {
                        if (!prop.getPropertyName().equals(((ResolvableProperty)it2.next()).getPropertyName())) continue;
                        it.remove();
                        continue block2;
                    }
                }
                if (!unresolvedProps.isEmpty()) {
                    StringBuffer buf = new StringBuffer();
                    it = unresolvedProps.iterator();
                    while (it.hasNext()) {
                        buf.append("\t${").append(((ResolvableProperty)it.next()).getPropertyName()).append("}\n");
                    }
                    boolean confirm = MessageDialog.openQuestion((Shell)ResolvablePropertiesDialog.this.getShell(), (String)Messages.ResolvablePropertiesDialog_titleFoundProperties, (String)NLS.bind((String)Messages.ResolvablePropertiesDialog_msgFoundProperties, (Object)buf));
                    if (confirm) {
                        ResolvablePropertiesDialog.this.mResolvableProperties.addAll(unresolvedProps);
                        ResolvablePropertiesDialog.this.mTableViewer.refresh();
                    }
                } else {
                    MessageDialog.openInformation((Shell)ResolvablePropertiesDialog.this.getShell(), (String)Messages.ResolvablePropertiesDialog_titleNoUnresolvedProps, (String)Messages.ResolvablePropertiesDialog_msgNoUnresolvedProps);
                }
            }
            catch (CheckstylePluginException e) {
                CheckstyleUIPlugin.errorDialog(ResolvablePropertiesDialog.this.getShell(), e, true);
            }
        }
    }

    private class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableComparableProvider,
    ITableSettingsProvider {
        private PropertiesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = element.toString();
            if (element instanceof ResolvableProperty) {
                ResolvableProperty prop = (ResolvableProperty)element;
                if (columnIndex == 0) {
                    result = prop.getPropertyName();
                }
                if (columnIndex == 1) {
                    result = prop.getValue();
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 0 ? this.getImage(element) : null;
        }

        public Comparable<String> getComparableValue(Object element, int col) {
            return this.getColumnText(element, col);
        }

        @Override
        public IDialogSettings getTableSettings() {
            String concreteViewId = ResolvablePropertiesDialog.class.getName();
            IDialogSettings workbenchSettings = CheckstyleUIPlugin.getDefault().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection(concreteViewId);
            if (settings == null) {
                settings = workbenchSettings.addNewSection(concreteViewId);
            }
            return settings;
        }
    }
}

