/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config;

import java.util.List;
import net.sf.eclipsecs.core.config.CheckConfigurationTester;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationTypes;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.ResolvablePropertiesDialog;
import net.sf.eclipsecs.ui.config.configtypes.ConfigurationTypesUI;
import net.sf.eclipsecs.ui.config.configtypes.ICheckConfigurationEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CheckConfigurationPropertiesDialog
extends TitleAreaDialog {
    private Button mBtnProperties;
    private ICheckConfigurationWorkingSet mWorkingSet;
    private CheckConfigurationWorkingCopy mCheckConfig;
    private ComboViewer mConfigType;
    private Composite mEditorPlaceHolder;
    private ICheckConfigurationEditor mConfigurationEditor;
    private ICheckConfiguration mTemplate;

    public CheckConfigurationPropertiesDialog(Shell parent, CheckConfigurationWorkingCopy checkConfig, ICheckConfigurationWorkingSet workingSet) {
        super(parent);
        this.mWorkingSet = workingSet;
        this.mCheckConfig = checkConfig;
    }

    public ICheckConfigurationWorkingSet getCheckConfigurationWorkingSet() {
        return this.mWorkingSet;
    }

    public void setTemplateConfiguration(ICheckConfiguration template) {
        this.mTemplate = template;
    }

    public CheckConfigurationWorkingCopy getCheckConfiguration() {
        return this.mCheckConfig;
    }

    public void create() {
        super.create();
        this.initialize();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.PLUGIN_LOGO));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        GridData fd = new GridData(1808);
        contents.setLayoutData((Object)fd);
        Label lblConfigType = new Label(contents, 0);
        lblConfigType.setText(Messages.CheckConfigurationPropertiesDialog_lblConfigType);
        fd = new GridData();
        GC gc = new GC((Drawable)lblConfigType);
        int nameSize = gc.textExtent((String)Messages.CheckConfigurationPropertiesDialog_lblName).x;
        int locationsSize = gc.textExtent((String)Messages.CheckConfigurationPropertiesDialog_lblLocation).x;
        int max = Math.max(nameSize, locationsSize);
        gc.dispose();
        fd.widthHint = max;
        lblConfigType.setLayoutData((Object)fd);
        this.mConfigType = new ComboViewer(contents);
        fd = new GridData();
        this.mConfigType.getCombo().setLayoutData((Object)fd);
        this.mConfigType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mConfigType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationType)element).getName();
            }

            public Image getImage(Object element) {
                return ConfigurationTypesUI.getConfigurationTypeImage((IConfigurationType)element);
            }
        });
        this.mConfigType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IConfigurationType type = (IConfigurationType)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (CheckConfigurationPropertiesDialog.this.mConfigType.getCombo().isEnabled()) {
                        String oldName = CheckConfigurationPropertiesDialog.this.mCheckConfig.getName();
                        String oldDescr = CheckConfigurationPropertiesDialog.this.mCheckConfig.getDescription();
                        CheckConfigurationPropertiesDialog.this.mCheckConfig = CheckConfigurationPropertiesDialog.this.mWorkingSet.newWorkingCopy(type);
                        try {
                            CheckConfigurationPropertiesDialog.this.mCheckConfig.setName(oldName);
                        }
                        catch (CheckstylePluginException checkstylePluginException) {
                            // empty catch block
                        }
                        CheckConfigurationPropertiesDialog.this.mCheckConfig.setDescription(oldDescr);
                    }
                    CheckConfigurationPropertiesDialog.this.createConfigurationEditor(CheckConfigurationPropertiesDialog.this.mCheckConfig);
                }
            }
        });
        this.mEditorPlaceHolder = new Composite(contents, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.mEditorPlaceHolder.setLayout((Layout)layout);
        fd = new GridData(768);
        fd.horizontalSpan = 2;
        this.mEditorPlaceHolder.setLayoutData((Object)fd);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.mBtnProperties = new Button(composite, 8);
        this.mBtnProperties.setText(Messages.CheckConfigurationPropertiesDialog_btnAdditionalProps);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 5;
        this.mBtnProperties.setLayoutData((Object)gd);
        this.mBtnProperties.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CheckConfigurationPropertiesDialog.this.mConfigurationEditor.getEditedWorkingCopy();
                    ResolvablePropertiesDialog dialog = new ResolvablePropertiesDialog(CheckConfigurationPropertiesDialog.this.getShell(), CheckConfigurationPropertiesDialog.this.mCheckConfig);
                    dialog.open();
                }
                catch (CheckstylePluginException ex) {
                    CheckConfigurationPropertiesDialog.this.setErrorMessage(ex.getLocalizedMessage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Control buttonBar = super.createButtonBar(composite);
        gd = new GridData(768);
        gd.horizontalAlignment = 3;
        buttonBar.setLayoutData((Object)gd);
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CheckConfigurationPropertiesDialog_titleCheckProperties);
    }

    protected void okPressed() {
        try {
            this.mCheckConfig = this.mConfigurationEditor.getEditedWorkingCopy();
            CheckConfigurationTester tester = new CheckConfigurationTester((ICheckConfiguration)this.mCheckConfig);
            List unresolvedProps = tester.getUnresolvedProperties();
            if (!unresolvedProps.isEmpty()) {
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.CheckConfigurationPropertiesDialog_titleUnresolvedProps, null, NLS.bind((String)Messages.CheckConfigurationPropertiesDialog_msgUnresolvedProps, (Object)("" + unresolvedProps.size())), 4, new String[]{Messages.CheckConfigurationPropertiesDialog_btnEditProps, Messages.CheckConfigurationPropertiesDialog_btnContinue, Messages.CheckConfigurationPropertiesDialog_btnCancel}, 0);
                int result = dialog.open();
                if (result == 0) {
                    ResolvablePropertiesDialog propsDialog = new ResolvablePropertiesDialog(this.getShell(), this.mCheckConfig);
                    propsDialog.open();
                    return;
                }
                if (1 == result) {
                    super.okPressed();
                } else if (2 == result) {
                    return;
                }
            } else {
                super.okPressed();
            }
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log((Throwable)e);
            this.setErrorMessage(e.getLocalizedMessage());
        }
    }

    private void createConfigurationEditor(CheckConfigurationWorkingCopy config) {
        try {
            this.mConfigurationEditor = ConfigurationTypesUI.getNewEditor(config.getType());
            this.mConfigurationEditor.initialize(config, this);
            Control[] controls = this.mEditorPlaceHolder.getChildren();
            int i = 0;
            while (i < controls.length) {
                controls[i].dispose();
                ++i;
            }
            this.mConfigurationEditor.createEditorControl(this.mEditorPlaceHolder, this.getShell());
            this.mEditorPlaceHolder.redraw();
            this.mEditorPlaceHolder.update();
            this.mEditorPlaceHolder.layout();
            Point initialSize = this.getInitialSize();
            this.getShell().setSize(initialSize);
            this.mBtnProperties.setEnabled(this.mCheckConfig.getType().isEditable());
        }
        catch (Exception ex) {
            CheckstyleUIPlugin.errorDialog(this.getShell(), ex, true);
        }
    }

    private void initialize() {
        if (this.mCheckConfig == null) {
            IConfigurationType[] types = this.mTemplate != null ? ConfigurationTypes.getConfigurableConfigTypes() : ConfigurationTypes.getCreatableConfigTypes();
            this.mCheckConfig = this.mWorkingSet.newWorkingCopy(types[0]);
            if (this.mTemplate != null) {
                this.setTitle(NLS.bind((String)Messages.CheckConfigurationPropertiesDialog_titleCopyConfiguration, (Object)this.mTemplate.getName()));
                this.setMessage(Messages.CheckConfigurationPropertiesDialog_msgCopyConfiguration);
                String nameProposal = NLS.bind((String)Messages.CheckConfigurationPropertiesDialog_CopyOfAddition, (Object)this.mTemplate.getName());
                this.setUniqueName(this.mCheckConfig, nameProposal);
                this.mCheckConfig.setDescription(this.mTemplate.getDescription());
                this.mCheckConfig.getResolvableProperties().addAll(this.mTemplate.getResolvableProperties());
            } else {
                this.setTitle(Messages.CheckConfigurationPropertiesDialog_titleCheckConfig);
                this.setMessage(Messages.CheckConfigurationPropertiesDialog_msgCreateNewCheckConfig);
            }
            this.mConfigType.setInput((Object)types);
            this.mConfigType.setSelection((ISelection)new StructuredSelection((Object)types[0]), true);
            this.createConfigurationEditor(this.mCheckConfig);
        } else {
            this.setTitle(Messages.CheckConfigurationPropertiesDialog_titleCheckConfig);
            this.setMessage(Messages.CheckConfigurationPropertiesDialog_msgEditCheckConfig);
            this.mConfigType.getCombo().setEnabled(false);
            this.mConfigType.setInput((Object)new IConfigurationType[]{this.mCheckConfig.getType()});
            this.mConfigType.setSelection((ISelection)new StructuredSelection((Object)this.mCheckConfig.getType()), true);
            this.createConfigurationEditor(this.mCheckConfig);
        }
    }

    private void setUniqueName(CheckConfigurationWorkingCopy config, String checkConfigName) {
        String uniqueName = checkConfigName;
        int counter = 2;
        while (true) {
            try {
                config.setName(uniqueName);
            }
            catch (CheckstylePluginException e) {
                uniqueName = String.valueOf(checkConfigName) + " (" + counter + ")";
                ++counter;
                continue;
            }
            break;
        }
    }
}

