/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleGroupMetadata;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.CheckstyleUIPluginPrefs;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.RuleConfigurationEditDialog;
import net.sf.eclipsecs.ui.util.SWTUtil;
import net.sf.eclipsecs.ui.util.table.EnhancedCheckBoxTableViewer;
import net.sf.eclipsecs.ui.util.table.ITableComparableProvider;
import net.sf.eclipsecs.ui.util.table.ITableSettingsProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class CheckConfigurationConfigureDialog
extends TitleAreaDialog {
    private final CheckConfigurationWorkingCopy mConfiguration;
    private boolean mConfigurable;
    private Text mTxtTreeFilter;
    private TreeViewer mTreeViewer;
    private Button mAddButton;
    private EnhancedCheckBoxTableViewer mTableViewer;
    private Button mRemoveButton;
    private Button mEditButton;
    private Group mConfiguredModulesGroup;
    private Browser mBrowserDescription;
    private Button mBtnOpenModuleOnAdd;
    private final RuleGroupModuleFilter mGroupFilter = new RuleGroupModuleFilter();
    private final PageController mController = new PageController();
    private List<Module> mModules;
    private boolean mIsDirty;
    private final String mDefaultFilterText = Messages.CheckConfigurationConfigureDialog_defaultFilterText;
    private final TreeFilter mTreeFilter = new TreeFilter();

    public CheckConfigurationConfigureDialog(Shell parentShell, CheckConfigurationWorkingCopy config) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.mConfiguration = config;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(composite, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(contents, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 700;
        gd.heightHint = 400;
        sashForm.setLayoutData((Object)gd);
        sashForm.setLayout((Layout)new GridLayout());
        Control treeControl = this.createTreeViewer((Composite)sashForm);
        treeControl.setLayoutData((Object)new GridData(1808));
        Control tableControl = this.createTableViewer((Composite)sashForm);
        tableControl.setLayoutData((Object)new GridData(1808));
        sashForm.setWeights(new int[]{30, 70});
        Label lblDescription = new Label(contents, 0);
        lblDescription.setText(Messages.CheckConfigurationConfigureDialog_lblDescription);
        lblDescription.setLayoutData((Object)new GridData(768));
        this.mBrowserDescription = new Browser(contents, 2048);
        gd = new GridData(1808);
        gd.heightHint = 100;
        this.mBrowserDescription.setLayoutData((Object)gd);
        this.initialize();
        return contents;
    }

    public void create() {
        super.create();
        SWTUtil.addResizeSupport((Dialog)this, CheckstyleUIPlugin.getDefault().getDialogSettings(), CheckConfigurationConfigureDialog.class.getName());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CheckConfigurationConfigureDialog_titleCheckConfigurationDialog);
    }

    protected void okPressed() {
        try {
            if (this.mConfigurable && this.mIsDirty) {
                this.mConfiguration.setModules(this.mModules);
            }
        }
        catch (CheckstylePluginException e) {
            CheckstyleUIPlugin.errorDialog(this.getShell(), e, true);
        }
        super.okPressed();
    }

    private Control createTreeViewer(Composite parent) {
        Group knownModules = new Group(parent, 0);
        knownModules.setLayout((Layout)new GridLayout());
        knownModules.setText(Messages.CheckConfigurationConfigureDialog_lblKnownModules);
        this.mTxtTreeFilter = new Text((Composite)knownModules, 2052);
        this.mTxtTreeFilter.setText(this.mDefaultFilterText);
        this.mTxtTreeFilter.setLayoutData((Object)new GridData(768));
        this.mTxtTreeFilter.addModifyListener((ModifyListener)this.mController);
        this.mTxtTreeFilter.addKeyListener((KeyListener)this.mController);
        this.mTxtTreeFilter.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (CheckConfigurationConfigureDialog.this.mDefaultFilterText.equals(CheckConfigurationConfigureDialog.this.mTxtTreeFilter.getText())) {
                    CheckConfigurationConfigureDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CheckConfigurationConfigureDialog.this.mTxtTreeFilter.selectAll();
                        }
                    });
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.mTreeViewer = new TreeViewer((Composite)knownModules, 2818);
        this.mTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.mTreeViewer.setContentProvider((IContentProvider)new MetaDataContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new MetaDataLabelProvider());
        this.mTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.mController);
        this.mTreeViewer.addDoubleClickListener((IDoubleClickListener)this.mController);
        this.mTreeViewer.getTree().addKeyListener((KeyListener)this.mController);
        this.mTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean passes = true;
                if (element instanceof RuleGroupMetadata) {
                    passes = !((RuleGroupMetadata)element).isHidden();
                } else if (element instanceof RuleMetadata) {
                    passes = !((RuleMetadata)element).isHidden();
                }
                return passes;
            }
        });
        this.mAddButton = new Button((Composite)knownModules, 8);
        this.mAddButton.setText(Messages.CheckConfigurationConfigureDialog_btnAdd);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        this.mAddButton.setLayoutData((Object)gd);
        this.mAddButton.addSelectionListener((SelectionListener)this.mController);
        return knownModules;
    }

    private Control createTableViewer(Composite parent) {
        this.mConfiguredModulesGroup = new Group(parent, 0);
        this.mConfiguredModulesGroup.setLayout((Layout)new GridLayout());
        this.mConfiguredModulesGroup.setText("\u0000");
        Table table = new Table((Composite)this.mConfiguredModulesGroup, 67618);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setAlignment(0x1000000);
        column1.setText(Messages.CheckConfigurationConfigureDialog_colEnabled);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.CheckConfigurationConfigureDialog_colModule);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.CheckConfigurationConfigureDialog_colSeverity);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        TableColumn column4 = new TableColumn(table, 0);
        column4.setText(Messages.CheckConfigurationConfigureDialog_colComment);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35));
        this.mTableViewer = new EnhancedCheckBoxTableViewer(table);
        ModuleLabelProvider multiProvider = new ModuleLabelProvider();
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)multiProvider);
        this.mTableViewer.setTableComparableProvider(multiProvider);
        this.mTableViewer.setTableSettingsProvider(multiProvider);
        this.mTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mTableViewer.addFilter(this.mGroupFilter);
        this.mTableViewer.installEnhancements();
        this.mTableViewer.addDoubleClickListener(this.mController);
        this.mTableViewer.addSelectionChangedListener(this.mController);
        this.mTableViewer.addCheckStateListener(this.mController);
        this.mTableViewer.getTable().addKeyListener((KeyListener)this.mController);
        Composite buttons = new Composite((Composite)this.mConfiguredModulesGroup, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData());
        this.mRemoveButton = new Button(buttons, 8);
        this.mRemoveButton.setText(Messages.CheckConfigurationConfigureDialog_btnRemove);
        this.mRemoveButton.setLayoutData((Object)new GridData());
        this.mRemoveButton.addSelectionListener((SelectionListener)this.mController);
        this.mEditButton = new Button(buttons, 8);
        this.mEditButton.setText(Messages.CheckConfigurationConfigureDialog_btnOpen);
        this.mEditButton.setLayoutData((Object)new GridData());
        this.mEditButton.addSelectionListener((SelectionListener)this.mController);
        return this.mConfiguredModulesGroup;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.mBtnOpenModuleOnAdd = new Button(composite, 32);
        this.mBtnOpenModuleOnAdd.setText(Messages.CheckConfigurationConfigureDialog_btnOpenModuleOnAdd);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = 5;
        this.mBtnOpenModuleOnAdd.setLayoutData((Object)gd);
        this.mBtnOpenModuleOnAdd.setSelection(CheckstyleUIPluginPrefs.getBoolean("open.module.editor.on.add"));
        this.mBtnOpenModuleOnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CheckstyleUIPluginPrefs.setBoolean("open.module.editor.on.add", ((Button)e.widget).getSelection());
                }
                catch (BackingStoreException e1) {
                    CheckstyleLog.log((Throwable)e1);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Control buttonBar = super.createButtonBar(composite);
        gd = new GridData(768);
        gd.horizontalAlignment = 3;
        buttonBar.setLayoutData((Object)gd);
        return composite;
    }

    private void initialize() {
        this.mConfigurable = this.mConfiguration.isConfigurable();
        try {
            this.mModules = this.mConfiguration.getModules();
        }
        catch (CheckstylePluginException e) {
            this.mModules = new ArrayList<Module>();
            CheckstyleUIPlugin.errorDialog(this.getShell(), e, true);
        }
        this.mTableViewer.setInput(this.mModules);
        this.setTitle(NLS.bind((String)Messages.CheckConfigurationConfigureDialog_titleMessageArea, (Object)this.mConfiguration.getType().getName(), (Object)this.mConfiguration.getName()));
        if (this.mConfigurable) {
            this.setMessage(Messages.CheckConfigurationConfigureDialog_msgEditConfig);
        } else {
            this.setMessage(Messages.CheckConfigurationConfigureDialog_msgReadonlyConfig);
        }
        this.setTitleImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.PLUGIN_LOGO));
        this.mAddButton.setEnabled(this.mConfigurable);
        this.mRemoveButton.setEnabled(this.mConfigurable);
        this.mTreeViewer.setInput((Object)MetadataFactory.getRuleGroupMetadata());
        List checkGroups = MetadataFactory.getRuleGroupMetadata();
        if (!checkGroups.isEmpty()) {
            StructuredSelection initialSelection = new StructuredSelection(checkGroups.get(0));
            this.mTreeViewer.setSelection((ISelection)initialSelection);
        }
    }

    public static String getDescriptionHtml(String description) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body style=\"margin: 3px; font-size: 11px; ");
        buf.append("font-family: verdana, 'trebuchet MS', helvetica, sans-serif;\">");
        buf.append(description != null ? description : Messages.CheckConfigurationConfigureDialog_txtNoDescription);
        buf.append("</body></html>");
        return buf.toString();
    }

    private class MetaDataContentProvider
    implements ITreeContentProvider {
        private MetaDataContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] ruleGroups = null;
            if (inputElement instanceof List) {
                ruleGroups = ((List)inputElement).toArray();
            }
            return ruleGroups;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof List) {
                children = this.getElements(parentElement);
            } else if (parentElement instanceof RuleGroupMetadata) {
                children = ((RuleGroupMetadata)parentElement).getRuleMetadata().toArray();
            }
            return children;
        }

        public Object getParent(Object element) {
            RuleGroupMetadata parent = null;
            if (element instanceof RuleMetadata) {
                parent = ((RuleMetadata)element).getGroup();
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            boolean hasChildren = false;
            if (element instanceof RuleGroupMetadata) {
                hasChildren = ((RuleGroupMetadata)element).getRuleMetadata().size() > 0;
            } else if (element instanceof RuleMetadata) {
                hasChildren = false;
            }
            return hasChildren;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MetaDataLabelProvider
    extends LabelProvider {
        private MetaDataLabelProvider() {
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof RuleGroupMetadata) {
                text = ((RuleGroupMetadata)element).getGroupName();
            } else if (element instanceof RuleMetadata) {
                text = ((RuleMetadata)element).getRuleName();
            }
            return text;
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof RuleGroupMetadata) {
                image = this.isGroupUsed((RuleGroupMetadata)element) ? CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.MODULEGROUP_TICKED_ICON) : CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.MODULEGROUP_ICON);
            } else if (element instanceof RuleMetadata) {
                image = this.isMetadataUsed((RuleMetadata)element) ? CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.MODULE_TICKED_ICON) : CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.MODULE_ICON);
            }
            return image;
        }

        private boolean isGroupUsed(RuleGroupMetadata group) {
            boolean used = true;
            for (RuleMetadata metadata : group.getRuleMetadata()) {
                if (this.isMetadataUsed(metadata)) continue;
                used = false;
                break;
            }
            return used;
        }

        private boolean isMetadataUsed(RuleMetadata metadata) {
            boolean used = false;
            if (CheckConfigurationConfigureDialog.this.mModules != null) {
                for (Module module : CheckConfigurationConfigureDialog.this.mModules) {
                    if (!metadata.equals(module.getMetaData())) continue;
                    used = true;
                    break;
                }
            }
            return used;
        }
    }

    private class ModuleLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableComparableProvider,
    ITableSettingsProvider {
        private ModuleLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            if (element instanceof Module) {
                Module module = (Module)element;
                switch (columnIndex) {
                    case 0: {
                        text = new String();
                        break;
                    }
                    case 1: {
                        text = module.getName() != null ? module.getName() : new String();
                        break;
                    }
                    case 2: {
                        text = module.getSeverity() != null ? module.getSeverity().name() : new String();
                        break;
                    }
                    case 3: {
                        text = module.getComment() != null ? module.getComment() : new String();
                        break;
                    }
                    default: {
                        text = new String();
                    }
                }
            }
            return text;
        }

        @Override
        public Comparable<?> getComparableValue(Object element, int col) {
            if (element instanceof Module && col == 0) {
                return Severity.ignore.equals((Object)((Module)element).getSeverity()) ? new Integer(0) : new Integer(1);
            }
            return this.getColumnText(element, col);
        }

        @Override
        public IDialogSettings getTableSettings() {
            String concreteViewId = CheckConfigurationConfigureDialog.class.getName();
            IDialogSettings workbenchSettings = CheckstyleUIPlugin.getDefault().getDialogSettings();
            IDialogSettings settings = workbenchSettings.getSection(concreteViewId);
            if (settings == null) {
                settings = workbenchSettings.addNewSection(concreteViewId);
            }
            return settings;
        }
    }

    private class PageController
    implements ISelectionChangedListener,
    ICheckStateListener,
    IDoubleClickListener,
    SelectionListener,
    KeyListener,
    ModifyListener {
        private PageController() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getViewer() == CheckConfigurationConfigureDialog.this.mTableViewer) {
                this.openModule(event.getSelection());
            } else if (event.getViewer() == CheckConfigurationConfigureDialog.this.mTreeViewer) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof RuleGroupMetadata) {
                    CheckConfigurationConfigureDialog.this.mTreeViewer.setExpandedState(element, !CheckConfigurationConfigureDialog.this.mTreeViewer.getExpandedState(element));
                } else {
                    this.newModule(event.getSelection());
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (CheckConfigurationConfigureDialog.this.mEditButton == e.widget) {
                this.openModule(CheckConfigurationConfigureDialog.this.mTableViewer.getSelection());
            } else if (CheckConfigurationConfigureDialog.this.mAddButton == e.widget) {
                this.newModule(CheckConfigurationConfigureDialog.this.mTreeViewer.getSelection());
            } else if (CheckConfigurationConfigureDialog.this.mRemoveButton == e.widget) {
                this.removeModule(CheckConfigurationConfigureDialog.this.mTableViewer.getSelection());
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.widget == CheckConfigurationConfigureDialog.this.mTableViewer.getTable()) {
                if (e.character == '\u007f' || e.keyCode == 0x1000003) {
                    this.removeModule(CheckConfigurationConfigureDialog.this.mTableViewer.getSelection());
                }
            } else if (e.widget == CheckConfigurationConfigureDialog.this.mTreeViewer.getTree()) {
                IStructuredSelection selection;
                Object element;
                if ((e.keyCode == 0x1000004 || e.character == ' ') && (element = (selection = (IStructuredSelection)CheckConfigurationConfigureDialog.this.mTreeViewer.getSelection()).getFirstElement()) instanceof RuleMetadata) {
                    this.newModule(CheckConfigurationConfigureDialog.this.mTreeViewer.getSelection());
                }
            } else if (e.widget == CheckConfigurationConfigureDialog.this.mTxtTreeFilter && e.keyCode == 0x1000002) {
                CheckConfigurationConfigureDialog.this.mTreeViewer.getTree().forceFocus();
            }
        }

        public void modifyText(ModifyEvent e) {
            if (!CheckConfigurationConfigureDialog.this.mDefaultFilterText.equals(CheckConfigurationConfigureDialog.this.mTxtTreeFilter.getText()) && !Strings.isNullOrEmpty((String)CheckConfigurationConfigureDialog.this.mTxtTreeFilter.getText())) {
                if (!Arrays.asList(CheckConfigurationConfigureDialog.this.mTableViewer.getFilters()).contains((Object)CheckConfigurationConfigureDialog.this.mTreeFilter)) {
                    CheckConfigurationConfigureDialog.this.mTreeViewer.addFilter((ViewerFilter)CheckConfigurationConfigureDialog.this.mTreeFilter);
                }
                CheckConfigurationConfigureDialog.this.mTreeViewer.refresh();
                CheckConfigurationConfigureDialog.this.mTreeViewer.expandAll();
            } else {
                CheckConfigurationConfigureDialog.this.mTreeViewer.removeFilter((ViewerFilter)CheckConfigurationConfigureDialog.this.mTreeFilter);
                CheckConfigurationConfigureDialog.this.mTreeViewer.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (CheckConfigurationConfigureDialog.this.mConfigurable) {
                Module module = (Module)event.getElement();
                if (event.getChecked()) {
                    Severity lastEnabled = module.getLastEnabledSeverity();
                    if (lastEnabled != null) {
                        module.setSeverity(lastEnabled);
                    } else {
                        module.setSeverity(module.getMetaData().getDefaultSeverityLevel());
                    }
                } else {
                    module.setSeverity(Severity.ignore);
                }
                CheckConfigurationConfigureDialog.this.mIsDirty = true;
                CheckConfigurationConfigureDialog.this.mTableViewer.refresh(module, true);
            }
            this.refreshTableViewerState();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            RuleMetadata meta;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            String description = null;
            if (element instanceof RuleGroupMetadata) {
                RuleGroupMetadata group = (RuleGroupMetadata)element;
                description = group.getDescription();
                CheckConfigurationConfigureDialog.this.mGroupFilter.setCurrentGroup(group);
                CheckConfigurationConfigureDialog.this.mConfiguredModulesGroup.setText(NLS.bind((String)Messages.CheckConfigurationConfigureDialog_lblConfiguredModules, (Object)group.getGroupName()));
                CheckConfigurationConfigureDialog.this.mTableViewer.refresh();
                this.refreshTableViewerState();
            } else if (element instanceof RuleMetadata) {
                RuleMetadata rule = (RuleMetadata)element;
                description = rule.getDescription();
                CheckConfigurationConfigureDialog.this.mGroupFilter.setCurrentGroup(rule.getGroup());
                CheckConfigurationConfigureDialog.this.mConfiguredModulesGroup.setText(NLS.bind((String)Messages.CheckConfigurationConfigureDialog_lblConfiguredModules, (Object)rule.getGroup().getGroupName()));
                CheckConfigurationConfigureDialog.this.mTableViewer.refresh();
                this.refreshTableViewerState();
            } else if (element instanceof Module && (meta = ((Module)element).getMetaData()) != null) {
                description = meta.getDescription();
            }
            String buf = CheckConfigurationConfigureDialog.getDescriptionHtml(description);
            CheckConfigurationConfigureDialog.this.mBrowserDescription.setText(buf);
        }

        private void openModule(ISelection selection) {
            Module m = (Module)((IStructuredSelection)selection).getFirstElement();
            if (m != null) {
                Module workingCopy = m.clone();
                RuleConfigurationEditDialog dialog = new RuleConfigurationEditDialog(CheckConfigurationConfigureDialog.this.getShell(), workingCopy, !CheckConfigurationConfigureDialog.this.mConfigurable, Messages.CheckConfigurationConfigureDialog_titleModuleConfigEditor);
                if (dialog.open() == 0 && CheckConfigurationConfigureDialog.this.mConfigurable) {
                    CheckConfigurationConfigureDialog.this.mModules.set(CheckConfigurationConfigureDialog.this.mModules.indexOf(m), workingCopy);
                    CheckConfigurationConfigureDialog.this.mIsDirty = true;
                    CheckConfigurationConfigureDialog.this.mTableViewer.refresh(true);
                    this.refreshTableViewerState();
                }
            }
        }

        private void newModule(ISelection selection) {
            if (CheckConfigurationConfigureDialog.this.mConfigurable) {
                boolean openOnAdd = CheckstyleUIPluginPrefs.getBoolean("open.module.editor.on.add");
                for (Object selectedElement : (IStructuredSelection)selection) {
                    if (selectedElement instanceof RuleGroupMetadata) {
                        List rules = ((RuleGroupMetadata)selectedElement).getRuleMetadata();
                        StructuredSelection allRulesOfGroupSelection = new StructuredSelection(rules);
                        this.newModule((ISelection)allRulesOfGroupSelection);
                        continue;
                    }
                    if (!(selectedElement instanceof RuleMetadata)) continue;
                    RuleMetadata metadata = (RuleMetadata)selectedElement;
                    if (metadata.isSingleton() && this.isAlreadyConfigured(metadata)) {
                        return;
                    }
                    Module workingCopy = new Module(metadata, false);
                    if (openOnAdd) {
                        RuleConfigurationEditDialog dialog = new RuleConfigurationEditDialog(CheckConfigurationConfigureDialog.this.getShell(), workingCopy, !CheckConfigurationConfigureDialog.this.mConfigurable, Messages.CheckConfigurationConfigureDialog_titleNewModule);
                        if (dialog.open() != 0 || !CheckConfigurationConfigureDialog.this.mConfigurable) continue;
                        CheckConfigurationConfigureDialog.this.mModules.add(workingCopy);
                        CheckConfigurationConfigureDialog.this.mIsDirty = true;
                        CheckConfigurationConfigureDialog.this.mTableViewer.refresh(true);
                        this.refreshTableViewerState();
                        CheckConfigurationConfigureDialog.this.mTreeViewer.refresh();
                        CheckConfigurationConfigureDialog.this.mTreeViewer.getTree().forceFocus();
                        continue;
                    }
                    CheckConfigurationConfigureDialog.this.mModules.add(workingCopy);
                    CheckConfigurationConfigureDialog.this.mIsDirty = true;
                    CheckConfigurationConfigureDialog.this.mTableViewer.refresh(true);
                    this.refreshTableViewerState();
                    CheckConfigurationConfigureDialog.this.mTreeViewer.refresh();
                }
            }
        }

        private void removeModule(ISelection selection) {
            if (!selection.isEmpty() && CheckConfigurationConfigureDialog.this.mConfigurable && MessageDialog.openConfirm((Shell)CheckConfigurationConfigureDialog.this.getShell(), (String)Messages.CheckConfigurationConfigureDialog_titleRemoveModules, (String)Messages.CheckConfigurationConfigureDialog_msgRemoveModules)) {
                for (Module m : (IStructuredSelection)selection) {
                    if (!m.getMetaData().isDeletable()) continue;
                    CheckConfigurationConfigureDialog.this.mModules.remove(m);
                    CheckConfigurationConfigureDialog.this.mIsDirty = true;
                    CheckConfigurationConfigureDialog.this.mTableViewer.refresh(true);
                    this.refreshTableViewerState();
                    CheckConfigurationConfigureDialog.this.mTreeViewer.refresh();
                }
            }
        }

        private void refreshTableViewerState() {
            int size = CheckConfigurationConfigureDialog.this.mModules != null ? CheckConfigurationConfigureDialog.this.mModules.size() : 0;
            int i = 0;
            while (i < size) {
                Module module = (Module)CheckConfigurationConfigureDialog.this.mModules.get(i);
                if (CheckConfigurationConfigureDialog.this.mConfigurable) {
                    CheckConfigurationConfigureDialog.this.mTableViewer.setChecked(module, !Severity.ignore.equals((Object)module.getSeverity()) || !module.getMetaData().hasSeverity());
                } else {
                    CheckConfigurationConfigureDialog.this.mTableViewer.setChecked(module, !Severity.ignore.equals((Object)module.getSeverity()) || !module.getMetaData().hasSeverity());
                    CheckConfigurationConfigureDialog.this.mTableViewer.setGrayed(module, !Severity.ignore.equals((Object)module.getSeverity()));
                }
                ++i;
            }
        }

        private boolean isAlreadyConfigured(RuleMetadata metadata) {
            String internalName = metadata.getInternalName();
            boolean containsModule = false;
            int i = 0;
            int size = CheckConfigurationConfigureDialog.this.mModules.size();
            while (i < size) {
                Module module = (Module)CheckConfigurationConfigureDialog.this.mModules.get(i);
                if (internalName.equals(module.getMetaData().getInternalName())) {
                    containsModule = true;
                    break;
                }
                ++i;
            }
            return containsModule;
        }
    }

    private class RuleGroupModuleFilter
    extends ViewerFilter {
        private RuleGroupMetadata mCurrentGroup;

        private RuleGroupModuleFilter() {
        }

        public void setCurrentGroup(RuleGroupMetadata groupMetaData) {
            this.mCurrentGroup = groupMetaData;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = false;
            Module module = (Module)element;
            RuleMetadata metaData = module.getMetaData();
            if (metaData == null) {
                return true;
            }
            RuleGroupMetadata moduleGroup = metaData.getGroup();
            if (this.mCurrentGroup == null || metaData.isHidden()) {
                result = false;
            } else if (this.mCurrentGroup == moduleGroup) {
                result = true;
            }
            return result;
        }
    }

    private class TreeFilter
    extends ViewerFilter {
        private TreeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = true;
            String filterText = CheckConfigurationConfigureDialog.this.mTxtTreeFilter.getText();
            if (element instanceof RuleMetadata) {
                result = this.selectRule((RuleMetadata)element, filterText);
            } else if (element instanceof RuleGroupMetadata) {
                result = this.selectGroup((RuleGroupMetadata)element, filterText);
            }
            return result;
        }

        private boolean selectRule(RuleMetadata element, String filterText) {
            Pattern matchPattern = Pattern.compile(Pattern.quote(filterText), 2);
            String ruleName = element.getRuleName();
            String internalName = element.getInternalName();
            String description = element.getDescription();
            boolean passes = ruleName != null && matchPattern.matcher(ruleName).find() || internalName != null && matchPattern.matcher(internalName).find() || description != null && matchPattern.matcher(description).find();
            return passes;
        }

        private boolean selectGroup(RuleGroupMetadata group, String filterText) {
            boolean hasAtLeastOneMatchingChild = false;
            for (RuleMetadata element : group.getRuleMetadata()) {
                if (!this.selectRule(element, filterText)) continue;
                hasAtLeastOneMatchingChild = true;
                break;
            }
            return hasAtLeastOneMatchingChild;
        }
    }
}

